/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.Properties;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
public class FieldCollapsingSearcher
extends Searcher {
    private static final CompoundName collapse = CompoundName.from((String)"collapse");
    private static final CompoundName collapsefield = CompoundName.from((String)"collapsefield");
    private static final CompoundName collapsesize = CompoundName.from((String)"collapsesize");
    private static final CompoundName collapseSummaryName = CompoundName.from((String)"collapse.summary");
    private static final String separator = ",";
    private static final int maxQueries = 4;
    private int defaultCollapseSize;
    private double extraFactor;

    public FieldCollapsingSearcher() {
        this(1, 2.0);
    }

    @Inject
    public FieldCollapsingSearcher(QrSearchersConfig config) {
        QrSearchersConfig.Com.Yahoo.Prelude.Searcher.FieldCollapsingSearcher s = config.com().yahoo().prelude().searcher().FieldCollapsingSearcher();
        this.init(s.collapsesize(), s.extrafactor());
    }

    public FieldCollapsingSearcher(int collapseSize, double extraFactor) {
        this.init(collapseSize, extraFactor);
    }

    private void init(int collapseSize, double extraFactor) {
        this.defaultCollapseSize = collapseSize;
        this.extraFactor = extraFactor;
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result resultSource;
        int hitsAfterCollapse;
        String collapseFieldParam = query.properties().getString(collapsefield);
        if (collapseFieldParam == null) {
            return execution.search(query);
        }
        Object[] collapseFields = collapseFieldParam.split(separator);
        int globalCollapseSize = query.properties().getInteger(collapsesize, this.defaultCollapseSize);
        query.properties().set(collapse, "0");
        int hitsToRequest = query.getHits() != 0 ? (int)Math.ceil((double)(query.getOffset() + query.getHits() + 1) * this.extraFactor) : 0;
        int nextOffset = 0;
        boolean moreHitsAvailable = true;
        HashMap<String, Integer> knownCollapses = new HashMap<String, Integer>();
        Result result = new Result(query);
        int performedQueries = 0;
        String collapseSummary = query.properties().getString(collapseSummaryName);
        String summaryClass = collapseSummary == null ? query.getPresentation().getSummary() : collapseSummary;
        query.trace("Collapsing by '" + Arrays.toString(collapseFields) + "' using summary '" + collapseSummary + "'", 2);
        do {
            resultSource = this.search(query.clone(), execution, nextOffset, hitsToRequest);
            this.fill(resultSource, summaryClass, execution);
            this.collapse(result, knownCollapses, resultSource, (String[])collapseFields, query.properties(), globalCollapseSize);
            hitsAfterCollapse = result.getHitCount();
            if (resultSource.getTotalHitCount() < (long)(hitsToRequest + nextOffset)) {
                moreHitsAvailable = false;
            }
            nextOffset += hitsToRequest;
            if (hitsAfterCollapse >= query.getOffset() + query.getHits()) continue;
            hitsToRequest = (int)Math.ceil((double)hitsToRequest * this.extraFactor);
        } while (hitsToRequest != 0 && hitsAfterCollapse < query.getOffset() + query.getHits() && moreHitsAvailable && ++performedQueries <= 4);
        result.mergeWith(resultSource);
        result.hits().trim(query.getOffset(), query.getHits());
        query.properties().set(collapse, "1");
        return result;
    }

    private Result search(Query query, Execution execution, int offset, int hits) {
        query.setOffset(offset);
        query.setHits(hits);
        return execution.search(query);
    }

    private void collapse(Result result, Map<String, Integer> knownCollapses, Result resultSource, String[] collapseFields, Properties queryProperties, int globalCollapseSize) {
        for (Hit unknownHit : resultSource.hits()) {
            if (!(unknownHit instanceof FastHit)) {
                result.hits().add(unknownHit);
                continue;
            }
            FastHit hit = (FastHit)unknownHit;
            boolean addHit = true;
            for (String collapseField : collapseFields) {
                String collapseId;
                Object peek = hit.getField(collapseField);
                String string = collapseId = peek != null ? peek.toString() : null;
                if (collapseId == null) continue;
                String collapseKey = collapseField + "@" + collapseId;
                if (knownCollapses.containsKey(collapseKey)) {
                    int collapseSize;
                    int numHitsThisField = knownCollapses.get(collapseKey);
                    if (numHitsThisField < (collapseSize = this.getCollapseSize(queryProperties, collapseField, globalCollapseSize))) {
                        knownCollapses.put(collapseKey, ++numHitsThisField);
                        continue;
                    }
                    addHit = false;
                    break;
                }
                knownCollapses.put(collapseKey, 1);
            }
            if (!addHit) continue;
            result.hits().add(hit);
        }
    }

    private int getCollapseSize(Properties properties, String fieldName, int globalCollapseSize) {
        Integer fieldCollapseSize = properties.getInteger(collapsesize.append(fieldName));
        if (fieldCollapseSize != null) {
            return fieldCollapseSize;
        }
        return globalCollapseSize;
    }
}

