/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.language.Linguistics;
import com.yahoo.language.process.CharacterClasses;
import com.yahoo.language.process.SpecialTokens;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.parser.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class Tokenizer {
    private final List<Token> tokens = new ArrayList<Token>();
    private String source;
    private SpecialTokens specialTokens = null;
    private boolean substringSpecialTokens = false;
    private final CharacterClasses characterClasses;
    private int parensToEat = 0;
    private int indexLastExplicitlyChangedAt = 0;

    public Tokenizer(Linguistics linguistics) {
        this.characterClasses = linguistics.getCharacterClasses();
    }

    public void setSpecialTokens(SpecialTokens specialTokens) {
        this.specialTokens = specialTokens;
    }

    public void setSubstringSpecialTokens(boolean substringSpecialTokens) {
        this.substringSpecialTokens = substringSpecialTokens;
    }

    public List<Token> tokenize(String string) {
        return this.tokenize(string, new IndexFacts().newSession(Set.of(), Set.of()));
    }

    public List<Token> tokenize(String string, IndexFacts.Session indexFacts) {
        return this.tokenize(string, "default", indexFacts);
    }

    public List<Token> tokenize(String string, String defaultIndexName, IndexFacts.Session indexFacts) {
        this.source = string;
        this.tokens.clear();
        this.parensToEat = 0;
        Index topLevelIndex = Index.nullIndex;
        Index defaultIndex = indexFacts.getIndex(defaultIndexName);
        if (defaultIndexName != null) {
            topLevelIndex = defaultIndex;
        }
        Index currentIndex = topLevelIndex;
        for (int i = 0; i < this.source.length(); ++i) {
            if (currentIndex.isExact()) {
                i = this.consumeExact(i, currentIndex);
                currentIndex = topLevelIndex;
            } else {
                i = this.consumeSpecialToken(i);
            }
            if (i >= this.source.length()) break;
            int c = this.source.codePointAt(i);
            if (this.characterClasses.isSymbol(c)) {
                this.addToken(Token.Kind.WORD, Character.toString(c), i, i + 1);
                continue;
            }
            if (this.characterClasses.isLetterOrDigit(c) || c == 39 && this.acceptApostropheAsWordCharacter(currentIndex)) {
                i = this.consumeWordOrNumber(i, currentIndex);
                continue;
            }
            if (Character.isWhitespace(c)) {
                this.addToken(Token.Kind.SPACE, " ", i, i + 1);
                continue;
            }
            if (c == 34 || c == 8220 || c == 8221 || c == 8222 || c == 8223 || c == 8249 || c == 8250 || c == 171 || c == 187 || c == 12317 || c == 12318 || c == 12319 || c == 65282) {
                this.addToken(Token.Kind.QUOTE, "\"", i, i + 1);
                continue;
            }
            if (c == 45 || c == 65293) {
                this.addToken(Token.Kind.MINUS, "-", i, i + 1);
                continue;
            }
            if (c == 43 || c == 65291) {
                this.addToken(Token.Kind.PLUS, "+", i, i + 1);
                continue;
            }
            if (c == 46 || c == 65294) {
                this.addToken(Token.Kind.DOT, ".", i, i + 1);
                continue;
            }
            if (c == 44 || c == 65292) {
                this.addToken(Token.Kind.COMMA, ",", i, i + 1);
                continue;
            }
            if (c == 58 || c == 65306) {
                currentIndex = this.determineCurrentIndex(defaultIndex, indexFacts);
                this.addToken(Token.Kind.COLON, ":", i, i + 1);
                continue;
            }
            if (c == 40 || c == 65288) {
                this.addToken(Token.Kind.LBRACE, "(", i, i + 1);
                ++this.parensToEat;
                continue;
            }
            if (c == 41 || c == 65289) {
                this.addToken(Token.Kind.RBRACE, ")", i, i + 1);
                --this.parensToEat;
                if (this.parensToEat >= 0) continue;
                this.parensToEat = 0;
                continue;
            }
            if (c == 91 || c == 65339) {
                this.addToken(Token.Kind.LSQUAREBRACKET, "[", i, i + 1);
                continue;
            }
            if (c == 93 || c == 65341) {
                this.addToken(Token.Kind.RSQUAREBRACKET, "]", i, i + 1);
                continue;
            }
            if (c == 59 || c == 65307) {
                this.addToken(Token.Kind.SEMICOLON, ";", i, i + 1);
                continue;
            }
            if (c == 62 || c == 65310) {
                this.addToken(Token.Kind.GREATER, ">", i, i + 1);
                continue;
            }
            if (c == 60 || c == 65308) {
                this.addToken(Token.Kind.SMALLER, "<", i, i + 1);
                continue;
            }
            if (c == 33 || c == 65281) {
                this.addToken(Token.Kind.EXCLAMATION, "!", i, i + 1);
                continue;
            }
            if (c == 95 || c == 65343) {
                this.addToken(Token.Kind.UNDERSCORE, "_", i, i + 1);
                continue;
            }
            if (c == 94 || c == 65342) {
                this.addToken(Token.Kind.HAT, "^", i, i + 1);
                continue;
            }
            if (c == 42 || c == 65290) {
                this.addToken(Token.Kind.STAR, "*", i, i + 1);
                continue;
            }
            if (c == 36 || c == 65284) {
                this.addToken(Token.Kind.DOLLAR, "$", i, i + 1);
                continue;
            }
            this.addToken(Token.Kind.NOISE, "<NOISE>", i, i + 1);
        }
        this.addToken(Token.Kind.EOF, "<EOF>", this.source.length(), this.source.length());
        this.source = null;
        return this.tokens;
    }

    private boolean acceptApostropheAsWordCharacter(Index currentIndex) {
        if (!currentIndex.isUriIndex() && !currentIndex.isHostIndex()) {
            return true;
        }
        block4: for (int i = this.tokens.size() - 1; i >= 0; --i) {
            switch (this.tokens.get((int)i).kind) {
                case COLON: {
                    if (i != this.indexLastExplicitlyChangedAt) continue block4;
                    return false;
                }
                case SPACE: {
                    return true;
                }
            }
        }
        return true;
    }

    private Index determineCurrentIndex(Index defaultIndex, IndexFacts.Session indexFacts) {
        String canonicIndexName;
        Index index;
        int backtrack = this.tokens.size();
        int tokencnt = 0;
        for (int i = 1; i <= this.tokens.size(); ++i) {
            backtrack = this.tokens.size() - i;
            Token lookAt = this.tokens.get(backtrack);
            if (lookAt.kind != Token.Kind.WORD && lookAt.kind != Token.Kind.UNDERSCORE && lookAt.kind != Token.Kind.NUMBER && lookAt.kind != Token.Kind.DOT) {
                ++backtrack;
                break;
            }
            ++tokencnt;
        }
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < tokencnt; ++i) {
            Token useToken = this.tokens.get(backtrack + i);
            tmp.append(useToken.image);
        }
        String indexName = tmp.toString();
        if (indexName.length() > 0 && !(index = indexFacts.getIndex(canonicIndexName = indexFacts.getCanonicName(indexName))).isNull()) {
            this.indexLastExplicitlyChangedAt = this.tokens.size();
            return index;
        }
        return defaultIndex;
    }

    private int consumeSpecialToken(int start) {
        SpecialTokens.Token token = this.getSpecialToken(start);
        if (token == null) {
            return start;
        }
        this.tokens.add(this.toToken(token, start, this.source));
        return start + token.token().length();
    }

    private SpecialTokens.Token getSpecialToken(int start) {
        if (this.specialTokens == null) {
            return null;
        }
        return this.specialTokens.tokenize(this.source.substring(start), this.substringSpecialTokens);
    }

    private int consumeExact(int start, Index index) {
        if (index.getExactTerminator() == null) {
            return this.consumeHeuristicExact(start);
        }
        return this.consumeToTerminator(start, index.getExactTerminator());
    }

    private boolean looksLikeExactEnd(int end) {
        int parens = this.parensToEat;
        boolean wantStar = true;
        boolean wantBang = true;
        boolean eatDigit = false;
        int endLimit = this.source.length();
        while (end < endLimit) {
            char c;
            if (Character.isWhitespace(c = this.source.charAt(end++))) {
                return true;
            }
            if (eatDigit && Character.isDigit(c)) continue;
            eatDigit = false;
            if (wantBang && c == '!') {
                eatDigit = true;
                while (end < endLimit && (c = this.source.charAt(end)) == '!') {
                    ++end;
                    eatDigit = false;
                }
                wantBang = false;
                continue;
            }
            if (wantStar && (c == '*' || c == '\uff0a')) {
                wantStar = false;
                continue;
            }
            if (parens > 0 && c == ')') {
                --parens;
                continue;
            }
            return false;
        }
        return true;
    }

    private int consumeHeuristicExact(int start) {
        int curPos = -1;
        int actualStart = -1;
        int starPos = -1;
        int endLimit = this.source.length();
        boolean suffStar = false;
        boolean isQuoted = false;
        boolean seenSome = false;
        boolean wantStartQuote = true;
        boolean wantEndQuote = false;
        boolean wantStartStar = true;
        boolean ignWS = true;
        for (curPos = start; curPos < endLimit; ++curPos) {
            char c = this.source.charAt(curPos);
            if (Character.isWhitespace(c)) {
                if (ignWS) continue;
                if (!wantEndQuote) break;
            }
            ignWS = false;
            if (c == '\"') {
                if (wantStartQuote) {
                    wantStartQuote = false;
                    wantEndQuote = true;
                    actualStart = curPos + 1;
                    continue;
                }
                if (!wantEndQuote || !this.looksLikeExactEnd(curPos + 1)) continue;
                seenSome = true;
                wantEndQuote = false;
                isQuoted = true;
                break;
            }
            if (wantEndQuote) continue;
            if ((c == '*' || c == '\uff0a') && wantStartStar) {
                suffStar = true;
                wantStartStar = false;
                starPos = curPos;
                continue;
            }
            if ((c == '!' || c == '*' || c == '\uff0a') && seenSome && this.looksLikeExactEnd(curPos) || c == ')' && seenSome && this.looksLikeExactEnd(curPos)) break;
            if (seenSome) continue;
            actualStart = curPos;
            seenSome = true;
            wantStartQuote = false;
            wantStartStar = false;
        }
        int end = curPos;
        if (wantEndQuote) {
            isQuoted = false;
            actualStart = -1;
            starPos = -1;
            suffStar = false;
            seenSome = false;
            wantStartStar = true;
            ignWS = true;
            for (curPos = start; curPos < endLimit; ++curPos) {
                char c = this.source.charAt(curPos);
                if (Character.isWhitespace(c)) {
                    if (!ignWS) break;
                    continue;
                }
                ignWS = false;
                if ((c == '*' || c == '\uff0a') && wantStartStar) {
                    suffStar = true;
                    wantStartStar = false;
                    starPos = curPos;
                    continue;
                }
                if ((c == '!' || c == '*' || c == '\uff0a') && seenSome || c == ')' && seenSome && this.parensToEat > 0) break;
                if (seenSome) continue;
                actualStart = curPos;
                seenSome = true;
                wantStartStar = false;
            }
            end = curPos;
        }
        if (!seenSome) {
            if (suffStar) {
                suffStar = false;
                actualStart = starPos;
            } else {
                actualStart = start;
            }
        }
        if (suffStar) {
            this.addToken(Token.Kind.STAR, "*", starPos, starPos + 1);
        }
        this.tokens.add(new Token(Token.Kind.WORD, this.source.substring(actualStart, end), true, new Substring(actualStart, end, this.source)));
        if (isQuoted) {
            ++end;
        }
        return end;
    }

    private int consumeToTerminator(int start, String terminator) {
        int end;
        for (end = start; end < this.source.length() && !this.terminatorStartsAt(end, terminator); ++end) {
        }
        this.tokens.add(new Token(Token.Kind.WORD, this.source.substring(start, end), true, new Substring(start, end, this.source)));
        if (end >= this.source.length()) {
            return end;
        }
        return end + terminator.length();
    }

    private boolean terminatorStartsAt(int start, String terminator) {
        int terminatorPosition = 0;
        while (terminatorPosition + start < this.source.length()) {
            if (this.source.charAt(start + terminatorPosition) != terminator.charAt(terminatorPosition)) {
                return false;
            }
            if (++terminatorPosition < terminator.length()) continue;
            return true;
        }
        return false;
    }

    private int consumeWordOrNumber(int start, Index currentIndex) {
        int tokenEnd;
        int c;
        SpecialTokens.Token substringToken = null;
        boolean digitsOnly = true;
        boolean quotesOnly = true;
        for (tokenEnd = start; !(tokenEnd >= this.source.length() || this.substringSpecialTokens && (substringToken = this.getSpecialToken(tokenEnd)) != null); tokenEnd += Character.charCount(c)) {
            c = this.source.codePointAt(tokenEnd);
            if (this.characterClasses.isLetter(c)) {
                digitsOnly = false;
                quotesOnly = false;
                continue;
            }
            if (this.characterClasses.isLatinDigit(c)) {
                quotesOnly = false;
                continue;
            }
            if (c != 39 || !this.acceptApostropheAsWordCharacter(currentIndex)) break;
            digitsOnly = false;
        }
        if (tokenEnd > start) {
            if (quotesOnly) {
                this.addToken(Token.Kind.NOISE, this.source.substring(start, tokenEnd), start, tokenEnd);
            } else {
                this.addToken(digitsOnly ? Token.Kind.NUMBER : Token.Kind.WORD, this.source.substring(start, tokenEnd), start, tokenEnd);
            }
        }
        if (substringToken == null) {
            return --tokenEnd;
        }
        this.addToken(this.toToken(substringToken, tokenEnd, this.source));
        return --tokenEnd + substringToken.token().length();
    }

    private void addToken(Token.Kind kind, String word, int start, int end) {
        this.addToken(new Token(kind, word, false, new Substring(start, end, this.source)));
    }

    private void addToken(Token token) {
        this.tokens.add(token);
    }

    public Token toToken(SpecialTokens.Token specialToken, int start, String rawSource) {
        return new Token(Token.Kind.WORD, specialToken.replacement(), true, new Substring(start, start + specialToken.token().length(), rawSource));
    }
}

