/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.RankItem;

public class TermType {
    public static final TermType RANK = new TermType("rank", Item.ItemType.RANK, RankItem.class, null, "$");
    public static final TermType AND = new TermType("and", Item.ItemType.AND, AndItem.class, null, "+");
    public static final TermType OR = new TermType("or", Item.ItemType.OR, OrItem.class, null, "?");
    public static final TermType NOT = new TermType("not", Item.ItemType.NOT, NotItem.class, null, "-");
    public static final TermType PHRASE = new TermType("phrase", Item.ItemType.PHRASE, PhraseItem.class, null, "\"");
    public static final TermType EQUIV = new TermType("equiv", Item.ItemType.EQUIV, EquivItem.class, null, "");
    public static final TermType DEFAULT = new TermType("", Item.ItemType.AND, CompositeItem.class, AndItem.class, "");
    public final String name;
    private final Item.ItemType itemType;
    private final String sign;
    private final Class<? extends CompositeItem> instanceClass;
    private final Class<? extends CompositeItem> itemClass;

    private TermType(String name, Item.ItemType itemType, Class<? extends CompositeItem> itemClass, Class<? extends CompositeItem> instanceClass, String sign) {
        this.name = name;
        this.itemType = itemType;
        this.itemClass = itemClass;
        this.instanceClass = instanceClass == null ? itemClass : instanceClass;
        this.sign = sign;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends CompositeItem> getItemClass() {
        return this.itemClass;
    }

    public boolean hasItemClass(Class<?> theClass) {
        return this.getItemClass() == theClass;
    }

    public Item createItemClass() {
        try {
            return this.instanceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create an instance for item " + this, e);
        }
    }

    public String toSign() {
        return this.sign;
    }

    public Item.ItemType toItemType() {
        return this.itemType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermType)) {
            return false;
        }
        TermType other = (TermType)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "term type '" + this.name + "'";
    }
}

