/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.InItem;
import com.yahoo.prelude.query.Item;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NumericInItem
extends InItem {
    private Set<Long> tokens = new HashSet<Long>(1000);

    public NumericInItem(String indexName) {
        super(indexName);
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NUMERIC_IN;
    }

    @Override
    public int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        return 1;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.tokens.size(), (ByteBuffer)buffer);
        NumericInItem.putString(this.getIndexName(), buffer);
        for (Long token : this.tokens) {
            buffer.putLong(token);
        }
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append(this.getIndexName());
        buffer.append("{");
        for (Long token : this.tokens) {
            buffer.append(token.toString());
            if (token < Integer.MIN_VALUE || token > Integer.MAX_VALUE) {
                buffer.append("L");
            }
            buffer.append(",");
        }
        if (!this.tokens.isEmpty()) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("}");
    }

    public void addToken(long token) {
        this.tokens.add(token);
    }

    public Collection<Long> getTokens() {
        return Set.copyOf(this.tokens);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumericInItem other = (NumericInItem)o;
        return Objects.equals(this.tokens, other.tokens);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokens);
    }
}

