/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.CompositeTaggableItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.protect.Validator;
import java.util.Collection;

public class EquivItem
extends CompositeTaggableItem {
    public EquivItem() {
    }

    public EquivItem(Item item) {
        TaggableItem back;
        this.addItem(item);
        if (item.connectedItem != null) {
            this.setConnectivity(item.connectedItem, item.connectivity);
            item.connectedItem = null;
            item.connectivity = 0.0;
        }
        if ((back = (TaggableItem)((Object)item.connectedBacklink)) != null) {
            back.setConnectivity(this, back.getConnectivity());
            item.connectedBacklink = null;
        }
        if (item.explicitSignificance) {
            this.setSignificance(item.significance);
        }
        this.setWeight(item.getWeight());
        item.setHasUniqueID(false);
    }

    public EquivItem(Item item, Collection<String> words) {
        this(item);
        String idx = ((IndexedItem)((Object)item)).getIndexName();
        for (String word : words) {
            WordItem witem = new WordItem(word, idx);
            this.addItem(witem);
        }
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.EQUIV;
    }

    @Override
    public String getName() {
        return "EQUIV";
    }

    @Override
    protected void adding(Item item) {
        super.adding(item);
        Validator.ensure((String)("Could not add an item of type " + item.getItemType() + ": Equiv can only have word, wordAlternatives, int, exact, or phrase as children"), (boolean)EquivItem.acceptsChildrenOfType(item.getItemType()));
    }

    @Override
    public boolean acceptsItemsOfType(Item.ItemType itemType) {
        return EquivItem.acceptsChildrenOfType(itemType);
    }

    public static boolean acceptsChildrenOfType(Item.ItemType itemType) {
        return itemType == Item.ItemType.WORD || itemType == Item.ItemType.WORD_ALTERNATIVES || itemType == Item.ItemType.INT || itemType == Item.ItemType.EXACT || itemType == Item.ItemType.PHRASE;
    }
}

