/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors.tracing;

import com.yahoo.vespa.streamingvisitors.tracing.MonotonicNanoClock;
import com.yahoo.vespa.streamingvisitors.tracing.SamplingStrategy;

public class MaxSamplesPerPeriod
implements SamplingStrategy {
    private final MonotonicNanoClock nanoClock;
    private final long maxSamplesPerPeriod;
    private final long periodLengthInNanos;
    private long currentSamplingPeriod = 0L;
    private long samplesInCurrentPeriod = 0L;

    public MaxSamplesPerPeriod(MonotonicNanoClock nanoClock, long periodLengthInNanos, long maxSamplesPerPeriod) {
        this.nanoClock = nanoClock;
        this.periodLengthInNanos = periodLengthInNanos;
        this.maxSamplesPerPeriod = maxSamplesPerPeriod;
    }

    public static MaxSamplesPerPeriod withSteadyClock(long periodLengthInNanos, long maxSamplesPerPeriod) {
        return new MaxSamplesPerPeriod(System::nanoTime, periodLengthInNanos, maxSamplesPerPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldSample() {
        long now = this.nanoClock.nanoTimeNow();
        long period = now / this.periodLengthInNanos;
        MaxSamplesPerPeriod maxSamplesPerPeriod = this;
        synchronized (maxSamplesPerPeriod) {
            if (period != this.currentSamplingPeriod) {
                this.currentSamplingPeriod = period;
                this.samplesInCurrentPeriod = 1L;
                return true;
            }
            if (this.samplesInCurrentPeriod >= this.maxSamplesPerPeriod) {
                return false;
            }
            ++this.samplesInCurrentPeriod;
            return true;
        }
    }
}

