/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.container.QrSearchersConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.search.schema.Cluster;
import com.yahoo.search.schema.DocumentSummary;
import com.yahoo.search.schema.RankProfile;
import com.yahoo.search.schema.Schema;
import java.util.ArrayList;
import java.util.List;

class SchemaInfoConfigurer {
    SchemaInfoConfigurer() {
    }

    static List<Schema> toSchemas(SchemaInfoConfig schemaInfoConfig) {
        return schemaInfoConfig.schema().stream().map(SchemaInfoConfigurer::toSchema).toList();
    }

    static Schema toSchema(SchemaInfoConfig.Schema schemaInfoConfig) {
        Schema.Builder builder = new Schema.Builder(schemaInfoConfig.name());
        for (SchemaInfoConfig.Schema.Rankprofile profileConfig : schemaInfoConfig.rankprofile()) {
            RankProfile.Builder profileBuilder = new RankProfile.Builder(profileConfig.name());
            profileBuilder.setHasSummaryFeatures(profileConfig.hasSummaryFeatures());
            profileBuilder.setHasRankFeatures(profileConfig.hasRankFeatures());
            for (SchemaInfoConfig.Schema.Rankprofile.Input inputConfig : profileConfig.input()) {
                profileBuilder.addInput(inputConfig.name(), RankProfile.InputType.fromSpec(inputConfig.type()));
            }
            builder.add(profileBuilder.build());
        }
        for (SchemaInfoConfig.Schema.Summaryclass summaryConfig : schemaInfoConfig.summaryclass()) {
            DocumentSummary.Builder summaryBuilder = new DocumentSummary.Builder(summaryConfig.name());
            for (SchemaInfoConfig.Schema.Summaryclass.Fields field : summaryConfig.fields()) {
                if (field.dynamic()) {
                    summaryBuilder.setDynamic(true);
                }
                summaryBuilder.add(new DocumentSummary.Field(field.name(), field.type()));
            }
            builder.add(summaryBuilder.build());
        }
        return builder.build();
    }

    static List<Cluster> toClusters(QrSearchersConfig config) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (QrSearchersConfig.Searchcluster searchCluster : config.searchcluster()) {
            String clusterName = searchCluster.name();
            Cluster.Builder clusterInfo = new Cluster.Builder(clusterName);
            clusterInfo.setStreaming(searchCluster.indexingmode() == QrSearchersConfig.Searchcluster.Indexingmode.Enum.STREAMING);
            for (String schemaDef : searchCluster.searchdef()) {
                clusterInfo.addSchema(schemaDef);
            }
            clusters.add(clusterInfo.build());
        }
        return clusters;
    }
}

