/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.api.annotations.Beta;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Beta
public class Cluster {
    private final String name;
    private final boolean isStreaming;
    private final Set<String> schemas;

    private Cluster(Builder builder) {
        this.name = builder.name;
        this.isStreaming = builder.isStreaming;
        this.schemas = Set.copyOf(builder.schemas);
    }

    public String name() {
        return this.name;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public Set<String> schemas() {
        return this.schemas;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.isStreaming != other.isStreaming()) {
            return false;
        }
        return this.schemas.equals(other.schemas);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isStreaming, this.schemas);
    }

    public String toString() {
        return "cluster '" + this.name + "'";
    }

    public static class Builder {
        private final String name;
        private boolean isStreaming = false;
        private final Set<String> schemas = new HashSet<String>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder setStreaming(boolean isStreaming) {
            this.isStreaming = isStreaming;
            return this;
        }

        public Builder addSchema(String schema) {
            this.schemas.add(schema);
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }
    }
}

