/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.rewrite.rewriters;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.search.Query;
import com.yahoo.search.query.rewrite.QueryRewriteSearcher;
import com.yahoo.search.query.rewrite.RewriterFeatures;
import com.yahoo.search.query.rewrite.RewriterUtils;
import com.yahoo.search.query.rewrite.RewritesConfig;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;

@After(value={"QLAS"})
@Provides(value={"MisspellRewriter"})
public class MisspellRewriter
extends QueryRewriteSearcher {
    private final boolean SKIP_REWRITER_IF_REWRITTEN = false;
    public static final String REWRITER_NAME = "MisspellRewriter";
    private Logger logger = Logger.getLogger(MisspellRewriter.class.getName());

    @Inject
    public MisspellRewriter(ComponentId id) {
        super(id);
    }

    public MisspellRewriter() {
    }

    @Override
    public boolean configure(FileAcquirer fileAcquirer, RewritesConfig config, HashMap<String, File> fileList) {
        return true;
    }

    @Override
    public HashMap<String, Object> rewrite(Query query, String dictKey) throws RuntimeException {
        Boolean rewritten = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Rewritten", rewritten);
        result.put("DictKey", dictKey);
        RewriterUtils.log(this.logger, query, "In MisspellRewriter");
        String qssRw = this.getQPConfig(query, "QSSRewrite");
        String qssSugg = this.getQPConfig(query, "QSSSuggest");
        boolean isQSSRw = false;
        boolean isQSSSugg = false;
        if (qssRw != null) {
            isQSSRw = qssRw.equalsIgnoreCase("true");
        }
        if (qssSugg != null) {
            isQSSSugg = qssSugg.equalsIgnoreCase("true");
        }
        if (!isQSSRw && !isQSSSugg) {
            return result;
        }
        String rewrites = RewriterUtils.getSpellCorrected(query, isQSSRw, isQSSSugg);
        if (rewrites == null) {
            RewriterUtils.log(this.logger, query, "No rewrite is retrieved");
            return result;
        }
        RewriterUtils.log(this.logger, query, "Retrieved spell corrected query: " + rewrites);
        query = RewriterFeatures.addRewritesAsEquiv(query, dictKey, rewrites, false, 0);
        rewritten = true;
        RewriterUtils.log(this.logger, query, "MisspellRewriter final query: " + query.toDetailString());
        result.put("Rewritten", rewritten);
        result.put("DictKey", rewrites);
        return result;
    }

    @Override
    public boolean getSkipRewriterIfRewritten() {
        return false;
    }

    @Override
    public String getRewriterName() {
        return REWRITER_NAME;
    }

    @Override
    public HashMap<String, String> getDefaultFSAs() {
        return null;
    }
}

