/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.search.query.profile.BackedOverridableQueryProfile;
import com.yahoo.search.query.profile.CopyOnWriteContent;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVisitor;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryProfileVariant
implements Cloneable,
Comparable<QueryProfileVariant> {
    private List<QueryProfile> inherited = null;
    private final DimensionValues dimensionValues;
    private Map<String, Object> values;
    private final Map<String, Boolean> overridable = new HashMap<String, Boolean>();
    private boolean frozen = false;
    private final QueryProfile owner;

    public QueryProfileVariant(DimensionValues dimensionValues, QueryProfile owner) {
        this.dimensionValues = dimensionValues;
        this.owner = owner;
    }

    public DimensionValues getDimensionValues() {
        return this.dimensionValues;
    }

    public Map<String, Object> values() {
        if (this.values == null) {
            if (this.frozen) {
                return Map.of();
            }
            this.values = new HashMap<String, Object>();
        }
        return this.values;
    }

    public List<QueryProfile> inherited() {
        if (this.inherited == null) {
            if (this.frozen) {
                return List.of();
            }
            this.inherited = new ArrayList<QueryProfile>();
        }
        return this.inherited;
    }

    public Object set(String key, Object newValue) {
        Object oldValue;
        Object combinedOrNull;
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        if ((combinedOrNull = QueryProfile.combineValues(newValue, oldValue = this.values.get(key))) instanceof BackedOverridableQueryProfile) {
            ((QueryProfile)combinedOrNull).setDimensions(this.owner.getDimensions().toArray(new String[0]));
        }
        if (combinedOrNull != null) {
            this.values.put(key, combinedOrNull);
        }
        return combinedOrNull;
    }

    public void setOverridable(String key, boolean overridable) {
        this.overridable.put(key, overridable);
    }

    public Boolean isOverridable(String key) {
        return this.overridable.get(key);
    }

    public void inherit(QueryProfile profile) {
        if (this.inherited == null) {
            this.inherited = new ArrayList<QueryProfile>(1);
        }
        this.inherited.add(profile);
    }

    @Override
    public int compareTo(QueryProfileVariant other) {
        return this.dimensionValues.compareTo(other.dimensionValues);
    }

    public boolean matches(DimensionValues givenDimensionValues) {
        return this.dimensionValues.matches(givenDimensionValues);
    }

    public void accept(boolean allowContent, QueryProfileType type, QueryProfileVisitor visitor, DimensionBinding dimensionBinding) {
        if (allowContent) {
            String key = visitor.getLocalKey();
            if (key != null) {
                if (type != null) {
                    type.unalias(key);
                }
                visitor.acceptValue(key, this.values().get(key), dimensionBinding, this.owner, this.dimensionValues);
                if (visitor.isDone()) {
                    return;
                }
            } else {
                for (Map.Entry<String, Object> entry : this.values().entrySet()) {
                    visitor.acceptValue(entry.getKey(), entry.getValue(), dimensionBinding, this.owner, this.dimensionValues);
                    if (!visitor.isDone()) continue;
                    return;
                }
            }
        }
        for (QueryProfile profile : this.inherited()) {
            if (visitor.visitInherited()) {
                profile.accept(allowContent, visitor, dimensionBinding.createFor(profile.getDimensions()), this.owner);
            }
            if (!visitor.isDone()) continue;
            return;
        }
    }

    public void freeze() {
        if (this.frozen) {
            return;
        }
        if (this.inherited != null) {
            this.inherited = List.copyOf(this.inherited);
        }
        if (this.values != null) {
            this.values = Map.copyOf(this.values);
        }
        this.frozen = true;
    }

    public QueryProfileVariant clone() {
        if (this.frozen) {
            return this;
        }
        try {
            QueryProfileVariant clone = (QueryProfileVariant)super.clone();
            if (this.inherited != null) {
                clone.inherited = new ArrayList<QueryProfile>(this.inherited);
            }
            clone.values = CopyOnWriteContent.deepClone(this.values);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "query profile variant of " + this.owner + " for " + this.dimensionValues;
    }
}

