/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.config;

import com.yahoo.component.ComponentId;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.search.pagetemplates.PageTemplate;
import com.yahoo.search.pagetemplates.PageTemplateRegistry;
import com.yahoo.search.pagetemplates.model.AbstractChoice;
import com.yahoo.search.pagetemplates.model.Choice;
import com.yahoo.search.pagetemplates.model.Layout;
import com.yahoo.search.pagetemplates.model.MapChoice;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.Placeholder;
import com.yahoo.search.pagetemplates.model.Renderer;
import com.yahoo.search.pagetemplates.model.Section;
import com.yahoo.search.pagetemplates.model.Source;
import com.yahoo.search.query.Sorting;
import com.yahoo.text.XML;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class PageTemplateXMLReader {
    private static Logger logger = Logger.getLogger(PageTemplateXMLReader.class.getName());
    private PageTemplateRegistry registry;
    private Map<ComponentId, Element> pageElementsByPageId = new LinkedHashMap<ComponentId, Element>();

    public PageTemplateRegistry read(String directory) {
        ArrayList<NamedReader> pageReaders = new ArrayList<NamedReader>();
        try {
            File dir = new File(directory);
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Could not read page templates: '" + directory + "' is not a valid directory.");
            }
            for (File file : this.sortFiles(dir)) {
                if (!file.getName().endsWith(".xml")) continue;
                pageReaders.add(new NamedReader(file.getName(), (Reader)new FileReader(file)));
            }
            Object object = this.read(pageReaders, true);
            return object;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read page templates from '" + directory + "'", e);
        }
        finally {
            for (NamedReader reader : pageReaders) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public PageTemplate readFile(String fileName) {
        NamedReader pageReader = null;
        try {
            File file = new File(fileName);
            pageReader = new NamedReader(fileName, (Reader)new FileReader(file));
            String firstName = file.getName().substring(0, file.getName().length() - 4);
            PageTemplate pageTemplate = (PageTemplate)this.read(List.of(pageReader), true).getComponent(firstName);
            return pageTemplate;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the page template '" + fileName + "'", e);
        }
        finally {
            if (pageReader != null) {
                try {
                    pageReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<File> sortFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(List.of(dir.listFiles()));
        Collections.sort(files);
        return files;
    }

    public PageTemplateRegistry read(List<NamedReader> pageReaders, boolean validateReaderNames) {
        this.registry = new PageTemplateRegistry();
        this.pageElementsByPageId = this.createPages(pageReaders, validateReaderNames);
        this.readPages();
        return this.registry;
    }

    private Map<ComponentId, Element> createPages(List<NamedReader> pageReaders, boolean validateReaderNames) {
        LinkedHashMap<ComponentId, Element> pageElementsByPageId = new LinkedHashMap<ComponentId, Element>();
        for (NamedReader reader : pageReaders) {
            Element pageElement = XML.getDocument((Reader)reader).getDocumentElement();
            if (!pageElement.getNodeName().equals("page")) {
                logger.info("Ignoring '" + reader.getName() + "': Expected XML root element 'page' but was '" + pageElement.getNodeName() + "'");
                continue;
            }
            String idString = pageElement.getAttribute("id");
            if (idString == null || idString.isEmpty()) {
                throw new IllegalArgumentException("Page template '" + reader.getName() + "' has no 'id' attribute in the root element");
            }
            ComponentId id = new ComponentId(idString);
            if (validateReaderNames) {
                this.validateFileName(reader.getName(), id, "page template");
            }
            this.registry.register(new PageTemplate(id));
            pageElementsByPageId.put(id, pageElement);
        }
        return pageElementsByPageId;
    }

    private void validateFileName(String actualName, ComponentId id, String artifactName) {
        String expectedCanonicalFileName = id.toFileName();
        String fileName = new File(actualName).getName();
        String canonicalFileName = ComponentId.fromFileName((String)(fileName = this.stripXmlEnding(fileName))).toFileName();
        if (!canonicalFileName.equals(expectedCanonicalFileName)) {
            throw new IllegalArgumentException("The file name of " + artifactName + " '" + id + "' must be '" + expectedCanonicalFileName + ".xml' but was '" + actualName + "'");
        }
    }

    private String stripXmlEnding(String fileName) {
        if (!fileName.endsWith(".xml")) {
            throw new IllegalArgumentException("'" + fileName + "' should have a .xml ending");
        }
        return fileName.substring(0, fileName.length() - 4);
    }

    private void readPages() {
        for (Map.Entry<ComponentId, Element> pageElement : this.pageElementsByPageId.entrySet()) {
            try {
                PageTemplate page = (PageTemplate)this.registry.getComponent(pageElement.getValue().getAttribute("id"));
                this.readPageContent(pageElement.getValue(), page);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not read page template '" + pageElement.getKey() + "'", e);
            }
        }
    }

    private void readPageContent(Element pageElement, PageTemplate page) {
        if (page.isFrozen()) {
            return;
        }
        Section rootSection = new Section(page.getId().toString());
        this.readSection(pageElement, rootSection);
        page.setSection(rootSection);
        page.freeze();
    }

    private Section readSection(Element sectionElement, Section section) {
        section.setLayout(Layout.fromString(sectionElement.getAttribute("layout")));
        section.setRegion(sectionElement.getAttribute("region"));
        section.setOrder(Sorting.fromString(sectionElement.getAttribute("order")));
        section.setMax(this.readOptionalNumber(sectionElement, "max"));
        section.setMin(this.readOptionalNumber(sectionElement, "min"));
        section.elements().addAll(this.readSourceAttribute(sectionElement));
        section.elements().addAll(this.readPageElements(sectionElement));
        return section;
    }

    private List<PageElement> readPageElements(Element parent) {
        ArrayList<PageElement> pageElements = new ArrayList<PageElement>();
        for (Element child : XML.getChildren((Element)parent)) {
            if (child.getNodeName().equals("include")) {
                pageElements.addAll(this.readInclude(child));
                continue;
            }
            this.addIfNonNull(this.readPageElement(child), pageElements);
        }
        return pageElements;
    }

    private void addIfNonNull(PageElement pageElement, List<PageElement> pageElements) {
        if (pageElement != null) {
            pageElements.add(pageElement);
        }
    }

    private List<PageElement> readInclude(Element element) {
        PageTemplate included = (PageTemplate)this.registry.getComponent(element.getAttribute("idref"));
        if (included == null) {
            throw new IllegalArgumentException("Could not find page template '" + element.getAttribute("idref"));
        }
        this.readPageContent(this.pageElementsByPageId.get(included.getId()), included);
        return included.getSection().elements(Section.class);
    }

    private PageElement readPageElement(Element child) {
        if (child.getNodeName().equals("choice")) {
            return this.readChoice(child);
        }
        if (child.getNodeName().equals("source")) {
            return this.readSource(child);
        }
        if (child.getNodeName().equals("placeholder")) {
            return this.readPlaceholder(child);
        }
        if (child.getNodeName().equals("section")) {
            return this.readSection(child, new Section(child.getAttribute("id")));
        }
        if (child.getNodeName().equals("renderer")) {
            return this.readRenderer(child);
        }
        if (child.getNodeName().equals("parameter")) {
            return null;
        }
        throw new IllegalArgumentException("Unknown node type '" + child.getNodeName() + "'");
    }

    private List<Source> readSourceAttribute(Element sectionElement) {
        ArrayList<Source> sources = new ArrayList<Source>();
        String sourceAttributeString = sectionElement.getAttribute("source");
        if (sourceAttributeString != null) {
            for (String sourceName : sourceAttributeString.split(" ")) {
                if (sourceName.isEmpty()) continue;
                if ("*".equals(sourceName)) {
                    sources.add(Source.any);
                    continue;
                }
                sources.add(new Source(sourceName));
            }
        }
        return sources;
    }

    private Source readSource(Element sourceElement) {
        Source source = new Source(sourceElement.getAttribute("name"));
        source.setUrl(this.nullIfEmpty(sourceElement.getAttribute("url")));
        source.renderers().addAll(this.readPageElements(sourceElement));
        source.parameters().putAll(this.readParameters(sourceElement));
        return source;
    }

    private String nullIfEmpty(String s) {
        if (s == null) {
            return s;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        return s;
    }

    private Placeholder readPlaceholder(Element placeholderElement) {
        return new Placeholder(placeholderElement.getAttribute("id"));
    }

    private Renderer readRenderer(Element rendererElement) {
        Renderer renderer = new Renderer(rendererElement.getAttribute("name"));
        renderer.setRendererFor(this.nullIfEmpty(rendererElement.getAttribute("for")));
        renderer.parameters().putAll(this.readParameters(rendererElement));
        return renderer;
    }

    private int readOptionalNumber(Element element, String attributeName) {
        String attributeValue = element.getAttribute(attributeName);
        try {
            if (attributeValue.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("'" + attributeName + "' in " + element + " must be a number, not '" + attributeValue + "'");
        }
    }

    private AbstractChoice readChoice(Element choiceElement) {
        String method = this.nullIfEmpty(choiceElement.getAttribute("method"));
        if (XML.getChildren((Element)choiceElement, (String)"map").size() > 0) {
            return this.readMapChoice(choiceElement, method);
        }
        return this.readNonMapChoice(choiceElement, method);
    }

    private MapChoice readMapChoice(Element choiceElement, String method) {
        Element mapElement = (Element)XML.getChildren((Element)choiceElement, (String)"map").get(0);
        MapChoice map = new MapChoice();
        map.setMethod(method);
        map.placeholderIds().addAll(this.readSpaceSeparatedAttribute("to", mapElement));
        for (Element value : XML.getChildren((Element)mapElement)) {
            if ("item".equals(value.getNodeName())) {
                map.values().add(this.readPageElements(value));
                continue;
            }
            map.values().add(List.of(this.readPageElement(value)));
        }
        return map;
    }

    private Choice readNonMapChoice(Element choiceElement, String method) {
        Choice choice = new Choice();
        choice.setMethod(method);
        for (Element alternative : XML.getChildren((Element)choiceElement)) {
            if (alternative.getNodeName().equals("alternative")) {
                choice.alternatives().add(this.readPageElements(alternative));
                continue;
            }
            if (alternative.getNodeName().equals("include")) {
                choice.alternatives().add(this.readInclude(alternative));
                continue;
            }
            choice.alternatives().add(List.of(this.readPageElement(alternative)));
        }
        return choice;
    }

    private Map<String, String> readParameters(Element containingElement) {
        List parameterElements = XML.getChildren((Element)containingElement, (String)"parameter");
        if (parameterElements.size() == 0) {
            return Map.of();
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        for (Element parameter : parameterElements) {
            String key = parameter.getAttribute("name");
            String value = XML.getValue((Element)parameter);
            parameters.put(key, value);
        }
        return parameters;
    }

    private List<String> readSpaceSeparatedAttribute(String attributeName, Element containingElement) {
        ArrayList<String> values = new ArrayList<String>();
        String attributeString = this.nullIfEmpty(containingElement.getAttribute(attributeName));
        if (attributeString != null) {
            for (String value : attributeString.split(" ")) {
                values.add(value);
            }
        }
        return values;
    }
}

