/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.sourceref;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.federation.sourceref.SearchChainInvocationSpec;
import com.yahoo.search.federation.sourceref.SearchChainResolver;
import com.yahoo.search.federation.sourceref.UnresolvedSearchChainException;
import com.yahoo.search.federation.sourceref.UnresolvedSourceRefException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SourceRefResolver {
    private final SearchChainResolver searchChainResolver;
    private final Map<String, List<String>> schema2Clusters;

    public SourceRefResolver(SearchChainResolver searchChainResolver, Map<String, List<String>> schema2Clusters) {
        this.searchChainResolver = searchChainResolver;
        this.schema2Clusters = schema2Clusters;
    }

    public Set<SearchChainInvocationSpec> resolve(ComponentSpecification sourceRef, Properties sourceToProviderMap) throws UnresolvedSearchChainException {
        try {
            return Set.of(this.searchChainResolver.resolve(sourceRef, sourceToProviderMap));
        }
        catch (UnresolvedSourceRefException e) {
            return this.resolveClustersWithDocument(sourceRef, sourceToProviderMap);
        }
    }

    private Set<SearchChainInvocationSpec> resolveClustersWithDocument(ComponentSpecification sourceRef, Properties sourceToProviderMap) throws UnresolvedSearchChainException {
        if (this.hasOnlyName(sourceRef)) {
            LinkedHashSet<SearchChainInvocationSpec> clusterSearchChains = new LinkedHashSet<SearchChainInvocationSpec>();
            List clusters = this.schema2Clusters.getOrDefault(sourceRef.getName(), List.of());
            for (String cluster : clusters) {
                clusterSearchChains.add(this.resolveClusterSearchChain(cluster, sourceRef, sourceToProviderMap));
            }
            if (!clusterSearchChains.isEmpty()) {
                return clusterSearchChains;
            }
        }
        throw UnresolvedSourceRefException.createForMissingSourceRef(sourceRef);
    }

    private SearchChainInvocationSpec resolveClusterSearchChain(String cluster, ComponentSpecification sourceRef, Properties sourceToProviderMap) throws UnresolvedSearchChainException {
        try {
            return this.searchChainResolver.resolve(new ComponentSpecification(cluster), sourceToProviderMap);
        }
        catch (UnresolvedSearchChainException e) {
            throw new UnresolvedSearchChainException("Failed to resolve cluster search chain '" + cluster + "' when using source ref '" + sourceRef + "' as a document name.");
        }
    }

    private boolean hasOnlyName(ComponentSpecification sourceSpec) {
        return new ComponentSpecification(sourceSpec.getName()).equals((Object)sourceSpec);
    }
}

