/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.sourceref;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.federation.sourceref.SearchChainInvocationSpec;
import com.yahoo.search.federation.sourceref.SingleTarget;
import com.yahoo.search.federation.sourceref.SourcesTarget;
import com.yahoo.search.federation.sourceref.Target;
import com.yahoo.search.federation.sourceref.UnresolvedSearchChainException;
import com.yahoo.search.federation.sourceref.UnresolvedSourceRefException;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class SearchChainResolver {
    private final ComponentRegistry<Target> targets;
    private final SortedSet<Target> defaultTargets;

    private SearchChainResolver(ComponentRegistry<Target> targets, SortedSet<Target> defaultTargets) {
        this.targets = targets;
        this.defaultTargets = Collections.unmodifiableSortedSet(defaultTargets);
    }

    public SearchChainInvocationSpec resolve(ComponentSpecification sourceRef, Properties sourceToProviderMap) throws UnresolvedSearchChainException {
        Target target = this.resolveTarget(sourceRef);
        return target.responsibleSearchChain(sourceToProviderMap);
    }

    private Target resolveTarget(ComponentSpecification sourceRef) throws UnresolvedSearchChainException {
        Target target = (Target)((Object)this.targets.getComponent(sourceRef));
        if (target == null) {
            throw UnresolvedSourceRefException.createForMissingSourceRef(sourceRef);
        }
        return target;
    }

    public SortedSet<Target> allTopLevelTargets() {
        TreeSet<Target> topLevelTargets = new TreeSet<Target>();
        for (Target target : this.targets.allComponents()) {
            if (target.isDerived) continue;
            topLevelTargets.add(target);
        }
        return topLevelTargets;
    }

    public SortedSet<Target> defaultTargets() {
        return this.defaultTargets;
    }

    public static class Builder {
        private final SortedSet<Target> defaultTargets = new TreeSet<Target>();
        private final ComponentRegistry<Target> targets = new ComponentRegistry<Target>(){

            public void freeze() {
                this.allComponents().forEach(Target::freeze);
                super.freeze();
            }
        };

        public Builder addSearchChain(ComponentId searchChainId, FederationOptions federationOptions) {
            return this.addSearchChain(searchChainId, federationOptions, List.of());
        }

        public Builder addSearchChain(ComponentId searchChainId, List<String> schemas) {
            return this.addSearchChain(searchChainId, new FederationOptions(), schemas);
        }

        public Builder addSearchChain(ComponentId searchChainId, FederationOptions federationOptions, List<String> schemas) {
            this.addSearchChain(new SearchChainInvocationSpec(searchChainId, federationOptions, schemas));
            return this;
        }

        private Builder addSearchChain(SearchChainInvocationSpec invocationSpec) {
            return this.registerTarget(new SingleTarget(invocationSpec.searchChainId, invocationSpec, false));
        }

        public Builder addSearchChain(ComponentId id, SearchChainInvocationSpec invocationSpec) {
            return this.registerTarget(new SingleTarget(id, invocationSpec, false));
        }

        private Builder registerTarget(SingleTarget singleTarget) {
            this.targets.register(singleTarget.getId(), (Object)singleTarget);
            if (singleTarget.useByDefault()) {
                this.defaultTargets.add(singleTarget);
            }
            return this;
        }

        public Builder addSourceForProvider(ComponentId sourceId, ComponentId providerId, ComponentId searchChainId, boolean isDefaultProviderForSource, FederationOptions federationOptions, List<String> schemas) {
            SearchChainInvocationSpec searchChainInvocationSpec = new SearchChainInvocationSpec(searchChainId, sourceId, providerId, federationOptions, schemas);
            SourcesTarget sourcesTarget = this.getOrRegisterSourceTarget(sourceId);
            sourcesTarget.addSource(providerId, searchChainInvocationSpec, isDefaultProviderForSource);
            this.registerTarget(new SingleTarget(searchChainId, searchChainInvocationSpec, true));
            return this;
        }

        private SourcesTarget getOrRegisterSourceTarget(ComponentId sourceId) {
            Target sourcesTarget = (Target)((Object)this.targets.getComponent(sourceId));
            if (sourcesTarget == null) {
                this.targets.register(sourceId, (Object)new SourcesTarget(sourceId));
                return this.getOrRegisterSourceTarget(sourceId);
            }
            if (sourcesTarget instanceof SourcesTarget) {
                return (SourcesTarget)sourcesTarget;
            }
            throw new IllegalStateException("Expected " + sourceId + " to be a source.");
        }

        public void useTargetByDefault(String targetId) {
            Target target = (Target)((Object)this.targets.getComponent(targetId));
            assert (target != null) : "Target not added yet.";
            this.defaultTargets.add(target);
        }

        public SearchChainResolver build() {
            this.targets.freeze();
            return new SearchChainResolver(this.targets, this.defaultTargets);
        }

        private class DefaultInvocationSpecFactory
        implements InvocationSpecFactory {
            private DefaultInvocationSpecFactory() {
            }

            @Override
            public SearchChainInvocationSpec create(ComponentId searchChainId, FederationOptions federationOptions, List<String> schemas) {
                return new SearchChainInvocationSpec(searchChainId, federationOptions, schemas);
            }
        }

        public static interface InvocationSpecFactory {
            public SearchChainInvocationSpec create(ComponentId var1, FederationOptions var2, List<String> var3);
        }
    }
}

