/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation;

import com.google.common.base.Preconditions;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.collections.Pair;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.errorhandling.Results;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.federation.FederationConfig;
import com.yahoo.search.federation.FederationResult;
import com.yahoo.search.federation.selection.FederationTarget;
import com.yahoo.search.federation.selection.TargetSelector;
import com.yahoo.search.federation.sourceref.ModifyQueryAndResult;
import com.yahoo.search.federation.sourceref.SearchChainInvocationSpec;
import com.yahoo.search.federation.sourceref.SearchChainResolver;
import com.yahoo.search.federation.sourceref.SingleTarget;
import com.yahoo.search.federation.sourceref.SourceRefResolver;
import com.yahoo.search.federation.sourceref.SourcesTarget;
import com.yahoo.search.federation.sourceref.UnresolvedSearchChainException;
import com.yahoo.search.federation.sourceref.VirtualSourceResolver;
import com.yahoo.search.query.Properties;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.HitOrderer;
import com.yahoo.search.schema.Cluster;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.AsyncExecution;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.ForkingSearcher;
import com.yahoo.search.searchchain.FutureResult;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@Provides(value={"Federation"})
@After(value={"*"})
public class FederationSearcher
extends ForkingSearcher {
    private static final Logger log = Logger.getLogger(FederationSearcher.class.getName());
    public static final CompoundName SOURCENAME = CompoundName.from((String)"sourceName");
    public static final CompoundName PROVIDERNAME = CompoundName.from((String)"providerName");
    public static final String FEDERATION = "Federation";
    public static final String LOG_COUNT_PREFIX = "count_";
    private final SearchChainResolver searchChainResolver;
    private final SourceRefResolver sourceRefResolver;
    private final VirtualSourceResolver virtualSourceResolver;
    private final TargetSelector<?> targetSelector;
    private final Clock clock = Clock.systemUTC();

    @Inject
    public FederationSearcher(FederationConfig config, SchemaInfo schemaInfo, ComponentRegistry<TargetSelector> targetSelectors) {
        this(FederationSearcher.createResolver(config), FederationSearcher.createVirtualSourceResolver(config), FederationSearcher.resolveSelector(config.targetSelector(), targetSelectors), FederationSearcher.createSchema2Clusters(schemaInfo));
    }

    public FederationSearcher(SearchChainResolver searchChainResolver, Map<String, List<String>> schema2Clusters) {
        this(searchChainResolver, VirtualSourceResolver.of(), null, schema2Clusters);
    }

    private FederationSearcher(SearchChainResolver searchChainResolver, VirtualSourceResolver virtualSourceResolver, TargetSelector targetSelector, Map<String, List<String>> schema2Clusters) {
        this.searchChainResolver = searchChainResolver;
        this.sourceRefResolver = new SourceRefResolver(searchChainResolver, schema2Clusters);
        this.targetSelector = targetSelector;
        this.virtualSourceResolver = virtualSourceResolver;
    }

    private static VirtualSourceResolver createVirtualSourceResolver(FederationConfig config) {
        return VirtualSourceResolver.of(config.target().stream().map(FederationConfig.Target::id).collect(Collectors.toUnmodifiableSet()));
    }

    private static TargetSelector resolveSelector(String selectorId, ComponentRegistry<TargetSelector> targetSelectors) {
        if (selectorId.isEmpty()) {
            return null;
        }
        return (TargetSelector)Preconditions.checkNotNull((Object)((TargetSelector)targetSelectors.getComponent(selectorId)), (Object)("Missing target selector with id '" + selectorId + "'"));
    }

    private static Map<String, List<String>> createSchema2Clusters(SchemaInfo schemaInfo) {
        HashMap<String, List<String>> schema2Clusters = new HashMap<String, List<String>>();
        for (Cluster cluster : schemaInfo.clusters().values()) {
            for (String schema : cluster.schemas()) {
                schema2Clusters.computeIfAbsent(schema, key -> new ArrayList()).add(cluster.name());
            }
        }
        return schema2Clusters;
    }

    private static SearchChainResolver createResolver(FederationConfig config) {
        SearchChainResolver.Builder builder = new SearchChainResolver.Builder();
        for (FederationConfig.Target target : config.target()) {
            boolean isDefaultProviderForSource = true;
            for (FederationConfig.Target.SearchChain searchChain : target.searchChain()) {
                if (searchChain.providerId() == null || searchChain.providerId().isEmpty()) {
                    FederationSearcher.addSearchChain(builder, target, searchChain);
                    continue;
                }
                FederationSearcher.addSourceForProvider(builder, target, searchChain, isDefaultProviderForSource);
                isDefaultProviderForSource = false;
            }
            if (!target.useByDefault()) continue;
            builder.useTargetByDefault(target.id());
        }
        return builder.build();
    }

    private static void addSearchChain(SearchChainResolver.Builder builder, FederationConfig.Target target, FederationConfig.Target.SearchChain searchChain) {
        String id = target.id();
        if (!id.equals(searchChain.searchChainId())) {
            throw new RuntimeException("Invalid federation config, " + id + " != " + searchChain.searchChainId());
        }
        ComponentId searchChainId = ComponentId.fromString((String)id);
        builder.addSearchChain(searchChainId, FederationSearcher.federationOptions(searchChain), searchChain.documentTypes());
        for (String schema : searchChain.documentTypes()) {
            String virtualChainId = id + "." + schema;
            builder.addSearchChain(ComponentId.fromString((String)virtualChainId), new SearchChaininvocationProxy(searchChainId, FederationSearcher.federationOptions(searchChain).setUseByDefault(false), schema));
        }
    }

    private static void addSourceForProvider(SearchChainResolver.Builder builder, FederationConfig.Target target, FederationConfig.Target.SearchChain searchChain, boolean isDefaultProvider) {
        builder.addSourceForProvider(ComponentId.fromString((String)target.id()), ComponentId.fromString((String)searchChain.providerId()), ComponentId.fromString((String)searchChain.searchChainId()), isDefaultProvider, FederationSearcher.federationOptions(searchChain), searchChain.documentTypes());
    }

    private static FederationOptions federationOptions(FederationConfig.Target.SearchChain searchChain) {
        return new FederationOptions().setOptional(searchChain.optional()).setUseByDefault(searchChain.useByDefault()).setTimeoutInMilliseconds(searchChain.timeoutMillis()).setRequestTimeoutInMilliseconds(searchChain.requestTimeoutMillis());
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result mergedResults = execution.search(query);
        Results<SearchChainInvocationSpec, UnresolvedSearchChainException> targets = this.getTargets(query.getModel().getSources(), query.properties());
        this.warnIfUnresolvedSearchChains(targets.errors(), mergedResults.hits());
        Collection<SearchChainInvocationSpec> prunedTargets = this.pruneTargetsWithoutDocumentTypes(query.getModel().getRestrict(), targets.data());
        Results<Target, ErrorMessage> regularTargetHandlers = this.resolveSearchChains(prunedTargets, execution.searchChainRegistry());
        query.errors().addAll(regularTargetHandlers.errors());
        LinkedHashSet<Target> targetHandlers = new LinkedHashSet<Target>(regularTargetHandlers.data());
        targetHandlers.addAll(FederationSearcher.getAdditionalTargets(query, execution, this.targetSelector));
        this.traceTargets(query, targetHandlers);
        if (targetHandlers.isEmpty()) {
            return mergedResults;
        }
        if (targetHandlers.size() > 1) {
            this.search(query, execution, targetHandlers, mergedResults);
        } else if (this.shouldExecuteTargetLongerThanThread(query, (Target)targetHandlers.iterator().next())) {
            this.search(query, execution, targetHandlers, mergedResults);
        } else {
            this.search(query, execution, (Target)CollectionUtil.first(targetHandlers), mergedResults);
        }
        return mergedResults;
    }

    private void search(Query query, Execution execution, Target target, Result mergedResults) {
        this.mergeResult(query, target, mergedResults, this.search(query, execution, target).orElse(FederationSearcher.createSearchChainTimedOutResult(query, target)));
    }

    private void search(Query query, Execution execution, Collection<Target> targets, Result mergedResults) {
        FederationResult results = this.search(query, execution, targets);
        results.waitForAll((int)query.getTimeLeft(), this.clock);
        HitOrderer s = null;
        for (FederationResult.TargetResult targetResult : results.all()) {
            if (s == null) {
                s = this.dirtyCopyIfModifiedOrderer(mergedResults.hits(), targetResult.getOrTimeoutError().hits().getOrderer());
            }
            this.mergeResult(query, targetResult.target, mergedResults, targetResult.getOrTimeoutError());
        }
    }

    private Optional<Result> search(Query query, Execution execution, Target target) {
        long timeout = target.federationOptions().getSearchChainExecutionTimeoutInMilliseconds(query.getTimeLeft());
        if (timeout <= 0L) {
            return Optional.empty();
        }
        Execution newExecution = new Execution(target.getChain(), execution.context());
        Result result = newExecution.search(this.cloneFederationQuery(query, Window.from(query), timeout, target));
        target.modifyTargetResult(result);
        return Optional.of(result);
    }

    private FederationResult search(Query query, Execution execution, Collection<Target> targets) {
        FederationResult.Builder result = new FederationResult.Builder();
        for (Target target : targets) {
            result.add(target, this.searchAsynchronously(query, execution, Window.from(targets, query), target));
        }
        return result.build();
    }

    private FutureResult searchAsynchronously(Query query, Execution execution, Window window, Target target) {
        long timeout = target.federationOptions().getSearchChainExecutionTimeoutInMilliseconds(query.getTimeLeft());
        if (timeout <= 0L) {
            return new FutureResult(() -> new Result(query, ErrorMessage.createTimeout("Timed out before federation")), execution, query);
        }
        Query clonedQuery = this.cloneFederationQuery(query, window, timeout, target);
        return new AsyncExecution(target.getChain(), execution).search(clonedQuery);
    }

    private Query cloneFederationQuery(Query query, Window window, long timeout, Target target) {
        query.getModel().getQueryTree();
        Query clonedQuery = Query.createNewQuery(query);
        return this.createFederationQuery(query, clonedQuery, window, timeout, target);
    }

    private Query createFederationQuery(Query query, Query outgoing, Window window, long timeout, Target target) {
        ComponentId chainId = target.getChain().getId();
        String sourceName = chainId.getName();
        outgoing.properties().set(SOURCENAME, sourceName);
        String providerName = chainId.getName();
        if (chainId.getNamespace() != null) {
            providerName = chainId.getNamespace().getName();
        }
        outgoing.properties().set(PROVIDERNAME, providerName);
        outgoing.setTimeout(timeout);
        this.propagatePerSourceQueryProperties(query, outgoing, window, sourceName, providerName);
        target.modifyTargetQuery(outgoing);
        return outgoing;
    }

    private void propagatePerSourceQueryProperties(Query original, Query outgoing, Window window, String sourceName, String providerName) {
        outgoing.setHits(window.hits);
        outgoing.setOffset(window.offset);
        original.properties().listProperties(CompoundName.fromComponents((String[])new String[]{"provider", providerName})).forEach((k, v) -> outgoing.properties().set((String)k, v));
        original.properties().listProperties(CompoundName.fromComponents((String[])new String[]{"source", sourceName})).forEach((k, v) -> outgoing.properties().set((String)k, v));
    }

    private ErrorMessage missingSearchChainsErrorMessage(List<UnresolvedSearchChainException> unresolvedSearchChainExceptions) {
        String message = String.join((CharSequence)" ", FederationSearcher.getMessagesSet(unresolvedSearchChainExceptions)) + " Valid source refs are " + String.join((CharSequence)", ", this.allSourceRefDescriptions()) + ".";
        return ErrorMessage.createInvalidQueryParameter(message);
    }

    private List<String> allSourceRefDescriptions() {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (com.yahoo.search.federation.sourceref.Target target : this.searchChainResolver.allTopLevelTargets()) {
            descriptions.add(target.searchRefDescription());
        }
        return descriptions;
    }

    private static Set<String> getMessagesSet(List<UnresolvedSearchChainException> unresolvedSearchChainExceptions) {
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        for (UnresolvedSearchChainException exception : unresolvedSearchChainExceptions) {
            messages.add(exception.getMessage());
        }
        return messages;
    }

    private void warnIfUnresolvedSearchChains(List<UnresolvedSearchChainException> missingTargets, HitGroup errorHitGroup) {
        if (!missingTargets.isEmpty()) {
            errorHitGroup.addError(this.missingSearchChainsErrorMessage(missingTargets));
        }
    }

    @Override
    public Collection<ForkingSearcher.CommentedSearchChain> getSearchChainsForwarded(SearchChainRegistry registry) {
        ArrayList<ForkingSearcher.CommentedSearchChain> searchChains = new ArrayList<ForkingSearcher.CommentedSearchChain>();
        for (com.yahoo.search.federation.sourceref.Target target : this.searchChainResolver.allTopLevelTargets()) {
            if (target instanceof SourcesTarget) {
                searchChains.addAll(this.commentedSourceProviderSearchChains((SourcesTarget)target, registry));
                continue;
            }
            if (target instanceof SingleTarget) {
                searchChains.add(this.commentedSearchChain((SingleTarget)target, registry));
                continue;
            }
            log.warning("Invalid target type " + ((Object)((Object)target)).getClass().getName());
        }
        return searchChains;
    }

    private ForkingSearcher.CommentedSearchChain commentedSearchChain(SingleTarget singleTarget, SearchChainRegistry registry) {
        return new ForkingSearcher.CommentedSearchChain("If source refs contains '" + singleTarget.getId() + "'.", registry.getChain(singleTarget.getId()));
    }

    private List<ForkingSearcher.CommentedSearchChain> commentedSourceProviderSearchChains(SourcesTarget sourcesTarget, SearchChainRegistry registry) {
        ArrayList<ForkingSearcher.CommentedSearchChain> commentedSearchChains = new ArrayList<ForkingSearcher.CommentedSearchChain>();
        String ifMatchingSourceRefPrefix = "If source refs contains '" + sourcesTarget.getId() + "' and provider is '";
        commentedSearchChains.add(new ForkingSearcher.CommentedSearchChain(ifMatchingSourceRefPrefix + sourcesTarget.defaultProviderSource().provider + "'(or not given).", registry.getChain(sourcesTarget.defaultProviderSource().searchChainId)));
        for (SearchChainInvocationSpec providerSource : sourcesTarget.allProviderSources()) {
            if (providerSource.equals(sourcesTarget.defaultProviderSource())) continue;
            commentedSearchChains.add(new ForkingSearcher.CommentedSearchChain(ifMatchingSourceRefPrefix + providerSource.provider + "'.", registry.getChain(providerSource.searchChainId)));
        }
        return commentedSearchChains;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        UniqueExecutionsToResults uniqueExecutionsToResults = new UniqueExecutionsToResults();
        this.addResultsToFill(result.hits(), result, summaryClass, uniqueExecutionsToResults);
        Set<Map.Entry<Chain<Searcher>, Map<Query, Result>>> resultsForAllChains = uniqueExecutionsToResults.resultsToFill.entrySet();
        int numberOfCallsToFillNeeded = 0;
        for (Map.Entry<Chain<Searcher>, Map<Query, Result>> resultsToFillForAChain : resultsForAllChains) {
            numberOfCallsToFillNeeded += resultsToFillForAChain.getValue().size();
        }
        ArrayList<Pair> futureFilledResults = new ArrayList<Pair>();
        for (Map.Entry<Chain<Searcher>, Map<Query, Result>> resultsToFillForAChain : resultsForAllChains) {
            Chain<Searcher> chain = resultsToFillForAChain.getKey();
            Execution chainExecution = chain == null ? execution : new Execution(chain, execution.context());
            for (Map.Entry<Query, Result> resultsToFillForAChainAndQuery : resultsToFillForAChain.getValue().entrySet()) {
                Result resultToFill = resultsToFillForAChainAndQuery.getValue();
                if (numberOfCallsToFillNeeded == 1) {
                    chainExecution.fill(resultToFill, summaryClass);
                    this.propagateErrors(resultToFill, result);
                    continue;
                }
                AsyncExecution asyncFill = new AsyncExecution(chainExecution);
                futureFilledResults.add(new Pair((Object)resultToFill, (Object)asyncFill.fill(resultToFill, summaryClass)));
            }
        }
        for (Pair futureFilledResult : futureFilledResults) {
            Optional<Result> filledResult = ((FutureResult)futureFilledResult.getSecond()).getIfAvailable(result.getQuery().getTimeLeft(), TimeUnit.MILLISECONDS);
            if (filledResult.isPresent()) {
                this.propagateErrors(filledResult.get(), result);
                continue;
            }
            result.hits().addError(((FutureResult)futureFilledResult.getSecond()).createTimeoutError());
            Iterator<Hit> i = ((Result)futureFilledResult.getFirst()).hits().unorderedDeepIterator();
            while (i.hasNext()) {
                result.hits().remove(i.next().getId());
            }
        }
    }

    private void propagateErrors(Result source, Result destination) {
        destination.hits().addErrorsFrom(source.hits());
    }

    private void addResultsToFill(HitGroup hitGroup, Result result, String summaryClass, UniqueExecutionsToResults uniqueExecutionsToResults) {
        for (Hit hit : hitGroup) {
            if (hit instanceof HitGroup) {
                this.addResultsToFill((HitGroup)hit, result, summaryClass, uniqueExecutionsToResults);
                continue;
            }
            if (hit.isFilled(summaryClass)) continue;
            this.getSearchChainGroup(hit, result, uniqueExecutionsToResults).hits().add(hit);
        }
    }

    private Result getSearchChainGroup(Hit hit, Result result, UniqueExecutionsToResults uniqueExecutionsToResults) {
        Chain chain = (Chain)hit.getSearcherSpecificMetaData(this);
        Query query = hit.getQuery() != null ? hit.getQuery() : result.getQuery();
        return uniqueExecutionsToResults.get((Chain<Searcher>)chain, query);
    }

    private HitOrderer dirtyCopyIfModifiedOrderer(HitGroup group, HitOrderer orderer) {
        HitOrderer old;
        if (orderer != null && !orderer.equals(old = group.getOrderer())) {
            group.setOrderer(orderer);
        }
        return orderer;
    }

    private Results<SearchChainInvocationSpec, UnresolvedSearchChainException> getTargets(Set<String> sources, Properties properties) {
        return sources.isEmpty() ? this.defaultSearchChains(properties) : this.resolveSources(sources, properties);
    }

    private Results<SearchChainInvocationSpec, UnresolvedSearchChainException> resolveSources(Set<String> sourcesInQuery, Properties properties) {
        Results.Builder result = new Results.Builder();
        Set<String> sources = this.virtualSourceResolver.resolve(sourcesInQuery);
        for (String source : sources) {
            try {
                result.addAllData(this.sourceRefResolver.resolve(this.asSourceSpec(source), properties));
            }
            catch (UnresolvedSearchChainException e) {
                result.addError((Object)e);
            }
        }
        return result.build();
    }

    public Results<SearchChainInvocationSpec, UnresolvedSearchChainException> defaultSearchChains(Properties sourceToProviderMap) {
        Results.Builder result = new Results.Builder();
        for (com.yahoo.search.federation.sourceref.Target target : this.searchChainResolver.defaultTargets()) {
            try {
                result.addData((Object)target.responsibleSearchChain(sourceToProviderMap));
            }
            catch (UnresolvedSearchChainException e) {
                result.addError((Object)e);
            }
        }
        return result.build();
    }

    private ComponentSpecification asSourceSpec(String source) {
        try {
            return new ComponentSpecification(source);
        }
        catch (Exception e) {
            throw new IllegalInputException("The source ref '" + source + "' used for federation is not valid.", (Throwable)e);
        }
    }

    private void traceTargets(Query query, Collection<Target> targets) {
        int traceFederationLevel = 2;
        if (!query.getTrace().isTraceable(traceFederationLevel)) {
            return;
        }
        query.trace("Federating to " + targets, traceFederationLevel);
    }

    private boolean shouldExecuteTargetLongerThanThread(Query query, Target target) {
        return (long)target.federationOptions().getRequestTimeoutInMilliseconds() > query.getTimeout();
    }

    private static Result createSearchChainTimedOutResult(Query query, Target target) {
        ErrorMessage timeoutMessage = ErrorMessage.createTimeout("Error in execution of chain '" + target.getId() + "': Chain timed out.");
        timeoutMessage.setSource(target.getId().stringValue());
        return new Result(query, timeoutMessage);
    }

    private void mergeResult(Query query, Target target, Result mergedResults, Result result) {
        ComponentId searchChainId = target.getId();
        Chain<Searcher> searchChain = target.getChain();
        mergedResults.mergeWith(result);
        HitGroup group = result.hits();
        group.setId("source:" + searchChainId.getName());
        group.setSearcherSpecificMetaData(this, searchChain);
        group.setMeta(false);
        group.setAuxiliary(true);
        group.setSource(searchChainId.getName());
        group.setQuery(result.getQuery());
        Iterator<Hit> it = group.unorderedDeepIterator();
        while (it.hasNext()) {
            Hit hit = it.next();
            hit.setSearcherSpecificMetaData(this, searchChain);
            hit.setSource(searchChainId.stringValue());
            if (!hit.isMeta() || !hit.types().contains("logging")) continue;
            hit.setField("count_deep", result.getDeepHitCount());
            hit.setField("count_total", result.getTotalHitCount());
            int offset = result.getQuery().getOffset();
            hit.setField("count_first", offset + 1);
            hit.setField("count_last", result.getConcreteHitCount() + offset);
        }
        if (query.getTrace().getLevel() >= 4) {
            query.trace("Got " + group.getConcreteSize() + " hits from " + group.getId(), false, 4);
        }
        mergedResults.hits().add(group);
    }

    private Results<Target, ErrorMessage> resolveSearchChains(Collection<SearchChainInvocationSpec> prunedTargets, SearchChainRegistry registry) {
        Results.Builder targetHandlers = new Results.Builder();
        for (SearchChainInvocationSpec target : prunedTargets) {
            Chain<Searcher> chain = registry.getChain(target.searchChainId);
            if (chain == null) {
                targetHandlers.addError((Object)ErrorMessage.createIllegalQuery("Could not find search chain '" + target.searchChainId + "'"));
                continue;
            }
            targetHandlers.addData((Object)new StandardTarget(target, chain));
        }
        return targetHandlers.build();
    }

    private static <T> List<Target> getAdditionalTargets(Query query, Execution execution, TargetSelector<T> targetSelector) {
        if (targetSelector == null) {
            return List.of();
        }
        ArrayList<Target> result = new ArrayList<Target>();
        for (FederationTarget<T> target : targetSelector.getTargets(query, execution.searchChainRegistry())) {
            result.add(new CustomTarget<T>(targetSelector, target));
        }
        return result;
    }

    private Collection<SearchChainInvocationSpec> pruneTargetsWithoutDocumentTypes(Set<String> restrict, List<SearchChainInvocationSpec> targets) {
        if (restrict.isEmpty()) {
            return targets;
        }
        ArrayList<SearchChainInvocationSpec> prunedTargets = new ArrayList<SearchChainInvocationSpec>();
        for (SearchChainInvocationSpec target : targets) {
            if (!target.schemas.isEmpty() && !this.documentTypeIntersectionIsNonEmpty(restrict, target)) continue;
            prunedTargets.add(target);
        }
        return prunedTargets;
    }

    private boolean documentTypeIntersectionIsNonEmpty(Set<String> restrict, SearchChainInvocationSpec target) {
        for (String documentType : target.schemas) {
            if (!restrict.contains(documentType)) continue;
            return true;
        }
        return false;
    }

    private static class SearchChaininvocationProxy
    extends SearchChainInvocationSpec {
        SearchChaininvocationProxy(ComponentId searchChainId, FederationOptions federationOptions, String schema) {
            super(searchChainId, federationOptions, List.of(schema));
        }

        @Override
        public void modifyTargetQuery(Query query) {
            query.getModel().setSources(this.searchChainId.getName());
            query.getModel().setRestrict((String)this.schemas.get(0));
        }
    }

    static abstract class Target
    implements ModifyQueryAndResult {
        Target() {
        }

        abstract Chain<Searcher> getChain();

        ComponentId getId() {
            return this.getChain().getId();
        }

        public abstract FederationOptions federationOptions();

        public String toString() {
            return this.getChain().getId().stringValue();
        }
    }

    private record Window(int hits, int offset) {
        public static Window from(Query query) {
            return new Window(query.getHits(), query.getOffset());
        }

        public static Window from(Collection<Target> targets, Query query) {
            if (targets.size() == 1) {
                return Window.from(query);
            }
            return new Window(query.getHits() + query.getOffset(), 0);
        }
    }

    private static class UniqueExecutionsToResults {
        final Map<Chain<Searcher>, Map<Query, Result>> resultsToFill = new IdentityHashMap<Chain<Searcher>, Map<Query, Result>>();

        private UniqueExecutionsToResults() {
        }

        public Result get(Chain<Searcher> chain, Query query) {
            Map resultsToFillForAChain = this.resultsToFill.computeIfAbsent(chain, k -> new IdentityHashMap());
            Result resultsToFillForAChainAndQuery = (Result)resultsToFillForAChain.get(query);
            if (resultsToFillForAChainAndQuery == null) {
                resultsToFillForAChainAndQuery = new Result(query);
                resultsToFillForAChain.put(query, resultsToFillForAChainAndQuery);
            }
            return resultsToFillForAChainAndQuery;
        }
    }

    private static class StandardTarget
    extends Target {
        private final SearchChainInvocationSpec target;
        private final Chain<Searcher> chain;

        public StandardTarget(SearchChainInvocationSpec target, Chain<Searcher> chain) {
            this.target = target;
            this.chain = chain;
        }

        @Override
        Chain<Searcher> getChain() {
            return this.chain;
        }

        @Override
        public void modifyTargetQuery(Query query) {
            this.target.modifyTargetQuery(query);
        }

        @Override
        public void modifyTargetResult(Result result) {
            this.target.modifyTargetResult(result);
        }

        @Override
        public FederationOptions federationOptions() {
            return this.target.federationOptions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StandardTarget)) {
                return false;
            }
            StandardTarget other = (StandardTarget)o;
            if (!Objects.equals(other.chain.getId(), this.chain.getId())) {
                return false;
            }
            return Objects.equals(other.target, this.target);
        }

        public int hashCode() {
            return Objects.hash(this.chain.getId(), this.target);
        }
    }

    private static class CustomTarget<T>
    extends Target {
        private final TargetSelector<T> selector;
        private final FederationTarget<T> target;

        CustomTarget(TargetSelector<T> selector, FederationTarget<T> target) {
            this.selector = selector;
            this.target = target;
        }

        @Override
        Chain<Searcher> getChain() {
            return this.target.getChain();
        }

        @Override
        public void modifyTargetQuery(Query query) {
            this.selector.modifyTargetQuery(this.target, query);
        }

        @Override
        public void modifyTargetResult(Result result) {
            this.selector.modifyTargetResult(this.target, result);
        }

        @Override
        public FederationOptions federationOptions() {
            return this.target.getFederationOptions();
        }
    }
}

