/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.search.Query;

class TimeoutHelper {
    private TimeoutHelper() {
    }

    static Timeout calculateTimeout(Query q) {
        long timeLeftMillis = q.getTimeLeft();
        if (timeLeftMillis <= 2L) {
            return new Timeout(0.0, 0.0);
        }
        double clientTimeout = Math.max((double)timeLeftMillis * 0.99, 2.0) / 1000.0;
        double requestTimeout = Math.max((double)timeLeftMillis * 0.98, 1.0) / 1000.0;
        return new Timeout(requestTimeout, clientTimeout);
    }

    record Timeout(double request, double client) {
        public boolean timedOut() {
            return this.request == 0.0 && this.client == 0.0;
        }
    }
}

