/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.CloseableInvoker;
import com.yahoo.search.dispatch.InvokerResult;
import com.yahoo.search.dispatch.ResponseMonitor;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import java.io.IOException;
import java.util.Optional;

public abstract class SearchInvoker
extends CloseableInvoker {
    private final Optional<Node> node;
    private ResponseMonitor<SearchInvoker> monitor;

    protected SearchInvoker(Optional<Node> node) {
        this.node = node;
    }

    public Result search(Query query) throws IOException {
        this.sendSearchRequest(query, null);
        InvokerResult result = this.getSearchResult();
        this.setFinalStatus(result.getResult().hits().getError() == null);
        result.complete();
        return result.getResult();
    }

    protected abstract Object sendSearchRequest(Query var1, Object var2) throws IOException;

    protected abstract InvokerResult getSearchResult() throws IOException;

    protected void setMonitor(ResponseMonitor<SearchInvoker> monitor) {
        this.monitor = monitor;
    }

    protected void responseAvailable() {
        if (this.monitor != null) {
            this.monitor.responseAvailable(this);
        }
    }

    protected Optional<Integer> distributionKey() {
        return this.node.map(Node::key);
    }

    protected InvokerResult errorResult(Query query, ErrorMessage errorMessage) {
        Result error = new Result(query, errorMessage);
        Coverage errorCoverage = new Coverage(0L, 0L, 0);
        errorCoverage.setNodesTried(1);
        error.setCoverage(errorCoverage);
        return new InvokerResult(error);
    }
}

