/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.search.Query;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.searchlib.aggregation.Hit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class GroupingResultAggregator {
    private static final Logger log = Logger.getLogger(GroupingResultAggregator.class.getName());
    private final Map<Integer, Grouping> groupings = new LinkedHashMap<Integer, Grouping>();
    private DocumentDatabase documentDatabase = null;
    private Query query = null;
    private int groupingHitsMerged = 0;

    GroupingResultAggregator() {
    }

    void mergeWith(GroupingListHit result) {
        ++this.groupingHitsMerged;
        if (this.documentDatabase == null) {
            this.documentDatabase = result.getDocumentDatBase();
        }
        if (this.query == null) {
            this.query = result.getQuery();
        }
        log.log(Level.FINE, () -> String.format("Merging hit #%d having %d groupings", this.groupingHitsMerged, result.getGroupingList().size()));
        for (Grouping grouping : result.getGroupingList()) {
            this.groupings.merge(grouping.getId(), grouping, (existingGrouping, newGrouping) -> {
                existingGrouping.merge(newGrouping);
                return existingGrouping;
            });
        }
    }

    Optional<GroupingListHit> toAggregatedHit() {
        if (this.groupingHitsMerged == 0) {
            return Optional.empty();
        }
        log.log(Level.FINE, () -> String.format("Creating aggregated hit containing %d groupings from %d hits with docsums '%s' and %s", this.groupings.size(), this.groupingHitsMerged, this.documentDatabase.getDocsumDefinitionSet(), this.query));
        GroupingListHit groupingHit = new GroupingListHit(List.copyOf(this.groupings.values()), this.documentDatabase, this.query);
        groupingHit.setQuery(this.query);
        groupingHit.getGroupingList().forEach(g -> {
            g.select(o -> o instanceof Hit, o -> ((Hit)o).setContext((Object)groupingHit));
            g.postMerge();
        });
        return Optional.of(groupingHit);
    }
}

