/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.engine.Choicepoint;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.CompositeCondition;
import com.yahoo.prelude.semantics.rule.Condition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ComparisonCondition
extends CompositeCondition {
    private Operator operator;

    public ComparisonCondition(Condition leftCondition, String operatorString, Condition rightCondition) {
        this.operator = Operator.get(operatorString);
        this.addCondition(leftCondition);
        this.addCondition(rightCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doesMatch(RuleEvaluation evaluation) {
        Choicepoint choicepoint;
        boolean matches;
        Object right;
        Object left;
        block9: {
            block8: {
                left = null;
                right = null;
                matches = false;
                choicepoint = evaluation.getChoicepoint(this, true);
                try {
                    matches = this.getLeftCondition().matches(evaluation);
                    if (matches) break block8;
                    boolean bl = false;
                    if (!matches) {
                        choicepoint.backtrack();
                    }
                    this.traceResult(matches, evaluation, left, right);
                    return bl;
                }
                catch (Throwable throwable) {
                    if (!matches) {
                        choicepoint.backtrack();
                    }
                    this.traceResult(matches, evaluation, left, right);
                    throw throwable;
                }
            }
            left = evaluation.getValue();
            evaluation.setValue(null);
            choicepoint.backtrackPosition();
            matches = this.getRightCondition().matches(evaluation);
            if (matches) break block9;
            boolean bl = false;
            if (!matches) {
                choicepoint.backtrack();
            }
            this.traceResult(matches, evaluation, left, right);
            return bl;
        }
        right = evaluation.getValue();
        evaluation.setValue(right);
        boolean bl = matches = this.operator.compare(left, right);
        if (!matches) {
            choicepoint.backtrack();
        }
        this.traceResult(matches, evaluation, left, right);
        return bl;
    }

    @Override
    protected void traceResult(boolean matches, RuleEvaluation e) {
    }

    protected void traceResult(boolean matches, RuleEvaluation e, Object left, Object right) {
        if (matches && e.getTraceLevel() >= 3) {
            e.trace(3, "Matched '" + this + "'" + this.getMatchInfoString(e) + " at " + e.previousItem() + " as " + left + this.operator + right + " is true");
        }
        if (!matches && e.getTraceLevel() >= 3) {
            e.trace(3, "Did not match '" + this + "' at " + e.currentItem() + " as " + left + this.operator + right + " is false");
        }
    }

    public Condition getLeftCondition() {
        return this.getCondition(0);
    }

    public void setLeftCondition(Condition leftCondition) {
        this.setCondition(0, leftCondition);
    }

    public Condition getRightCondition() {
        return this.getCondition(1);
    }

    public void setRightCondition(Condition rightCondition) {
        this.setCondition(1, rightCondition);
    }

    @Override
    protected String toInnerString() {
        return this.toInnerString(this.operator.toString());
    }

    private static final class Operator {
        private String operatorString;
        private static Map<String, Operator> operators = new HashMap<String, Operator>();
        public static final Operator equals = new Operator("=");
        public static final Operator largerequals = new Operator(">=");
        public static final Operator smallerequals = new Operator("<=");
        public static final Operator larger = new Operator(">");
        public static final Operator smaller = new Operator("<");
        public static final Operator different = new Operator("!=");
        public static final Operator contains = new Operator("=~");

        private Operator(String operator) {
            this.operatorString = operator;
            operators.put(this.operatorString, this);
        }

        private static Operator get(String operatorString) {
            Operator operator = operators.get(operatorString);
            if (operator == null) {
                throw new IllegalArgumentException("Unknown operator '" + operatorString + "'");
            }
            return operator;
        }

        public boolean compare(Object left, Object right) {
            if (this == equals) {
                return this.equals(left, right);
            }
            if (this == different) {
                return !this.equals(left, right);
            }
            if (left == null || right == null) {
                return false;
            }
            if (this == contains) {
                return this.contains(left, right);
            }
            if (this == largerequals) {
                return this.larger(left, right) || this.equals(left, right);
            }
            if (this == smallerequals) {
                return !this.larger(left, right);
            }
            if (this == larger) {
                return this.larger(left, right);
            }
            if (this == smaller) {
                return !this.larger(left, right) && !this.equals(left, right);
            }
            throw new RuntimeException("Programming error, fix this method");
        }

        private boolean equals(Object left, Object right) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null) {
                return false;
            }
            return left.equals(right);
        }

        private boolean contains(Object left, Object right) {
            if (left instanceof Collection) {
                return ((Collection)left).contains(right);
            }
            return left.toString().indexOf(right.toString()) >= 0;
        }

        private boolean larger(Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() > ((Number)right).doubleValue();
            }
            return left.toString().compareTo(right.toString()) > 0;
        }

        public int hashCode() {
            return this.operatorString.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Operator)) {
                return false;
            }
            return other.toString().equals(this.toString());
        }

        public String toString() {
            return this.operatorString;
        }
    }
}

