/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeIndexedItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;

public class PhraseItem
extends CompositeIndexedItem {
    private boolean explicit = false;

    public PhraseItem() {
    }

    public PhraseItem(String indexName) {
        this.setIndexName(indexName);
    }

    public PhraseItem(String[] words) {
        for (int i = 0; i < words.length; ++i) {
            this.addIndexedItem(new WordItem(words[i]));
        }
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.PHRASE;
    }

    @Override
    public String getName() {
        return "PHRASE";
    }

    @Override
    public void setIndexName(String index) {
        super.setIndexName(index);
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            IndexedItem word = (IndexedItem)i.next();
            word.setIndexName(index);
        }
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    private IndexedItem convertIntToWord(Item orig) {
        IntItem o = (IntItem)orig;
        return new WordItem(o.stringValue(), o.getIndexName(), o.isFromQuery());
    }

    @Override
    public void addItem(Item item) {
        if (item instanceof WordItem || item instanceof PhraseSegmentItem || item instanceof WordAlternativesItem) {
            this.addIndexedItem((IndexedItem)((Object)item));
        } else if (item instanceof IntItem) {
            this.addIndexedItem(this.convertIntToWord(item));
        } else if (item instanceof PhraseItem || item instanceof AndSegmentItem) {
            ListIterator<Item> i = ((CompositeItem)item).getItemIterator();
            while (i.hasNext()) {
                this.addIndexedItem((IndexedItem)i.next());
            }
        } else {
            throw new IllegalArgumentException("Can not add " + item + " to a phrase");
        }
    }

    @Override
    public boolean acceptsItemsOfType(Item.ItemType itemType) {
        return itemType == Item.ItemType.WORD || itemType == Item.ItemType.WORD_ALTERNATIVES || itemType == Item.ItemType.INT || itemType == Item.ItemType.EXACT || itemType == Item.ItemType.PHRASE;
    }

    @Override
    public void addItem(int index, Item item) {
        if (item instanceof WordItem || item instanceof PhraseSegmentItem) {
            this.addIndexedItem(index, (IndexedItem)((Object)item));
        } else if (item instanceof IntItem) {
            this.addIndexedItem(index, this.convertIntToWord(item));
        } else if (item instanceof PhraseItem) {
            PhraseItem phrase = (PhraseItem)item;
            ListIterator<Item> i = phrase.getItemIterator();
            while (i.hasNext()) {
                this.addIndexedItem(index++, (WordItem)i.next());
            }
        } else {
            throw new IllegalArgumentException("Can not add " + item + " to a phrase");
        }
    }

    @Override
    public Item setItem(int index, Item item) {
        if (item instanceof WordItem || item instanceof PhraseSegmentItem) {
            return this.setIndexedItem(index, (IndexedItem)((Object)item));
        }
        if (item instanceof IntItem) {
            return this.setIndexedItem(index, this.convertIntToWord(item));
        }
        if (item instanceof PhraseItem) {
            PhraseItem phrase = (PhraseItem)item;
            ListIterator<Item> i = phrase.getItemIterator();
            IndexedItem firstItem = (IndexedItem)i.next();
            Item toReturn = this.setIndexedItem(index++, firstItem);
            while (i.hasNext()) {
                this.addIndexedItem(index++, (IndexedItem)i.next());
            }
            return toReturn;
        }
        throw new IllegalArgumentException("Can not add " + item + " to a phrase");
    }

    @Override
    public Optional<Item> extractSingleChild() {
        Optional<Item> extracted = super.extractSingleChild();
        extracted.ifPresent(e -> e.setWeight(this.getWeight()));
        return extracted;
    }

    private void addIndexedItem(IndexedItem word) {
        word.setIndexName(this.getIndexName());
        super.addItem((Item)((Object)word));
    }

    private void addIndexedItem(int index, IndexedItem word) {
        word.setIndexName(this.getIndexName());
        if (word instanceof Item) {
            Item item = (Item)((Object)word);
            item.setWeight(this.getWeight());
        }
        super.addItem(index, (Item)((Object)word));
    }

    private Item setIndexedItem(int index, IndexedItem word) {
        word.setIndexName(this.getIndexName());
        if (word instanceof Item) {
            Item item = (Item)((Object)word);
            item.setWeight(this.getWeight());
        }
        return super.setItem(index, (Item)((Object)word));
    }

    @Override
    public void setWeight(int weight) {
        super.setWeight(weight);
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item word = (Item)i.next();
            word.setWeight(weight);
        }
    }

    public WordItem getWordItem(int index) {
        return (WordItem)this.getItem(index);
    }

    public BlockItem getBlockItem(int index) {
        return (BlockItem)((Object)this.getItem(index));
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
    }

    @Override
    public int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        int itemCount = 1;
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item subitem = (Item)i.next();
            if (subitem instanceof PhraseSegmentItem) {
                PhraseSegmentItem seg = (PhraseSegmentItem)subitem;
                itemCount += seg.encodeContent(buffer);
                continue;
            }
            itemCount += subitem.encode(buffer);
        }
        return itemCount;
    }

    @Override
    protected boolean shouldParenthesize() {
        return false;
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        this.appendIndexString(buffer);
        buffer.append("\"");
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            if (item instanceof WordItem) {
                WordItem wordItem = (WordItem)item;
                buffer.append(wordItem.getWord());
            } else if (item instanceof PhraseSegmentItem) {
                PhraseSegmentItem seg = (PhraseSegmentItem)item;
                seg.appendContentsString(buffer);
            } else {
                buffer.append(item.toString());
            }
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        buffer.append("\"");
    }

    @Override
    public String getIndexedString() {
        StringBuilder buf = new StringBuilder();
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            IndexedItem indexedItem = (IndexedItem)i.next();
            buf.append(indexedItem.getIndexedString());
            if (!i.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    @Override
    protected int encodingArity() {
        return this.getNumWords();
    }

    @Override
    public int getNumWords() {
        int numWords = 0;
        ListIterator<Item> j = this.getItemIterator();
        while (j.hasNext()) {
            numWords += ((IndexedItem)j.next()).getNumWords();
        }
        return numWords;
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("explicit", this.explicit);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.explicit == ((PhraseItem)other).explicit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.explicit);
    }
}

