/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.search.schema.Schema;
import com.yahoo.tensor.TensorType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RankProfile {
    private final String name;
    private final boolean hasSummaryFeatures;
    private final boolean hasRankFeatures;
    private final Map<String, TensorType> inputs;
    private Schema schema = null;

    private RankProfile(Builder builder) {
        this.name = builder.name;
        this.hasSummaryFeatures = builder.hasSummaryFeatures;
        this.hasRankFeatures = builder.hasRankFeatures;
        this.inputs = Collections.unmodifiableMap(builder.inputs);
    }

    public String name() {
        return this.name;
    }

    public Schema schema() {
        return this.schema;
    }

    void setSchema(Schema schema) {
        if (this.schema != null) {
            throw new IllegalStateException("Cannot add rank profile '" + this.name + "' to schema '" + schema.name() + "' as it is already added to schema '" + this.schema.name() + "'");
        }
        this.schema = schema;
    }

    public boolean hasSummaryFeatures() {
        return this.hasSummaryFeatures;
    }

    public boolean hasRankFeatures() {
        return this.hasRankFeatures;
    }

    public Map<String, TensorType> inputs() {
        return this.inputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RankProfile)) {
            return false;
        }
        RankProfile other = (RankProfile)o;
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (other.hasSummaryFeatures != this.hasSummaryFeatures) {
            return false;
        }
        if (other.hasRankFeatures != this.hasRankFeatures) {
            return false;
        }
        return other.inputs.equals(this.inputs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.hasSummaryFeatures, this.hasRankFeatures, this.inputs);
    }

    public String toString() {
        return "rank profile '" + this.name + "'" + (String)(this.schema == null ? "" : " in " + this.schema);
    }

    public static class Builder {
        private final String name;
        private boolean hasSummaryFeatures = true;
        private boolean hasRankFeatures = true;
        private final Map<String, TensorType> inputs = new LinkedHashMap<String, TensorType>();

        public Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder setHasSummaryFeatures(boolean hasSummaryFeatures) {
            this.hasSummaryFeatures = hasSummaryFeatures;
            return this;
        }

        public Builder setHasRankFeatures(boolean hasRankFeatures) {
            this.hasRankFeatures = hasRankFeatures;
            return this;
        }

        public Builder addInput(String name, TensorType type) {
            this.inputs.put(name, type);
            return this;
        }

        public RankProfile build() {
            return new RankProfile(this);
        }
    }
}

