/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import ai.vespa.models.evaluation.FunctionEvaluator;
import com.yahoo.search.ranking.Evaluator;
import com.yahoo.tensor.Tensor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class SimpleEvaluator
implements Evaluator {
    private final FunctionEvaluator evaluator;
    private final Set<String> neededInputs;

    public SimpleEvaluator(FunctionEvaluator prototype) {
        this.evaluator = prototype;
        this.neededInputs = new HashSet<String>(prototype.function().arguments());
    }

    @Override
    public Collection<String> needInputs() {
        return List.copyOf(this.neededInputs);
    }

    @Override
    public SimpleEvaluator bind(String name, Tensor value) {
        if (value != null) {
            this.evaluator.bind(name, value);
        }
        this.neededInputs.remove(name);
        return this;
    }

    @Override
    public double evaluateScore() {
        return this.evaluator.evaluate().asDouble();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("SimpleEvaluator(");
        buf.append(this.evaluator.function().toString());
        buf.append(")[");
        for (String arg : this.neededInputs) {
            buf.append("{").append(arg).append("}");
        }
        buf.append("]");
        return buf.toString();
    }
}

