/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.DotProductItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.WandItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.text.SimpleMapParser;
import com.yahoo.yolean.Exceptions;
import java.util.LinkedHashMap;
import java.util.Map;

public class WandSearcher
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        try {
            InputResolver inputs = new InputResolver(query, execution);
            if (!inputs.hasValidData()) {
                return execution.search(query);
            }
            query.getModel().getQueryTree().and(this.createWandQueryItem(inputs));
            query.trace("WandSearcher: Added WAND operator", true, 4);
            return execution.search(query);
        }
        catch (IllegalArgumentException e) {
            return new Result(query, ErrorMessage.createInvalidQueryParameter(Exceptions.toMessageString((Throwable)e)));
        }
    }

    private Item createWandQueryItem(InputResolver inputs) {
        if (inputs.getWandType().equals((Object)WandType.VESPA)) {
            return this.populate(new WeakAndItem(inputs.getHeapSize()), inputs.getFieldName(), inputs.getTokens());
        }
        if (inputs.getWandType().equals((Object)WandType.OR)) {
            return this.populate(new OrItem(), inputs.getFieldName(), inputs.getTokens());
        }
        if (inputs.getWandType().equals((Object)WandType.PARALLEL)) {
            return this.populate(new WandItem(inputs.getFieldName(), inputs.getHeapSize(), inputs.getTokens()), inputs.getScoreThreshold(), inputs.getThresholdBoostFactor());
        }
        if (inputs.getWandType().equals((Object)WandType.DOT_PRODUCT)) {
            return new DotProductItem(inputs.getFieldName(), inputs.getTokens());
        }
        throw new IllegalInputException("Unknown type '" + inputs.getWandType() + "'");
    }

    private CompositeItem populate(CompositeItem parent, String fieldName, Map<Object, Integer> tokens) {
        for (Map.Entry<Object, Integer> entry : tokens.entrySet()) {
            WordItem wordItem = new WordItem(entry.getKey().toString(), fieldName);
            wordItem.setWeight(entry.getValue());
            wordItem.setStemmed(true);
            wordItem.setNormalizable(false);
            parent.addItem(wordItem);
        }
        return parent;
    }

    private WandItem populate(WandItem item, double scoreThreshold, double thresholdBoostFactor) {
        item.setScoreThreshold(scoreThreshold);
        item.setThresholdBoostFactor(thresholdBoostFactor);
        return item;
    }

    private static class InputResolver {
        private static final CompoundName WAND_FIELD = CompoundName.from((String)"wand.field");
        private static final CompoundName WAND_TOKENS = CompoundName.from((String)"wand.tokens");
        private static final CompoundName WAND_HEAP_SIZE = CompoundName.from((String)"wand.heapSize");
        private static final CompoundName WAND_TYPE = CompoundName.from((String)"wand.type");
        private static final CompoundName WAND_SCORE_THRESHOLD = CompoundName.from((String)"wand.scoreThreshold");
        private static final CompoundName WAND_THRESHOLD_BOOST_FACTOR = CompoundName.from((String)"wand.thresholdBoostFactor");
        private final String fieldName;
        private final WandType wandType;
        private final Map<Object, Integer> tokens;
        private final int heapSize;
        private final double scoreThreshold;
        private final double thresholdBoostFactor;

        public InputResolver(Query query, Execution execution) {
            String tokens;
            this.fieldName = query.properties().getString(WAND_FIELD);
            if (this.fieldName != null && (tokens = query.properties().getString(WAND_TOKENS)) != null) {
                IndexFacts.Session indexFacts = execution.context().getIndexFacts().newSession(query);
                Index index = indexFacts.getIndex(this.fieldName);
                this.wandType = this.resolveWandType(index, indexFacts, query);
                this.tokens = index.isNumerical() && (this.wandType == WandType.DOT_PRODUCT || this.wandType == WandType.PARALLEL) ? new LongIntegerMapParser().parse(tokens, new LinkedHashMap<Object, Integer>(200)) : new MapObjectIntegerParser().parse(tokens, new LinkedHashMap<Object, Integer>(200));
                this.heapSize = this.resolveHeapSize(query);
                this.scoreThreshold = this.resolveScoreThreshold(query);
                this.thresholdBoostFactor = this.resolveThresholdBoostFactor(query);
                return;
            }
            this.wandType = null;
            this.tokens = null;
            this.heapSize = 0;
            this.scoreThreshold = 0.0;
            this.thresholdBoostFactor = 1.0;
        }

        private WandType resolveWandType(Index index, IndexFacts.Session indexFacts, Query query) {
            if (index.isNull()) {
                throw new IllegalInputException("Field '" + this.fieldName + "' was not found in " + indexFacts);
            }
            return WandType.create(query.properties().getString(WAND_TYPE, "vespa"));
        }

        private int resolveHeapSize(Query query) {
            String defaultHeapSize = "100";
            return Integer.parseInt(query.properties().getString(WAND_HEAP_SIZE, defaultHeapSize));
        }

        private double resolveScoreThreshold(Query query) {
            return Double.parseDouble(query.properties().getString(WAND_SCORE_THRESHOLD, "0"));
        }

        private double resolveThresholdBoostFactor(Query query) {
            return Double.parseDouble(query.properties().getString(WAND_THRESHOLD_BOOST_FACTOR, "1"));
        }

        public boolean hasValidData() {
            return this.tokens != null && !this.tokens.isEmpty();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Map<Object, Integer> getTokens() {
            return this.tokens;
        }

        public WandType getWandType() {
            return this.wandType;
        }

        public Integer getHeapSize() {
            return this.heapSize;
        }

        public Double getScoreThreshold() {
            return this.scoreThreshold;
        }

        public Double getThresholdBoostFactor() {
            return this.thresholdBoostFactor;
        }
    }

    private static enum WandType {
        VESPA("vespa"),
        OR("or"),
        PARALLEL("parallel"),
        DOT_PRODUCT("dotProduct");

        private final String type;

        private WandType(String type) {
            this.type = type;
        }

        public static WandType create(String type) {
            for (WandType enumType : WandType.values()) {
                if (!enumType.type.equals(type)) continue;
                return enumType;
            }
            return VESPA;
        }
    }

    private static class LongIntegerMapParser
    extends MapObjectIntegerParser {
        private LongIntegerMapParser() {
        }

        @Override
        protected void handleKeyValue(String key, String value) {
            this.map.put(Long.parseLong(key), Integer.parseInt(value));
        }
    }

    private static class MapObjectIntegerParser
    extends SimpleMapParser {
        protected Map<Object, Integer> map;

        private MapObjectIntegerParser() {
        }

        public Map<Object, Integer> parse(String string, Map<Object, Integer> map) {
            this.map = map;
            this.parse(string);
            return this.map;
        }

        protected void handleKeyValue(String key, String value) {
            this.map.put(key, Integer.parseInt(value));
        }
    }
}

