/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.search.grouping.vespa.IntegerEncoder;
import java.util.Arrays;

class IntegerDecoder {
    private static final int CHAR_MIN = IntegerEncoder.CHARS[0];
    private static final int CHAR_MAX = IntegerEncoder.CHARS[IntegerEncoder.CHARS.length - 1];
    private final String input;
    private int pos = 0;

    public IntegerDecoder(String input) {
        this.input = input;
    }

    public boolean hasNext() {
        return this.pos < this.input.length();
    }

    public int next() {
        int val = 0;
        int len = IntegerDecoder.decodeChar(this.input.charAt(this.pos++));
        for (int i = 0; i < len; ++i) {
            val = val << 4 | IntegerDecoder.decodeChar(this.input.charAt(this.pos + i));
        }
        this.pos += len;
        return val >>> 1 ^ -(val & 1);
    }

    private static int decodeChar(char c) {
        if (c >= CHAR_MIN && c <= CHAR_MAX) {
            return 0xF & c - CHAR_MIN;
        }
        throw new NumberFormatException("Expected a char in " + Arrays.toString(IntegerEncoder.CHARS) + " but was '" + c + "'");
    }
}

