/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.result;

import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.searchchain.Execution;
import java.util.Iterator;

@Before(value={"GroupingExecutor"})
public class FlatteningSearcher
extends Searcher {
    private final CompoundName flatten = CompoundName.from((String)"grouping.flatten");

    @Override
    public Result search(Query query, Execution execution) {
        if (!query.properties().getBoolean(this.flatten, true)) {
            return execution.search(query);
        }
        if (!query.properties().getBoolean("flatten", true)) {
            return execution.search(query);
        }
        query.trace("Flattening groups", 2);
        int originalHits = query.getHits();
        query.setHits(0);
        Result result = execution.search(query);
        query.setHits(originalHits);
        this.flatten(result.hits(), 0, result);
        return result;
    }

    private void flatten(HitGroup hits, int level, Result result) {
        int hitsLeft = hits.size();
        Iterator<Hit> i = hits.iterator();
        while (i.hasNext() && hitsLeft-- > 0) {
            Object countField;
            Hit hit = i.next();
            if (level == 0 && hit instanceof RootGroup && (countField = hit.getField("count()")) != null) {
                result.setTotalHitCount((Long)countField);
            }
            if (hit instanceof HitGroup) {
                this.flatten((HitGroup)hit, level++, result);
                i.remove();
                continue;
            }
            result.hits().add(hit);
        }
    }
}

