/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.search.dispatch.rpc.Client;
import com.yahoo.search.dispatch.rpc.RpcClient;
import com.yahoo.search.dispatch.rpc.RpcConnectionPool;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.DispatchNodesConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class RpcResourcePool
implements RpcConnectionPool,
AutoCloseable {
    private volatile Map<Integer, NodeConnectionPool> nodeConnectionPools = Map.of();
    private final int numConnections;
    private final RpcClient rpcClient;

    RpcResourcePool(Map<Integer, Client.NodeConnection> nodeConnections) {
        HashMap builder = new HashMap();
        nodeConnections.forEach((key, connection) -> builder.put(key, new NodeConnectionPool(List.of(connection))));
        this.nodeConnectionPools = Map.copyOf(builder);
        this.rpcClient = null;
        this.numConnections = 1;
    }

    public RpcResourcePool(DispatchConfig dispatchConfig, DispatchNodesConfig nodesConfig) {
        this.rpcClient = new RpcClient("dispatch-client", dispatchConfig.numJrtTransportThreads());
        this.numConnections = dispatchConfig.numJrtConnectionsPerNode();
        this.updateNodes(nodesConfig).forEach(item -> {
            try {
                item.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public Collection<AutoCloseable> updateNodes(DispatchNodesConfig nodesConfig) {
        ArrayList<AutoCloseable> toClose = new ArrayList<AutoCloseable>();
        HashMap<Integer, NodeConnectionPool> builder = new HashMap<Integer, NodeConnectionPool>();
        for (DispatchNodesConfig.Node node : nodesConfig.node()) {
            RpcClient.RpcNodeConnection rpcNodeConnection;
            Client.NodeConnection nc;
            NodeConnectionPool prev = this.nodeConnectionPools.get(node.key());
            Client.NodeConnection nodeConnection = nc = prev != null ? prev.nextConnection() : null;
            if (nc instanceof RpcClient.RpcNodeConnection && (rpcNodeConnection = (RpcClient.RpcNodeConnection)nc).getPort() == node.port() && rpcNodeConnection.getHostname().equals(node.host())) {
                builder.put(node.key(), prev);
                continue;
            }
            ArrayList<Client.NodeConnection> connections = new ArrayList<Client.NodeConnection>(this.numConnections);
            for (int i = 0; i < this.numConnections; ++i) {
                connections.add(this.rpcClient.createConnection(node.host(), node.port()));
            }
            builder.put(node.key(), new NodeConnectionPool(connections));
        }
        this.nodeConnectionPools.forEach((key, pool) -> {
            NodeConnectionPool survivor = (NodeConnectionPool)builder.get(key);
            if (survivor == null || pool != survivor) {
                toClose.add((AutoCloseable)pool);
            }
        });
        this.nodeConnectionPools = Map.copyOf(builder);
        return toClose;
    }

    @Override
    public Client.NodeConnection getConnection(int nodeId) {
        NodeConnectionPool pool = this.nodeConnectionPools.get(nodeId);
        if (pool == null) {
            return null;
        }
        return pool.nextConnection();
    }

    @Override
    public void close() {
        this.nodeConnectionPools.values().forEach(NodeConnectionPool::close);
        if (this.rpcClient != null) {
            this.rpcClient.close();
        }
    }

    private static class NodeConnectionPool
    implements AutoCloseable {
        private final List<Client.NodeConnection> connections;

        NodeConnectionPool(List<Client.NodeConnection> connections) {
            this.connections = connections;
        }

        Client.NodeConnection nextConnection() {
            int slot = ThreadLocalRandom.current().nextInt(this.connections.size());
            return this.connections.get(slot);
        }

        @Override
        public void close() {
            this.connections.forEach(Client.NodeConnection::close);
        }
    }
}

