/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.collections.CopyOnWriteHashMap;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.language.Language;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import com.yahoo.search.query.QueryTree;
import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class Item
implements Cloneable {
    public static final int DEFAULT_WEIGHT = 100;
    private int weight = 100;
    private boolean fromSpecialToken = false;
    private ItemCreator creator = ItemCreator.ORIG;
    private CompositeItem parent = null;
    private CopyOnWriteHashMap<String, Object> annotations;
    private boolean isRanked = true;
    private boolean usePositionData = true;
    private boolean hasUniqueID = false;
    private String label = null;
    protected int uniqueID = 0;
    protected Item connectedItem;
    protected Item connectedBacklink;
    protected double connectivity = 0.0;
    protected double significance = 0.0;
    protected boolean explicitSignificance = false;
    private boolean isProtected;
    private Language language = Language.UNKNOWN;

    public abstract void setIndexName(String var1);

    public final int getCode() {
        return this.getItemType().code;
    }

    public abstract ItemType getItemType();

    public abstract String getName();

    public void setFilter(boolean filter) {
        this.creator = filter ? ItemCreator.FILTER : ItemCreator.ORIG;
    }

    public boolean isFilter() {
        return this.creator == ItemCreator.FILTER;
    }

    @Deprecated
    public ItemCreator getCreator() {
        return this.creator;
    }

    @Deprecated
    public void setCreator(ItemCreator creator) {
        this.creator = creator;
    }

    public void setWeight(int w) {
        this.weight = w;
    }

    public int getWeight() {
        return this.weight;
    }

    public void addAnnotation(String key, Object value) {
        if (this.annotations == null) {
            this.annotations = new CopyOnWriteHashMap();
        }
        this.annotations.put((Object)key, value);
    }

    public Object getAnnotation(String annotation) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get((Object)annotation);
    }

    public boolean hasAnnotation(String annotation) {
        if (this.annotations == null) {
            return false;
        }
        return this.annotations.containsKey((Object)annotation);
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setParent(CompositeItem parent) {
        this.parent = parent;
    }

    public CompositeItem getParent() {
        return this.parent;
    }

    public abstract int encode(ByteBuffer var1);

    protected void encodeThis(ByteBuffer buffer) {
        byte flags;
        int CODE_MASK = 31;
        int FEAT_WEIGHT = 32;
        int FEAT_UNIQUEID = 64;
        int FEAT_FLAGS = -128;
        byte type = (byte)(this.getCode() & CODE_MASK);
        if (type != this.getCode()) {
            throw new IllegalStateException("must increase number of bytes in serialization format for queries");
        }
        if (this.weight != 100) {
            type = (byte)(type | FEAT_WEIGHT);
        }
        if (this.hasUniqueID()) {
            type = (byte)(type | FEAT_UNIQUEID);
        }
        if ((flags = this.getFlagsFeature()) != 0) {
            type = (byte)(type | FEAT_FLAGS);
        }
        buffer.put(type);
        if ((type & FEAT_WEIGHT) != 0) {
            IntegerCompressor.putCompressedNumber((int)this.weight, (ByteBuffer)buffer);
        }
        if ((type & FEAT_UNIQUEID) != 0) {
            IntegerCompressor.putCompressedPositiveNumber((int)this.uniqueID, (ByteBuffer)buffer);
        }
        if ((type & FEAT_FLAGS) != 0) {
            buffer.put(flags);
        }
    }

    private byte getFlagsFeature() {
        boolean FLAGS_NORANK = true;
        int FLAGS_SPECIALTOKEN = 2;
        int FLAGS_NOPOSITIONDATA = 4;
        int FLAGS_ISFILTER = 8;
        byte ret = 0;
        if (!this.isRanked()) {
            ret = (byte)(ret | (FLAGS_NORANK ? 1 : 0));
        }
        if (this.isFromSpecialToken()) {
            ret = (byte)(ret | FLAGS_SPECIALTOKEN);
        }
        if (!this.usePositionData()) {
            ret = (byte)(ret | FLAGS_NOPOSITIONDATA);
        }
        if (this.isFilter()) {
            ret = (byte)(ret | FLAGS_ISFILTER);
        }
        return ret;
    }

    protected static byte[] getBytes(String string) {
        return Utf8.toBytes((String)string);
    }

    public static void putString(String s, ByteBuffer buffer) {
        Item.putBytes(Utf8.toBytes((String)s), buffer);
    }

    public static void putBytes(byte[] bytes, ByteBuffer buffer) {
        IntegerCompressor.putCompressedPositiveNumber((int)bytes.length, (ByteBuffer)buffer);
        buffer.put(bytes);
    }

    public abstract int getTermCount();

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.shouldParenthesize()) {
            buffer.append("(");
        }
        if (this.isFilter()) {
            buffer.append("|");
        }
        this.appendHeadingString(buffer);
        this.appendBodyString(buffer);
        if (this.shouldParenthesize()) {
            buffer.append(")");
        }
        if (this.weight != 100) {
            buffer.append("!");
            buffer.append(this.weight);
        }
        return buffer.toString();
    }

    protected boolean shouldParenthesize() {
        return false;
    }

    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append(" ");
    }

    protected abstract void appendBodyString(StringBuilder var1);

    public Item clone() {
        try {
            Item clone = (Item)super.clone();
            if (this.annotations != null) {
                clone.annotations = this.annotations.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Someone made Item uncloneable");
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Item other = (Item)o;
        if (this.weight != other.weight) {
            return false;
        }
        if (this.fromSpecialToken != other.fromSpecialToken) {
            return false;
        }
        if (this.creator != other.creator) {
            return false;
        }
        if (!Objects.equals(this.annotations, other.annotations)) {
            return false;
        }
        if (this.isRanked != other.isRanked) {
            return false;
        }
        if (this.usePositionData != other.usePositionData) {
            return false;
        }
        if (!Objects.equals(this.label, other.label)) {
            return false;
        }
        if (this.uniqueID != other.uniqueID) {
            return false;
        }
        if (!Objects.equals(this.connectedItem, other.connectedItem)) {
            return false;
        }
        if (this.connectivity != other.connectivity) {
            return false;
        }
        if (this.significance != other.significance) {
            return false;
        }
        return this.language == other.language;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.weight, this.fromSpecialToken, this.creator, this.annotations, this.isRanked, this.usePositionData, this.label, this.uniqueID, this.connectedItem, this.connectivity, this.significance, this.language});
    }

    protected boolean hasUniqueID() {
        return this.hasUniqueID;
    }

    protected void setHasUniqueID(boolean hasUniqueID) {
        this.hasUniqueID = hasUniqueID;
    }

    public void setLabel(String label) {
        this.setHasUniqueID(true);
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setRanked(boolean isRanked) {
        this.isRanked = isRanked;
    }

    public boolean isRanked() {
        return this.isRanked;
    }

    public void setPositionData(boolean usePositionData) {
        this.usePositionData = usePositionData;
    }

    public boolean usePositionData() {
        return this.usePositionData;
    }

    public void disclose(Discloser discloser) {
        if (this.connectivity != 0.0) {
            discloser.addProperty("connectivity", this.connectivity);
        }
        if (this.connectedItem != null) {
            discloser.addProperty("connectedItem", this.connectedItem);
        }
        if (this.creator != ItemCreator.ORIG) {
            discloser.addProperty("creator", (Object)this.creator);
        }
        if (!this.isRanked) {
            discloser.addProperty("isRanked", this.isRanked);
        }
        if (!this.usePositionData) {
            discloser.addProperty("usePositionData", this.usePositionData);
        }
        if (this.explicitSignificance) {
            discloser.addProperty("significance", this.significance);
        }
        if (this.weight != 100) {
            discloser.addProperty("weight", this.weight);
        }
        if (this.label != null) {
            discloser.addProperty("label", this.label);
        }
        if (this.hasUniqueID) {
            discloser.addProperty("uniqueID", this.uniqueID);
        }
    }

    public boolean isFromSpecialToken() {
        return this.fromSpecialToken;
    }

    public void setFromSpecialToken(boolean fromSpecialToken) {
        this.fromSpecialToken = fromSpecialToken;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        Objects.requireNonNull(language, "Language cannot be null");
        this.language = language;
    }

    public boolean hasConnectivityBackLink() {
        return this.connectedBacklink != null;
    }

    public boolean isRoot() {
        if (this.getParent() == null) {
            return true;
        }
        return this.getParent() instanceof QueryTree;
    }

    @Deprecated
    public static enum ItemCreator {
        ORIG(0),
        FILTER(1);

        public final int code;

        private ItemCreator(int code) {
            this.code = code;
        }
    }

    public static enum ItemType {
        OR(0),
        AND(1),
        NOT(2),
        RANK(3),
        WORD(4),
        INT(5),
        PHRASE(6),
        MULTI_TERM(7),
        PREFIX(8),
        SUBSTRING(9),
        NEAR(11),
        ONEAR(12),
        SUFFIX(13),
        EQUIV(14),
        WEIGHTEDSET(15),
        WEAK_AND(16),
        EXACT(17),
        SAME_ELEMENT(18),
        PURE_WEIGHTED_STRING(19),
        PURE_WEIGHTED_INTEGER(20),
        DOTPRODUCT(21),
        WAND(22),
        PREDICATE_QUERY(23),
        REGEXP(24),
        WORD_ALTERNATIVES(25),
        NEAREST_NEIGHBOR(26),
        GEO_LOCATION_TERM(27),
        TRUE(28),
        FALSE(29),
        FUZZY(30);

        public final int code;

        private ItemType(int code) {
            this.code = code;
        }
    }
}

