/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.document.GlobalId;
import com.yahoo.net.URI;
import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.SortDataHitSorter;
import com.yahoo.search.dispatch.LeanHit;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.FeatureData;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.Relevance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;

public class FastHit
extends Hit {
    private static final byte[] emptyGID = new byte[12];
    private int distributionKey;
    private final int partId;
    private byte[] globalId;
    private transient byte[] sortData = null;
    private transient Sorting sortDataSorting = null;
    private List<SummaryData> summaries = Collections.emptyList();
    private Set<String> removedFields = null;

    public FastHit() {
        super(new Relevance(0.0));
        this.globalId = emptyGID;
        this.partId = 0;
        this.distributionKey = 0;
    }

    public FastHit(byte[] gid, double relevance, int partId, int distributionKey) {
        this(gid, new Relevance(relevance), partId, distributionKey);
    }

    public FastHit(byte[] gid, Relevance relevance, int partId, int distributionKey) {
        super(relevance);
        this.globalId = gid;
        this.partId = partId;
        this.distributionKey = distributionKey;
    }

    public FastHit(String uri, double relevancy) {
        this(uri, relevancy, (String)null);
    }

    private FastHit(String uri, double relevance, String source) {
        super(new Relevance(relevance));
        this.partId = 0;
        this.distributionKey = 0;
        this.globalId = emptyGID;
        this.setId(uri);
        this.setSource(source);
        this.types().add("summary");
    }

    @Override
    public boolean isMeta() {
        return false;
    }

    @Override
    public URI getId() {
        URI id = super.getId();
        if (id != null) {
            return id;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("index:").append(this.getSource()).append('/').append(this.getPartId()).append('/');
        FastHit.appendAsHex(this.globalId, sb);
        URI indexUri = new URI(sb.toString());
        this.assignId(indexUri);
        return indexUri;
    }

    public GlobalId getGlobalId() {
        return new GlobalId(this.globalId);
    }

    public byte[] getRawGlobalId() {
        return this.globalId;
    }

    public void setGlobalId(byte[] globalId) {
        this.globalId = globalId;
    }

    public int getPartId() {
        return this.partId;
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    public void setDistributionKey(int distributionKey) {
        this.distributionKey = distributionKey;
    }

    public void setSortData(byte[] data, Sorting sorting) {
        this.sortData = data;
        this.sortDataSorting = sorting;
    }

    @Override
    public int compareTo(Hit other) {
        int cmpRes = 0;
        if (this.sortData != null && other instanceof FastHit && this.hasSortData(((FastHit)other).sortDataSorting)) {
            cmpRes = SortDataHitSorter.getComparator(this.sortDataSorting, null).compare(this, other);
        }
        return cmpRes != 0 ? cmpRes : super.compareTo(other);
    }

    boolean hasSortData(Sorting sorting) {
        return this.sortData != null && this.sortDataSorting != null && this.sortDataSorting.equals(sorting);
    }

    static int compareSortData(FastHit left, FastHit right, Sorting sorting) {
        if (!left.hasSortData(sorting) || !right.hasSortData(sorting)) {
            return 0;
        }
        return LeanHit.compareData(left.sortData, right.sortData);
    }

    public void addSummary(DocsumDefinition docsumDef, Inspector value) {
        if (this.removedFields != null) {
            this.removedFields.removeAll(docsumDef.fields().keySet());
        }
        if (!(this.summaries instanceof ArrayList)) {
            this.summaries = new ArrayList<SummaryData>(8);
        }
        this.summaries.add(0, new SummaryData(this, docsumDef, value, 1 + this.summaries.size()));
    }

    @Override
    public FeatureData features() {
        FeatureData data = (FeatureData)this.getField("summaryfeatures");
        return data == null ? super.features() : data;
    }

    @Override
    public Object getField(String name) {
        Object value = super.getField(name);
        if (value != null) {
            return value;
        }
        value = this.getSummaryValue(name);
        if (value != null) {
            super.setField(name, value);
        }
        return value;
    }

    @Override
    public Object setField(String name, Object value) {
        Object oldValue;
        if (this.removedFields != null && this.removedFields.remove(name) && this.removedFields.isEmpty()) {
            this.removedFields = null;
        }
        if ((oldValue = super.setField(name, value)) != null) {
            return oldValue;
        }
        return this.getSummaryValue(name);
    }

    @Override
    public void forEachField(BiConsumer<String, Object> consumer) {
        super.forEachField(consumer);
        for (SummaryData summaryData : this.summaries) {
            summaryData.forEachField(consumer);
        }
    }

    @Override
    public void forEachFieldAsRaw(Hit.RawUtf8Consumer consumer) {
        super.forEachField(consumer);
        for (SummaryData summaryData : this.summaries) {
            summaryData.forEachFieldAsRaw(consumer);
        }
    }

    @Override
    public Map<String, Object> fields() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        Iterator<Map.Entry<String, Object>> i = this.fieldIterator();
        while (i.hasNext()) {
            Map.Entry<String, Object> field = i.next();
            fields.put(field.getKey(), field.getValue());
        }
        return fields;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> fieldIterator() {
        return new FieldIterator(this, super.fieldIterator());
    }

    @Override
    public Set<String> fieldKeys() {
        return new FieldSet(this);
    }

    private Iterator<String> fieldNameIterator() {
        return new FieldNameIterator(this, super.fieldKeys().iterator());
    }

    @Override
    public void clearFields() {
        this.summaries.clear();
        if (this.removedFields != null) {
            this.removedFields = null;
        }
        super.clearFields();
    }

    @Override
    public Object removeField(String name) {
        Object removedValue = super.removeField(name);
        if (removedValue == null) {
            removedValue = this.getSummaryValue(name);
        }
        if (removedValue != null) {
            if (this.removedFields == null) {
                this.removedFields = new HashSet<String>(2);
            }
            this.removedFields.add(name);
        }
        return removedValue;
    }

    private Set<String> mapFieldKeys() {
        return super.fieldKeys();
    }

    @Override
    protected boolean hasField(String name) {
        return super.hasField(name);
    }

    @Override
    protected boolean hasFields() {
        return super.hasFields();
    }

    private Object getSummaryValue(String name) {
        if (this.removedFields != null && this.removedFields.contains(name)) {
            return null;
        }
        for (SummaryData summaryData : this.summaries) {
            Object value = summaryData.getField(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " [fasthit, globalid: " + new GlobalId(this.globalId).toString() + ", partId: " + this.partId + ", distributionkey: " + this.distributionKey + "]";
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            throw new IllegalStateException("This hit must have a 'uri' field, and this field must be filled through Execution.fill(Result)) before hashCode() is accessed.");
        }
        return super.hashCode();
    }

    private static void appendAsHex(byte[] gid, StringBuilder sb) {
        for (byte b : gid) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
    }

    private static class SummaryData {
        private final FastHit hit;
        private final DocsumDefinition type;
        private final Inspector data;
        private final int index;

        SummaryData(FastHit hit, DocsumDefinition type, Inspector data, int index) {
            this.hit = hit;
            this.type = type;
            this.data = data;
            this.index = index;
        }

        Object getField(String name) {
            return this.type.convert(name, this.data.field(name));
        }

        void forEachField(BiConsumer<String, Object> consumer) {
            this.data.traverse((name, value) -> {
                Object convertedValue;
                if (!this.shadowed(name) && !this.removed(name) && (convertedValue = this.type.convert(name, value)) != null) {
                    consumer.accept(name, convertedValue);
                }
            });
        }

        void forEachFieldAsRaw(Hit.RawUtf8Consumer consumer) {
            this.data.traverse((name, value) -> {
                DocsumField fieldType;
                if (!this.shadowed(name) && !this.removed(name) && (fieldType = this.type.fields().get(name)) != null) {
                    if (fieldType.isString()) {
                        byte[] utf8Value = value.asUtf8();
                        consumer.accept(name, utf8Value, 0, utf8Value.length);
                    } else {
                        Object convertedValue = fieldType.convert(value);
                        if (convertedValue != null) {
                            consumer.accept(name, convertedValue);
                        }
                    }
                }
            });
        }

        Iterator<Map.Entry<String, Object>> fieldIterator() {
            return new SummaryDataFieldIterator(this, this.type, this.data.fields().iterator());
        }

        Iterator<String> fieldNameIterator() {
            return new SummaryDataFieldNameIterator(this, this.data.fields().iterator());
        }

        private boolean shadowed(String name) {
            if (this.hit.hasField(name)) {
                return true;
            }
            for (int i = 0; i < this.hit.summaries.size() - this.index; ++i) {
                if (!this.hit.summaries.get((int)i).type.fields().containsKey(name)) continue;
                return true;
            }
            return false;
        }

        private boolean removed(String fieldName) {
            return this.hit.removedFields != null && this.hit.removedFields.contains(fieldName);
        }

        private static class SummaryDataFieldIterator
        extends SummaryDataIterator<Map.Entry<String, Object>> {
            private final DocsumDefinition type;

            SummaryDataFieldIterator(SummaryData summaryData, DocsumDefinition type, Iterator<Map.Entry<String, Inspector>> fieldIterator) {
                super(summaryData, fieldIterator);
                this.type = type;
                this.advanceNext();
            }

            @Override
            protected Map.Entry<String, Object> toValue(Map.Entry<String, Inspector> field) {
                Object convertedValue = this.type.convert(field.getKey(), field.getValue());
                if (convertedValue == null) {
                    return null;
                }
                return new SummaryFieldEntry(field.getKey(), convertedValue);
            }

            private static final class SummaryFieldEntry
            implements Map.Entry<String, Object> {
                private final String key;
                private final Object value;

                SummaryFieldEntry(String key, Object value) {
                    this.key = key;
                    this.value = value;
                }

                @Override
                public String getKey() {
                    return this.key;
                }

                @Override
                public Object getValue() {
                    return this.value;
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            }
        }

        private static class SummaryDataFieldNameIterator
        extends SummaryDataIterator<String> {
            SummaryDataFieldNameIterator(SummaryData summaryData, Iterator<Map.Entry<String, Inspector>> fieldIterator) {
                super(summaryData, fieldIterator);
                this.advanceNext();
            }

            @Override
            protected String toValue(Map.Entry<String, Inspector> field) {
                return field.getKey();
            }
        }

        private static abstract class SummaryDataIterator<VALUE>
        implements Iterator<VALUE> {
            private final SummaryData summaryData;
            private final Iterator<Map.Entry<String, Inspector>> fieldIterator;
            private VALUE next;

            SummaryDataIterator(SummaryData summaryData, Iterator<Map.Entry<String, Inspector>> fieldIterator) {
                this.summaryData = summaryData;
                this.fieldIterator = fieldIterator;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public VALUE next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                VALUE returnValue = this.next;
                this.advanceNext();
                return returnValue;
            }

            protected abstract VALUE toValue(Map.Entry<String, Inspector> var1);

            void advanceNext() {
                while (this.fieldIterator.hasNext()) {
                    Map.Entry<String, Inspector> nextEntry = this.fieldIterator.next();
                    String fieldName = nextEntry.getKey();
                    this.next = this.toValue(nextEntry);
                    if (this.next == null || this.summaryData.shadowed(fieldName) || this.summaryData.removed(fieldName)) continue;
                    return;
                }
                this.next = null;
            }
        }
    }

    private static class FieldIterator
    extends SummaryIterator<Map.Entry<String, Object>> {
        FieldIterator(FastHit hit, Iterator<Map.Entry<String, Object>> mapFieldsIterator) {
            super(hit, mapFieldsIterator);
        }

        @Override
        protected String nameOf(Map.Entry<String, Object> value) {
            return value.getKey();
        }

        @Override
        protected Iterator<Map.Entry<String, Object>> iteratorFor(SummaryData summary) {
            return summary.fieldIterator();
        }
    }

    private static class FieldSet
    implements Set<String> {
        private final FastHit hit;
        private Set<String> fieldSet = null;

        FieldSet(FastHit hit) {
            this.hit = hit;
        }

        @Override
        public int size() {
            return this.createSet().size();
        }

        @Override
        public boolean isEmpty() {
            if (!this.hit.hasFields() && this.hit.summaries.isEmpty()) {
                return true;
            }
            return this.createSet().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            String field = (String)o;
            if (this.hit.hasField(field)) {
                return true;
            }
            return this.createSet().contains(field);
        }

        @Override
        public Object[] toArray() {
            return this.createSet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.createSet().toArray(a);
        }

        @Override
        public boolean add(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            boolean removed;
            String field = (String)o;
            boolean bl = removed = this.hit.removeField(field) != null;
            if (this.fieldSet != null) {
                this.fieldSet.remove(field);
            }
            return removed;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object field : c) {
                if (this.contains(field)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Set<Object> toRetain = c instanceof Set ? (Set<Object>)c : new HashSet(c);
            boolean anyRemoved = false;
            Iterator<String> i = this.iterator();
            while (i.hasNext()) {
                String field = i.next();
                if (toRetain.contains(field)) continue;
                i.remove();
                anyRemoved = true;
            }
            return anyRemoved;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean anyRemoved = false;
            for (Object field : c) {
                if (!this.remove(field)) continue;
                anyRemoved = true;
            }
            return anyRemoved;
        }

        @Override
        public void clear() {
            this.hit.clearFields();
            this.fieldSet = null;
        }

        @Override
        public Iterator<String> iterator() {
            return this.hit.fieldNameIterator();
        }

        @Override
        public int hashCode() {
            return this.createSet().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            return this.createSet().equals(o);
        }

        public String toString() {
            return this.createSet().toString();
        }

        private Set<String> createSet() {
            if (this.fieldSet != null) {
                return this.fieldSet;
            }
            if (!this.hit.hasFields() && this.hit.summaries.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<String> fields = new HashSet<String>();
            if (this.hit.hasFields()) {
                fields.addAll(this.hit.mapFieldKeys());
            }
            for (SummaryData summaryData : this.hit.summaries) {
                summaryData.data.traverse((name, __) -> fields.add(name));
            }
            if (this.hit.removedFields != null) {
                fields.removeAll(this.hit.removedFields);
            }
            this.fieldSet = fields;
            return fields;
        }
    }

    private static class FieldNameIterator
    extends SummaryIterator<String> {
        FieldNameIterator(FastHit hit, Iterator<String> mapFieldNamesIterator) {
            super(hit, mapFieldNamesIterator);
        }

        @Override
        protected String nameOf(String value) {
            return value;
        }

        @Override
        protected Iterator<String> iteratorFor(SummaryData summary) {
            return summary.fieldNameIterator();
        }
    }

    private static abstract class SummaryIterator<VALUE>
    implements Iterator<VALUE> {
        private final FastHit hit;
        private int currentSummaryDataIndex = -1;
        private Iterator<VALUE> currentIterator;
        private VALUE previousReturned = null;

        SummaryIterator(FastHit hit, Iterator<VALUE> mapFieldsIterator) {
            this.hit = hit;
            this.currentIterator = mapFieldsIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator.hasNext()) {
                return true;
            }
            return this.nextIterator();
        }

        @Override
        public VALUE next() {
            if (this.currentIterator.hasNext() || this.nextIterator()) {
                this.previousReturned = this.currentIterator.next();
                return this.previousReturned;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.previousReturned == null) {
                throw new IllegalStateException();
            }
            if (!(this.currentIterator instanceof SummaryData.SummaryDataIterator)) {
                this.currentIterator.remove();
            }
            if (this.hit.removedFields == null) {
                this.hit.removedFields = new HashSet<String>();
            }
            this.hit.removedFields.add(this.nameOf(this.previousReturned));
            this.previousReturned = null;
        }

        protected abstract String nameOf(VALUE var1);

        protected abstract Iterator<VALUE> iteratorFor(SummaryData var1);

        private boolean nextIterator() {
            while (++this.currentSummaryDataIndex < this.hit.summaries.size()) {
                this.currentIterator = this.iteratorFor(this.hit.summaries.get(this.currentSummaryDataIndex));
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            return false;
        }
    }
}

