/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

class StringUnescaper {
    StringUnescaper() {
    }

    private static boolean lookaheadOctal(String v, int point) {
        return point < v.length() && "01234567".indexOf(v.charAt(point)) != -1;
    }

    public static String unquote(String token) {
        if (!(null != token && (token.startsWith("'") && token.endsWith("'") || token.startsWith("\"") && token.endsWith("\"")))) {
            return token;
        }
        String value = token.substring(1, token.length() - 1);
        int idx = value.indexOf(92);
        if (idx == -1) {
            return value;
        }
        StringBuilder result = new StringBuilder(value.length());
        int start = 0;
        while (idx != -1) {
            result.append(value.subSequence(start, idx));
            start = idx + 1;
            switch (value.charAt(start)) {
                case 'b': {
                    result.append('\b');
                    ++start;
                    break;
                }
                case 't': {
                    result.append('\t');
                    ++start;
                    break;
                }
                case 'n': {
                    result.append('\n');
                    ++start;
                    break;
                }
                case 'f': {
                    result.append('\f');
                    ++start;
                    break;
                }
                case 'r': {
                    result.append('\r');
                    ++start;
                    break;
                }
                case '\"': {
                    result.append('\"');
                    ++start;
                    break;
                }
                case '\'': {
                    result.append('\'');
                    ++start;
                    break;
                }
                case '\\': {
                    result.append('\\');
                    ++start;
                    break;
                }
                case '/': {
                    result.append('/');
                    ++start;
                    break;
                }
                case 'u': {
                    result.append((char)Integer.parseInt(value.substring(++start, start + 4), 16));
                    start += 4;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    if (StringUnescaper.lookaheadOctal(value, start + 1) && StringUnescaper.lookaheadOctal(value, start + 2)) {
                        result.append((char)Integer.parseInt(value.substring(start, start + 3), 8));
                        start += 3;
                        break;
                    }
                    if (StringUnescaper.lookaheadOctal(value, start + 1)) {
                        result.append((char)Integer.parseInt(value.substring(start, start + 2), 8));
                        start += 2;
                        break;
                    }
                    result.append((char)Integer.parseInt(value.substring(start, start + 1), 8));
                    ++start;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown escape sequence in token: " + token);
                }
            }
            idx = value.indexOf(92, start);
        }
        result.append(value.subSequence(start, value.length()));
        return result.toString();
    }

    public static String escape(String value) {
        int idx = value.indexOf(39);
        if (idx == -1) {
            return "'" + value + "'";
        }
        StringBuilder result = new StringBuilder(value.length() + 5);
        result.append("'");
        int start = 0;
        while (idx != -1) {
            result.append(value.subSequence(start, idx));
            start = idx + 1;
            result.append("\\'");
            idx = value.indexOf(92, start);
        }
        result.append(value.subSequence(start, value.length()));
        result.append("'");
        return result.toString();
    }
}

