/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.api.annotations.Beta;
import com.yahoo.search.schema.DocumentSummary;
import com.yahoo.search.schema.RankProfile;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@Beta
public class Schema {
    private final String name;
    private final Map<String, RankProfile> rankProfiles;
    private final Map<String, DocumentSummary> documentSummaries;

    private Schema(Builder builder) {
        this.name = builder.name;
        this.rankProfiles = Collections.unmodifiableMap(builder.rankProfiles);
        this.documentSummaries = Collections.unmodifiableMap(builder.documentSummaries);
        this.rankProfiles.values().forEach(rankProfile -> rankProfile.setSchema(this));
    }

    public String name() {
        return this.name;
    }

    public Map<String, RankProfile> rankProfiles() {
        return this.rankProfiles;
    }

    public Map<String, DocumentSummary> documentSummaries() {
        return this.documentSummaries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (!other.rankProfiles.equals(this.rankProfiles)) {
            return false;
        }
        return other.documentSummaries.equals(this.documentSummaries);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rankProfiles, this.documentSummaries);
    }

    public String toString() {
        return "schema '" + this.name + "'";
    }

    public static class Builder {
        private final String name;
        private final Map<String, RankProfile> rankProfiles = new LinkedHashMap<String, RankProfile>();
        private final Map<String, DocumentSummary> documentSummaries = new LinkedHashMap<String, DocumentSummary>();

        public Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder add(RankProfile profile) {
            this.rankProfiles.put(profile.name(), profile);
            return this;
        }

        public Builder add(DocumentSummary documentSummary) {
            this.documentSummaries.put(documentSummary.name(), documentSummary);
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

