/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import ai.vespa.models.evaluation.FunctionEvaluator;
import ai.vespa.models.evaluation.Model;
import ai.vespa.models.evaluation.ModelsEvaluator;
import com.yahoo.api.annotations.Beta;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;

@Beta
public class RankProfilesEvaluator
extends AbstractComponent {
    private final ModelsEvaluator evaluator;
    private static final Logger logger = Logger.getLogger(RankProfilesEvaluator.class.getName());
    private Map<String, GlobalPhaseData> profilesWithGlobalPhase = new HashMap<String, GlobalPhaseData>();

    @Inject
    public RankProfilesEvaluator(RankProfilesConfig rankProfilesConfig, RankingConstantsConfig constantsConfig, RankingExpressionsConfig expressionsConfig, OnnxModelsConfig onnxModelsConfig, FileAcquirer fileAcquirer) {
        this.evaluator = new ModelsEvaluator(rankProfilesConfig, constantsConfig, expressionsConfig, onnxModelsConfig, fileAcquirer);
        this.extractGlobalPhaseData(rankProfilesConfig);
    }

    public Model modelForRankProfile(String rankProfile) {
        Model m = (Model)this.evaluator.models().get(rankProfile);
        if (m == null) {
            throw new IllegalArgumentException("unknown rankprofile: " + rankProfile);
        }
        return m;
    }

    public FunctionEvaluator evaluatorForFunction(String rankProfile, String functionName) {
        return this.modelForRankProfile(rankProfile).evaluatorOf(new String[]{functionName});
    }

    Optional<GlobalPhaseData> getGlobalPhaseData(String rankProfile) {
        return Optional.ofNullable(this.profilesWithGlobalPhase.get(rankProfile));
    }

    private void extractGlobalPhaseData(RankProfilesConfig rankProfilesConfig) {
        for (RankProfilesConfig.Rankprofile rp : rankProfilesConfig.rankprofile()) {
            String name = rp.name();
            Supplier<FunctionEvaluator> functionEvaluatorSource = null;
            int rerankCount = -1;
            List needInputs = null;
            for (RankProfilesConfig.Rankprofile.Fef.Property prop : rp.fef().property()) {
                if (prop.name().equals("vespa.globalphase.rerankcount")) {
                    rerankCount = Integer.valueOf(prop.value());
                }
                if (!prop.name().equals("vespa.rank.globalphase")) continue;
                Model model = this.modelForRankProfile(name);
                functionEvaluatorSource = () -> model.evaluatorOf(new String[]{"globalphase"});
                FunctionEvaluator evaluator = functionEvaluatorSource.get();
                needInputs = List.copyOf(evaluator.function().arguments());
            }
            if (functionEvaluatorSource == null || needInputs == null) continue;
            this.profilesWithGlobalPhase.put(name, new GlobalPhaseData(functionEvaluatorSource, rerankCount, needInputs));
        }
    }

    record GlobalPhaseData(Supplier<FunctionEvaluator> functionEvaluatorSource, int rerankCount, List<String> needInputs) {
    }
}

