/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.yahoo.container.handler.VipStatus;
import com.yahoo.net.HostName;
import com.yahoo.prelude.Pong;
import com.yahoo.search.cluster.ClusterMonitor;
import com.yahoo.search.cluster.NodeManager;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.PingFactory;
import com.yahoo.search.dispatch.searchcluster.Pinger;
import com.yahoo.search.dispatch.searchcluster.PongHandler;
import com.yahoo.search.dispatch.searchcluster.SearchGroups;
import com.yahoo.search.dispatch.searchcluster.SearchGroupsImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SearchCluster
implements NodeManager<Node> {
    private static final Logger log = Logger.getLogger(SearchCluster.class.getName());
    private final String clusterId;
    private final VipStatus vipStatus;
    private final PingFactory pingFactory;
    private final SearchGroupsImpl groups;
    private volatile long nextLogTime = 0L;
    private final Node localCorpusDispatchTarget;

    public SearchCluster(String clusterId, double minActivedocsPercentage, Collection<Node> nodes, VipStatus vipStatus, PingFactory pingFactory) {
        this(clusterId, SearchCluster.toGroups(nodes, minActivedocsPercentage), vipStatus, pingFactory);
    }

    public SearchCluster(String clusterId, SearchGroupsImpl groups, VipStatus vipStatus, PingFactory pingFactory) {
        this.clusterId = clusterId;
        this.vipStatus = vipStatus;
        this.pingFactory = pingFactory;
        this.groups = groups;
        this.localCorpusDispatchTarget = SearchCluster.findLocalCorpusDispatchTarget(HostName.getLocalhost(), groups);
    }

    @Override
    public String name() {
        return this.clusterId;
    }

    public VipStatus getVipStatus() {
        return this.vipStatus;
    }

    public void addMonitoring(ClusterMonitor<Node> clusterMonitor) {
        for (Group group : this.groups()) {
            for (Node node : group.nodes()) {
                clusterMonitor.add(node, true);
            }
        }
    }

    private static Node findLocalCorpusDispatchTarget(String selfHostname, SearchGroups groups) {
        List<Node> localSearchNodes = groups.groups().stream().flatMap(g -> g.nodes().stream()).filter(node -> node.hostname().equals(selfHostname)).toList();
        if (localSearchNodes.size() != 1) {
            return null;
        }
        Node localSearchNode = localSearchNodes.iterator().next();
        Group localSearchGroup = groups.get(localSearchNode.group());
        if (localSearchGroup.nodes().size() != 1) {
            return null;
        }
        return localSearchNode;
    }

    private static SearchGroupsImpl toGroups(Collection<Node> nodes, double minActivedocsPercentage) {
        HashMap<Integer, Group> groups = new HashMap<Integer, Group>();
        for (Map.Entry<Integer, List<Node>> group : nodes.stream().collect(Collectors.groupingBy(Node::group)).entrySet()) {
            Group g = new Group(group.getKey(), group.getValue());
            groups.put(group.getKey(), g);
        }
        return new SearchGroupsImpl(Map.copyOf(groups), minActivedocsPercentage);
    }

    public SearchGroups groupList() {
        return this.groups;
    }

    public Group group(int id) {
        return this.groups.get(id);
    }

    private Collection<Group> groups() {
        return this.groups.groups();
    }

    public int groupsWithSufficientCoverage() {
        return (int)this.groups().stream().filter(Group::hasSufficientCoverage).count();
    }

    public Optional<Node> localCorpusDispatchTarget() {
        if (this.localCorpusDispatchTarget == null) {
            return Optional.empty();
        }
        Group localSearchGroup = this.groups.get(this.localCorpusDispatchTarget.group());
        if (!localSearchGroup.hasSufficientCoverage()) {
            return Optional.empty();
        }
        if (this.localCorpusDispatchTarget.isWorking() == Boolean.FALSE) {
            return Optional.empty();
        }
        return Optional.of(this.localCorpusDispatchTarget);
    }

    private void updateWorkingState(Node node, boolean isWorking) {
        node.setWorking(isWorking);
        this.updateVipStatusOnNodeChange(node, isWorking);
    }

    @Override
    public void working(Node node) {
        this.updateWorkingState(node, true);
    }

    @Override
    public void failed(Node node) {
        this.updateWorkingState(node, false);
    }

    private void updateSufficientCoverage(Group group, boolean sufficientCoverage) {
        if (sufficientCoverage == group.hasSufficientCoverage()) {
            return;
        }
        group.setHasSufficientCoverage(sufficientCoverage);
        this.updateVipStatusOnCoverageChange(group, sufficientCoverage);
    }

    private void updateVipStatusOnNodeChange(Node node, boolean nodeIsWorking) {
        if (this.localCorpusDispatchTarget == null) {
            if (this.hasInformationAboutAllNodes()) {
                this.setInRotationOnlyIf(this.hasWorkingNodes());
            }
        } else if (this.usesLocalCorpusIn(node) && (nodeIsWorking || this.groups().stream().map(Group::nodes).count() > 1L)) {
            this.setInRotationOnlyIf(nodeIsWorking);
        }
    }

    private void updateVipStatusOnCoverageChange(Group group, boolean sufficientCoverage) {
        if (this.localCorpusDispatchTarget != null && this.usesLocalCorpusIn(group)) {
            this.setInRotationOnlyIf(sufficientCoverage);
        }
    }

    private void setInRotationOnlyIf(boolean inRotation) {
        if (inRotation) {
            this.vipStatus.addToRotation(this.clusterId);
        } else {
            this.vipStatus.removeFromRotation(this.clusterId);
        }
    }

    public boolean hasInformationAboutAllNodes() {
        return this.groups().stream().allMatch(group -> group.nodes().stream().allMatch(node -> node.isWorking() != null));
    }

    public long nonWorkingNodeCount() {
        return this.groups().stream().flatMap(group -> group.nodes().stream()).filter(node -> node.isWorking() == Boolean.FALSE).count();
    }

    private boolean hasWorkingNodes() {
        return this.groups().stream().anyMatch(group -> group.nodes().stream().anyMatch(node -> node.isWorking() != Boolean.FALSE));
    }

    private boolean usesLocalCorpusIn(Node node) {
        return node.equals(this.localCorpusDispatchTarget);
    }

    private boolean usesLocalCorpusIn(Group group) {
        return this.localCorpusDispatchTarget != null && this.localCorpusDispatchTarget.group() == group.id();
    }

    @Override
    public void ping(ClusterMonitor clusterMonitor, Node node, Executor executor) {
        Pinger pinger = this.pingFactory.createPinger(node, clusterMonitor, new PongCallback(node, clusterMonitor));
        pinger.ping();
    }

    private void pingIterationCompletedSingleGroup() {
        Group group = this.groups().iterator().next();
        group.aggregateNodeValues();
        this.updateSufficientCoverage(group, true);
        boolean sufficientCoverage = this.groups.isGroupCoverageSufficient(group.activeDocuments(), group.activeDocuments());
        this.trackGroupCoverageChanges(group, sufficientCoverage, group.activeDocuments());
    }

    private void pingIterationCompletedMultipleGroups() {
        this.groups().forEach(Group::aggregateNodeValues);
        long medianDocuments = this.groups.medianDocumentsPerGroup();
        for (Group group : this.groups()) {
            boolean sufficientCoverage = this.groups.isGroupCoverageSufficient(group.activeDocuments(), medianDocuments);
            this.updateSufficientCoverage(group, sufficientCoverage);
            this.trackGroupCoverageChanges(group, sufficientCoverage, medianDocuments);
        }
    }

    @Override
    public void pingIterationCompleted() {
        if (this.groups.size() == 1) {
            this.pingIterationCompletedSingleGroup();
        } else {
            this.pingIterationCompletedMultipleGroups();
        }
    }

    private void trackGroupCoverageChanges(Group group, boolean fullCoverage, long medianDocuments) {
        if (!this.hasInformationAboutAllNodes()) {
            return;
        }
        boolean changed = group.fullCoverageStatusChanged(fullCoverage);
        if (changed || !fullCoverage && System.currentTimeMillis() > this.nextLogTime) {
            this.nextLogTime = System.currentTimeMillis() + 30000L;
            if (fullCoverage) {
                log.info("Cluster " + this.clusterId + ": " + group + " has full coverage. Active documents: " + group.activeDocuments() + "/" + medianDocuments + ", Target active documents: " + group.targetActiveDocuments() + ", working nodes: " + group.workingNodes() + "/" + group.nodes().size());
            } else {
                StringBuilder unresponsive = new StringBuilder();
                for (Node node : group.nodes()) {
                    if (node.isWorking() == Boolean.TRUE) continue;
                    unresponsive.append('\n').append(node);
                }
                String message = "Cluster " + this.clusterId + ": " + group + " has reduced coverage: Active documents: " + group.activeDocuments() + "/" + medianDocuments + ", Target active documents: " + group.targetActiveDocuments() + ", working nodes: " + group.workingNodes() + "/" + group.nodes().size() + ", unresponsive nodes: " + (Serializable)((Object)(unresponsive.toString().isEmpty() ? " none" : unresponsive));
                if (this.nonWorkingNodeCount() == 1L) {
                    log.info(message);
                } else {
                    log.warning(message);
                }
            }
        }
    }

    private static class PongCallback
    implements PongHandler {
        private final ClusterMonitor<Node> clusterMonitor;
        private final Node node;

        PongCallback(Node node, ClusterMonitor<Node> clusterMonitor) {
            this.node = node;
            this.clusterMonitor = clusterMonitor;
        }

        @Override
        public void handle(Pong pong) {
            if (pong.badResponse()) {
                this.clusterMonitor.failed(this.node, pong.error().get());
            } else {
                if (pong.activeDocuments().isPresent()) {
                    this.node.setActiveDocuments(pong.activeDocuments().get());
                    this.node.setTargetActiveDocuments(pong.targetActiveDocuments().get());
                    this.node.setBlockingWrites(pong.isBlockingWrites());
                }
                this.clusterMonitor.responded(this.node);
            }
        }
    }
}

