/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.util.Objects;

public abstract class SegmentItem
extends CompositeItem
implements BlockItem {
    private boolean locked = false;
    private final String rawWord;
    private final String value;
    private final boolean isFromQuery;
    private boolean isFromUser;
    private final boolean stemmed;
    private SegmentingRule segmentingRule = SegmentingRule.LANGUAGE_DEFAULT;
    private final Substring origin;

    public SegmentItem(String rawWord, String current, boolean isFromQuery, boolean stemmed) {
        this(rawWord, current, isFromQuery, stemmed, null);
    }

    public SegmentItem(String rawWord, String current, boolean isFromQuery, boolean stemmed, Substring origin) {
        this.rawWord = rawWord;
        this.value = current;
        this.stemmed = stemmed;
        this.isFromQuery = isFromQuery;
        this.isFromUser = isFromQuery;
        this.origin = origin;
    }

    @Override
    public String getRawWord() {
        return this.rawWord;
    }

    public String getNormalized() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public boolean isFromQuery() {
        return this.isFromQuery;
    }

    @Override
    public boolean isStemmed() {
        return this.stemmed;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public int getNumWords() {
        return this.getItemCount();
    }

    @Override
    public void addItem(Item item) {
        this.throwIfLocked();
        super.addItem(item);
    }

    @Override
    public void addItem(int index, Item item) {
        this.throwIfLocked();
        super.addItem(index, item);
    }

    @Override
    public Item removeItem(int index) {
        this.throwIfLocked();
        return super.removeItem(index);
    }

    @Override
    public boolean removeItem(Item item) {
        this.throwIfLocked();
        return super.removeItem(item);
    }

    private void throwIfLocked() {
        if (this.locked) {
            throw new IllegalStateException("Cannot change change an immutable segment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentItem clone() {
        SegmentItem copy;
        SegmentItem segmentItem = this;
        synchronized (segmentItem) {
            boolean tmpLock = this.locked;
            this.locked = false;
            copy = (SegmentItem)super.clone();
            this.locked = tmpLock;
            copy.locked = tmpLock;
        }
        return copy;
    }

    @Override
    public boolean isWords() {
        return true;
    }

    public boolean isFromUser() {
        return this.isFromUser;
    }

    public void setFromUser(boolean isFromUser) {
        this.isFromUser = isFromUser;
    }

    @Override
    public Substring getOrigin() {
        return this.origin;
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("isFromQuery", this.isFromQuery);
        discloser.addProperty("isFromUser", this.isFromUser);
        discloser.addProperty("locked", this.locked);
        discloser.addProperty("rawWord", this.rawWord);
        discloser.addProperty("stemmed", this.stemmed);
    }

    @Override
    public SegmentingRule getSegmentingRule() {
        return this.segmentingRule;
    }

    public void setSegmentingRule(SegmentingRule segmentingRule) {
        this.segmentingRule = segmentingRule;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SegmentItem other = (SegmentItem)o;
        if (!Objects.equals(this.rawWord, other.rawWord)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (this.isFromQuery != other.isFromQuery) {
            return false;
        }
        if (this.isFromUser != other.isFromUser) {
            return false;
        }
        if (this.stemmed != other.stemmed) {
            return false;
        }
        if (this.segmentingRule != other.segmentingRule) {
            return false;
        }
        return Objects.equals(this.origin, other.origin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.rawWord, this.value, this.isFromQuery, this.isFromUser, this.stemmed, this.segmentingRule, this.origin});
    }
}

