/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.MultiRangeItem;
import com.yahoo.prelude.query.SimpleTaggableItem;
import java.nio.ByteBuffer;

abstract class MultiTermItem
extends SimpleTaggableItem {
    MultiTermItem() {
    }

    abstract OperatorType operatorType();

    abstract TermType termType();

    abstract int terms();

    abstract void encodeBlueprint(ByteBuffer var1);

    abstract void encodeTerms(ByteBuffer var1);

    abstract Item asCompositeItem();

    @Override
    public final Item.ItemType getItemType() {
        return Item.ItemType.MULTI_TERM;
    }

    @Override
    public final String getName() {
        return this.getItemType().name();
    }

    @Override
    public final int encode(ByteBuffer buffer) {
        if (this.getClass() == MultiRangeItem.class) {
            return this.asCompositeItem().encode(buffer);
        }
        super.encodeThis(buffer);
        byte metadata = 0;
        metadata = (byte)(metadata | this.operatorType().code << 5 & 0xE0);
        metadata = (byte)(metadata | this.termType().code & 0x1F);
        buffer.put(metadata);
        buffer.putInt(this.terms());
        this.encodeBlueprint(buffer);
        this.encodeTerms(buffer);
        return 1;
    }

    @Override
    public final int getTermCount() {
        return 1;
    }

    static enum OperatorType {
        AND(0),
        OR(1);

        private final byte code;

        private OperatorType(int code) {
            this.code = (byte)code;
        }
    }

    static enum TermType {
        RANGES(0);

        private final byte code;

        private TermType(int code) {
            this.code = (byte)code;
        }
    }
}

