/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain.model.federation;

import java.util.Objects;

public class FederationOptions
implements Cloneable {
    private final Boolean optional;
    private final Integer timeoutInMilliseconds;
    private final Integer requestTimeoutInMilliseconds;
    private final Boolean useByDefault;

    public FederationOptions(Boolean optional, Integer timeoutInMilliseconds, Boolean useByDefault) {
        this(optional, timeoutInMilliseconds, null, useByDefault);
    }

    public FederationOptions(Boolean optional, Integer timeoutInMilliseconds, Integer requestTimeoutInMilliseconds, Boolean useByDefault) {
        this.optional = optional;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.requestTimeoutInMilliseconds = requestTimeoutInMilliseconds;
        this.useByDefault = useByDefault;
    }

    public FederationOptions() {
        this(null, null, null, null);
    }

    public FederationOptions setOptional(Boolean newOptional) {
        return new FederationOptions(newOptional, this.timeoutInMilliseconds, this.requestTimeoutInMilliseconds, this.useByDefault);
    }

    public FederationOptions setTimeoutInMilliseconds(Integer newTimeoutInMilliseconds) {
        return new FederationOptions(this.optional, newTimeoutInMilliseconds, this.requestTimeoutInMilliseconds, this.useByDefault);
    }

    public FederationOptions setRequestTimeoutInMilliseconds(Integer newRequestTimeoutInMilliseconds) {
        return new FederationOptions(this.optional, this.timeoutInMilliseconds, newRequestTimeoutInMilliseconds, this.useByDefault);
    }

    public FederationOptions setUseByDefault(Boolean newUseByDefault) {
        return new FederationOptions(this.optional, this.timeoutInMilliseconds, this.requestTimeoutInMilliseconds, newUseByDefault);
    }

    public boolean getOptional() {
        return this.optional != null ? this.optional : false;
    }

    public int getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds != null ? this.timeoutInMilliseconds : -1;
    }

    public int getRequestTimeoutInMilliseconds() {
        return this.requestTimeoutInMilliseconds != null ? this.requestTimeoutInMilliseconds : -1;
    }

    public long getSearchChainExecutionTimeoutInMilliseconds(long queryTimeout) {
        return this.getTimeoutInMilliseconds() >= 0 ? (long)this.getTimeoutInMilliseconds() : queryTimeout;
    }

    public boolean getUseByDefault() {
        return this.useByDefault != null ? this.useByDefault : false;
    }

    public FederationOptions inherit(FederationOptions parent) {
        return new FederationOptions(FederationOptions.inherit(this.optional, parent.optional), FederationOptions.inherit(this.timeoutInMilliseconds, parent.timeoutInMilliseconds), FederationOptions.inherit(this.requestTimeoutInMilliseconds, parent.requestTimeoutInMilliseconds), FederationOptions.inherit(this.useByDefault, parent.useByDefault));
    }

    private static <T> T inherit(T child, T parent) {
        return child != null ? child : parent;
    }

    public boolean equals(Object other) {
        return other instanceof FederationOptions && this.equals((FederationOptions)other);
    }

    public boolean equals(FederationOptions other) {
        return this.getOptional() == other.getOptional() && this.getTimeoutInMilliseconds() == other.getTimeoutInMilliseconds();
    }

    public int hashCode() {
        return Objects.hash(this.getOptional(), this.getTimeoutInMilliseconds());
    }

    public String toString() {
        return "FederationOptions{optional=" + this.optional + ", timeoutInMilliseconds=" + this.timeoutInMilliseconds + ", useByDefault=" + this.useByDefault + "}";
    }
}

