/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.handler;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.processing.IllegalInputException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

class Json2SingleLevelMap {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private final byte[] buf;
    private final JsonParser parser;

    Json2SingleLevelMap(InputStream data) {
        try {
            this.buf = data.readAllBytes();
            this.parser = jsonMapper.createParser(this.buf);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading POSTed data", e);
        }
    }

    Map<String, String> parse() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IllegalInputException("Expected start of object, got '" + this.parser.currentToken() + "'");
            }
            this.parse(map, "");
            return map;
        }
        catch (JsonParseException e) {
            throw new IllegalInputException("Json parse error.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading POSTed data", e);
        }
    }

    void parse(Map<String, String> map, String parent) throws IOException {
        this.parser.nextToken();
        while (this.parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parent + this.parser.getCurrentName();
            JsonToken token = this.parser.nextToken();
            if (token == JsonToken.VALUE_STRING || token == JsonToken.VALUE_NUMBER_FLOAT || token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_NULL) {
                map.put(fieldName, this.parser.getText());
            } else if (token == JsonToken.START_ARRAY) {
                map.put(fieldName, this.skipChildren(this.parser, this.buf));
            } else if (token == JsonToken.START_OBJECT) {
                if (fieldName.equals("select.where") || fieldName.equals("select.grouping")) {
                    map.put(fieldName, this.skipChildren(this.parser, this.buf));
                } else {
                    this.parse(map, fieldName + ".");
                }
            } else {
                throw new IllegalInputException("In field '" + fieldName + "', got unknown json token '" + token.asString() + "'");
            }
            this.parser.nextToken();
        }
    }

    private String skipChildren(JsonParser parser, byte[] input) throws IOException {
        JsonLocation start = parser.getCurrentLocation();
        parser.skipChildren();
        JsonLocation end = parser.getCurrentLocation();
        int offset = (int)start.getByteOffset() - 1;
        return new String(input, offset, (int)(end.getByteOffset() - (long)offset), StandardCharsets.UTF_8);
    }
}

