/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.vespa.CompositeContinuation;
import com.yahoo.search.grouping.vespa.OffsetContinuation;
import com.yahoo.search.grouping.vespa.ResultId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class GroupingTransform {
    private final Map<Integer, Set<Integer>> children = new HashMap<Integer, Set<Integer>>();
    private final Map<Integer, String> labels = new HashMap<Integer, String>();
    private final Map<Integer, Integer> maxes = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> offsetByTag = new HashMap<Integer, Integer>();
    private final Map<ResultId, Integer> offsetById = new HashMap<ResultId, Integer>();
    private final Set<ResultId> unstable = new HashSet<ResultId>();
    private final int requestId;

    public GroupingTransform(int requestId) {
        this.requestId = requestId;
    }

    public GroupingTransform addContinuation(Continuation cont) {
        if (cont instanceof CompositeContinuation) {
            for (Continuation item : (CompositeContinuation)cont) {
                this.addContinuation(item);
            }
        } else if (cont instanceof OffsetContinuation) {
            OffsetContinuation offsetCont = (OffsetContinuation)cont;
            ResultId id = offsetCont.getResultId();
            if (!id.startsWith(this.requestId)) {
                return this;
            }
            if (offsetCont.testFlag(1)) {
                this.unstable.add(id);
            } else {
                this.unstable.remove(id);
            }
            int tag = offsetCont.getTag();
            int offset = offsetCont.getOffset();
            if (this.getOffset(tag) < offset) {
                this.offsetByTag.put(tag, offset);
            }
            this.offsetById.put(id, offset);
        } else {
            throw new UnsupportedOperationException(cont.getClass().getName());
        }
        return this;
    }

    public boolean isStable(ResultId resultId) {
        return !this.unstable.contains(resultId);
    }

    public int getOffset(int tag) {
        return GroupingTransform.toPosInt(this.offsetByTag.get(tag));
    }

    public int getOffset(ResultId resultId) {
        return GroupingTransform.toPosInt(this.offsetById.get(resultId));
    }

    public GroupingTransform putMax(int tag, int max, String type) {
        if (this.maxes.containsKey(tag)) {
            throw new IllegalStateException("Can not set max of " + type + " " + tag + " to " + max + " because it is already set to " + this.maxes.get(tag) + ".");
        }
        this.maxes.put(tag, max);
        return this;
    }

    public int getMax(int tag) {
        return GroupingTransform.toPosInt(this.maxes.get(tag));
    }

    public GroupingTransform putLabel(int parentTag, int tag, String label, String type) {
        Set<Integer> siblings = this.children.get(parentTag);
        if (siblings == null) {
            siblings = new HashSet<Integer>();
            this.children.put(parentTag, siblings);
        } else {
            for (Integer sibling : siblings) {
                if (!label.equals(this.labels.get(sibling))) continue;
                throw new UnsupportedOperationException("Can not use " + type + " label '" + label + "' for multiple siblings.");
            }
        }
        siblings.add(tag);
        if (this.labels.containsKey(tag)) {
            throw new IllegalStateException("Can not set label of " + type + " " + tag + " to '" + label + "' because it is already set to '" + this.labels.get(tag) + "'.");
        }
        this.labels.put(tag, label);
        return this;
    }

    public String getLabel(int tag) {
        return this.labels.get(tag);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("groupingTransform {\n");
        ret.append("\tlabels {\n");
        for (Map.Entry<Integer, String> entry : this.labels.entrySet()) {
            ret.append("\t\t").append(entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
        }
        ret.append("\t}\n");
        ret.append("\toffsets {\n");
        for (Map.Entry<Integer, Object> entry : this.offsetByTag.entrySet()) {
            ret.append("\t\t").append(entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
        }
        ret.append("\t}\n");
        ret.append("\tmaxes {\n");
        for (Map.Entry<Integer, Object> entry : this.maxes.entrySet()) {
            ret.append("\t\t").append(entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
        }
        ret.append("\t}\n");
        ret.append("}");
        return ret.toString();
    }

    private static int toPosInt(Integer val) {
        return val == null ? 0 : Math.max(0, val);
    }
}

