/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.hitfield.BoldCloseFieldPart;
import com.yahoo.prelude.hitfield.BoldOpenFieldPart;
import com.yahoo.prelude.hitfield.FieldPart;
import com.yahoo.prelude.hitfield.HitField;
import com.yahoo.prelude.hitfield.SeparatorFieldPart;
import com.yahoo.prelude.hitfield.StringFieldPart;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
@Provides(value={"JuniperTagReplacing"})
public class JuniperSearcher
extends Searcher {
    public static final char RAW_HIGHLIGHT_CHAR = '\u001f';
    public static final char RAW_SEPARATOR_CHAR = '\u001e';
    private static final String ELLIPSIS = "...";
    public static final String JUNIPER_TAG_REPLACING = "JuniperTagReplacing";
    private final String boldOpenTag;
    private final String boldCloseTag;
    private final String separatorTag;

    @Inject
    public JuniperSearcher(ComponentId id, QrSearchersConfig config) {
        super(id);
        this.boldOpenTag = config.tag().bold().open();
        this.boldCloseTag = config.tag().bold().close();
        this.separatorTag = config.tag().separator();
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result result = execution.search(query);
        this.highlight(query.getPresentation().getBolding(), result.hits().deepIterator(), null, execution.context().getIndexFacts().newSession(query));
        return result;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        int worstCase = result.getHitCount();
        ArrayList<FastHit> hits = new ArrayList<FastHit>(worstCase);
        Iterator<Hit> i = result.hits().deepIterator();
        while (i.hasNext()) {
            FastHit fastHit;
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || (fastHit = (FastHit)hit).isFilled(summaryClass)) continue;
            hits.add(fastHit);
        }
        execution.fill(result, summaryClass);
        this.highlight(result.getQuery().getPresentation().getBolding(), hits.iterator(), summaryClass, execution.context().getIndexFacts().newSession(result.getQuery()));
    }

    private void highlight(boolean bolding, Iterator<Hit> hitsToHighlight, String summaryClass, IndexFacts.Session indexFacts) {
        while (hitsToHighlight.hasNext()) {
            Object searchDefinitionField;
            Hit hit = hitsToHighlight.next();
            if (!(hit instanceof FastHit)) continue;
            FastHit fastHit = (FastHit)hit;
            if (summaryClass != null && !fastHit.isFilled(summaryClass) || (searchDefinitionField = fastHit.getField("sddocname")) == null) continue;
            for (Index index : indexFacts.getIndexes(searchDefinitionField.toString())) {
                HitField fieldValue;
                if (!index.getDynamicSummary() && !index.getHighlightSummary() || (fieldValue = fastHit.buildHitField(index.getName(), true)) == null) continue;
                this.insertTags(fieldValue, bolding, index.getDynamicSummary());
            }
        }
    }

    private void insertTags(HitField field, boolean bolding, boolean dynteaser) {
        boolean insideHighlight = false;
        ListIterator<FieldPart> i = field.listIterator();
        while (i.hasNext()) {
            FieldPart f = i.next();
            if (f instanceof SeparatorFieldPart) {
                this.setSeparatorString(bolding, (SeparatorFieldPart)f);
            }
            if (f.isFinal()) continue;
            String toQuote = f.getContent();
            List<FieldPart> newFieldParts = null;
            int previous = 0;
            block5: for (int j = 0; j < toQuote.length(); ++j) {
                char key = toQuote.charAt(j);
                switch (key) {
                    case '\u001f': {
                        newFieldParts = this.initFieldParts(newFieldParts);
                        this.addBolding(bolding, insideHighlight, f, toQuote, newFieldParts, previous, j);
                        previous = j + 1;
                        insideHighlight = !insideHighlight;
                        continue block5;
                    }
                    case '\u001e': {
                        newFieldParts = this.initFieldParts(newFieldParts);
                        this.addSeparator(bolding, dynteaser, f, toQuote, newFieldParts, previous, j);
                        previous = j + 1;
                        continue block5;
                    }
                }
            }
            if (previous > 0 && previous < toQuote.length()) {
                newFieldParts.add(new StringFieldPart(toQuote.substring(previous), f.isToken()));
            }
            if (newFieldParts == null) continue;
            i.remove();
            Iterator j = newFieldParts.iterator();
            while (j.hasNext()) {
                i.add((FieldPart)j.next());
            }
        }
    }

    private void setSeparatorString(boolean bolding, SeparatorFieldPart f) {
        if (bolding) {
            f.setContent(this.separatorTag);
        } else {
            f.setContent(ELLIPSIS);
        }
    }

    private void addSeparator(boolean bolding, boolean dynteaser, FieldPart f, String toQuote, List<FieldPart> newFieldParts, int previous, int j) {
        if (previous != j) {
            newFieldParts.add(new StringFieldPart(toQuote.substring(previous, j), f.isToken()));
        }
        if (dynteaser) {
            newFieldParts.add(bolding ? new SeparatorFieldPart(this.separatorTag) : new SeparatorFieldPart(ELLIPSIS));
        }
    }

    private void addBolding(boolean bolding, boolean insideHighlight, FieldPart f, String toQuote, List<FieldPart> newFieldParts, int previous, int j) {
        if (previous != j) {
            newFieldParts.add(new StringFieldPart(toQuote.substring(previous, j), f.isToken()));
        }
        if (bolding) {
            if (insideHighlight) {
                newFieldParts.add(new BoldCloseFieldPart(this.boldCloseTag));
            } else if (newFieldParts.size() > 0 && newFieldParts.get(newFieldParts.size() - 1) instanceof BoldCloseFieldPart) {
                newFieldParts.remove(newFieldParts.size() - 1);
            } else {
                newFieldParts.add(new BoldOpenFieldPart(this.boldOpenTag));
            }
        }
    }

    private List<FieldPart> initFieldParts(List<FieldPart> newFieldParts) {
        if (newFieldParts == null) {
            newFieldParts = new ArrayList<FieldPart>();
        }
        return newFieldParts;
    }
}

