/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

@After(value={"unblendedResult", "Stemming"})
@Provides(value={"AccentRemoval"})
public class NormalizingSearcher
extends Searcher {
    public static final String ACCENT_REMOVAL = "AccentRemoval";
    private final Linguistics linguistics;

    @Inject
    public NormalizingSearcher(Linguistics linguistics) {
        this.linguistics = linguistics;
    }

    protected boolean handles(String command) {
        return "normalize".equals(command);
    }

    public String getFunctionName() {
        return "Normalizing accents";
    }

    @Override
    public Result search(Query query, Execution execution) {
        this.normalize(query, execution.context().getIndexFacts().newSession(query));
        return execution.search(query);
    }

    protected void normalize(Query query, IndexFacts.Session indexFacts) {
        String oldQuery = query.getTrace().getLevel() >= 2 ? query.getModel().getQueryTree().getRoot().toString() : null;
        this.normalizeBody(query, indexFacts);
        if (query.getTrace().getLevel() >= 2 && !query.getModel().getQueryTree().getRoot().toString().equals(oldQuery)) {
            query.trace(this.getFunctionName(), true, 2);
        }
    }

    private Query normalizeBody(Query query, IndexFacts.Session indexFacts) {
        Item root = query.getModel().getQueryTree().getRoot();
        Language language = query.getModel().getParsingLanguage();
        if (root instanceof BlockItem) {
            ArrayList<Item> rootItems = new ArrayList<Item>(1);
            rootItems.add(root);
            ListIterator<Item> i = rootItems.listIterator();
            i.next();
            this.normalizeBlocks(language, indexFacts, (BlockItem)((Object)root), i);
            if (!rootItems.isEmpty()) {
                query.getModel().getQueryTree().setRoot((Item)rootItems.get(0));
            }
        } else if (root instanceof CompositeItem) {
            query.getModel().getQueryTree().setRoot(this.normalizeComposite(language, indexFacts, (CompositeItem)root));
        }
        return query;
    }

    private Item normalizeComposite(Language language, IndexFacts.Session indexFacts, CompositeItem item) {
        if (item instanceof PhraseItem) {
            return this.normalizePhrase(language, indexFacts, (PhraseItem)item);
        }
        ListIterator<Item> i = item.getItemIterator();
        while (i.hasNext()) {
            Item current = i.next();
            if (current instanceof BlockItem) {
                this.normalizeBlocks(language, indexFacts, (BlockItem)((Object)current), i);
                continue;
            }
            if (!(current instanceof CompositeItem)) continue;
            Item currentProcessed = this.normalizeComposite(language, indexFacts, (CompositeItem)current);
            i.set(currentProcessed);
        }
        return item;
    }

    private void normalizeBlocks(Language language, IndexFacts.Session indexFacts, BlockItem block, ListIterator<Item> i) {
        if (block instanceof TermItem) {
            if (block instanceof WordAlternativesItem) {
                this.normalizeAlternatives(language, indexFacts, (WordAlternativesItem)block);
            } else {
                this.normalizeWord(language, indexFacts, (TermItem)block, i);
            }
        } else {
            ListIterator<Item> j = ((SegmentItem)block).getItemIterator();
            while (j.hasNext()) {
                this.normalizeWord(language, indexFacts, (TermItem)j.next(), j);
            }
        }
    }

    private void normalizeAlternatives(Language language, IndexFacts.Session indexFacts, WordAlternativesItem block) {
        if (!block.isNormalizable()) {
            return;
        }
        Index index = indexFacts.getIndex(block.getIndexName());
        if (index.isAttribute()) {
            return;
        }
        if (!index.getNormalize()) {
            return;
        }
        List<WordAlternativesItem.Alternative> terms = block.getAlternatives();
        for (WordAlternativesItem.Alternative term : terms) {
            String accentDropped = this.linguistics.getTransformer().accentDrop(term.word, language);
            if (term.word.equals(accentDropped) || accentDropped.length() <= 0) continue;
            block.addTerm(accentDropped, term.exactness * 0.7);
        }
    }

    private Item normalizePhrase(Language language, IndexFacts.Session indexFacts, PhraseItem phrase) {
        if (!indexFacts.getIndex(phrase.getIndexName()).getNormalize()) {
            return phrase;
        }
        ListIterator<Item> i = phrase.getItemIterator();
        while (i.hasNext()) {
            IndexedItem content = (IndexedItem)((Object)i.next());
            if (content instanceof TermItem) {
                this.normalizeWord(language, indexFacts, (TermItem)content, i);
                continue;
            }
            PhraseSegmentItem segment = (PhraseSegmentItem)content;
            ListIterator<Item> j = segment.getItemIterator();
            while (j.hasNext()) {
                this.normalizeWord(language, indexFacts, (TermItem)j.next(), j);
            }
        }
        return phrase;
    }

    private void normalizeWord(Language language, IndexFacts.Session indexFacts, TermItem term, ListIterator<Item> i) {
        if (!(term instanceof WordItem)) {
            return;
        }
        if (!term.isNormalizable()) {
            return;
        }
        Index index = indexFacts.getIndex(term.getIndexName());
        if (index.isAttribute()) {
            return;
        }
        if (!index.getNormalize()) {
            return;
        }
        WordItem word = (WordItem)term;
        String accentDropped = this.linguistics.getTransformer().accentDrop(word.getWord(), language);
        if (accentDropped.length() == 0) {
            i.remove();
        } else {
            word.setWord(accentDropped);
        }
    }
}

