/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.Location;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermItem;
import java.nio.ByteBuffer;
import java.util.Objects;

public class GeoLocationItem
extends TermItem {
    private Location location;

    public GeoLocationItem(Location location) {
        this(location, location.getAttribute());
        if (!location.hasAttribute()) {
            throw new IllegalArgumentException("Missing attribute on location: " + location);
        }
    }

    public GeoLocationItem(Location location, String fieldName) {
        super(fieldName, false);
        if (location.hasAttribute() && !location.getAttribute().equals(fieldName)) {
            throw new IllegalArgumentException("Inconsistent attribute on location: " + location.getAttribute() + " versus fieldName: " + fieldName);
        }
        if (!location.isGeoCircle()) {
            throw new IllegalArgumentException("GeoLocationItem only supports Geo Circles, got: " + location);
        }
        if (location.hasBoundingBox()) {
            throw new IllegalArgumentException("GeoLocationItem does not support bounding box, got: " + location);
        }
        this.location = new Location(location.toString());
        this.location.setAttribute(null);
        this.setNormalizable(false);
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getRawWord() {
        return this.stringValue();
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.GEO_LOCATION_TERM;
    }

    @Override
    public String getName() {
        return "GEO_LOCATION";
    }

    @Override
    public String stringValue() {
        return this.location.toString();
    }

    @Override
    public void setValue(String value) {
        throw new UnsupportedOperationException("Cannot setValue(" + value + ") on " + this.getName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.location);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        GeoLocationItem other = (GeoLocationItem)object;
        return this.location.equals(other.location);
    }

    @Override
    public GeoLocationItem clone() {
        GeoLocationItem clone = (GeoLocationItem)super.clone();
        clone.location = this.location.clone();
        return clone;
    }

    @Override
    public String getIndexedString() {
        return this.location.toString();
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        GeoLocationItem.putString(this.location.backendString(), buffer);
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public boolean isStemmed() {
        return true;
    }

    @Override
    public boolean isWords() {
        return false;
    }
}

