/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors;

import com.yahoo.fs4.MapEncoder;
import com.yahoo.search.Query;
import com.yahoo.search.dispatch.rpc.ProtobufSerialization;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class QueryEncoder {
    QueryEncoder() {
    }

    static int encodeAsProperties(Query query, ByteBuffer buffer, boolean encodeQueryData) {
        if (!QueryEncoder.hasEncodableProperties(query)) {
            return 0;
        }
        int start = buffer.position();
        int mapCountPosition = buffer.position();
        buffer.putInt(0);
        int mapCount = 0;
        mapCount += query.getRanking().getProperties().encode(buffer, encodeQueryData);
        if (encodeQueryData) {
            mapCount += query.getRanking().getFeatures().encode(buffer);
            if (query.getPresentation().getHighlight() != null) {
                mapCount += MapEncoder.encodeMultiMap("highlightterms", query.getPresentation().getHighlight().getHighlightTerms(), buffer);
            }
            mapCount += MapEncoder.encodeMap("model", QueryEncoder.createModelMap(query), buffer);
        }
        mapCount += MapEncoder.encodeSingleValue("match", "documentdb.searchdoctype", query.getModel().getDocumentDb(), buffer);
        buffer.putInt(mapCountPosition, mapCount += MapEncoder.encodeMap("caches", QueryEncoder.createCacheSettingMap(query), buffer));
        return buffer.position() - start;
    }

    static boolean hasEncodableProperties(Query query) {
        if (!query.getRanking().getProperties().isEmpty()) {
            return true;
        }
        if (!query.getRanking().getFeatures().isEmpty()) {
            return true;
        }
        if (query.getRanking().getFreshness() != null) {
            return true;
        }
        if (query.getModel().getSearchPath() != null) {
            return true;
        }
        if (query.getModel().getDocumentDb() != null) {
            return true;
        }
        return query.getPresentation().getHighlight() != null && !query.getPresentation().getHighlight().getHighlightItems().isEmpty();
    }

    private static Map<String, Boolean> createCacheSettingMap(Query query) {
        if (query.getGroupingSessionCache() && query.getRanking().getQueryCache()) {
            HashMap<String, Boolean> cacheSettingMap = new HashMap<String, Boolean>();
            cacheSettingMap.put("grouping", true);
            cacheSettingMap.put("query", true);
            return cacheSettingMap;
        }
        if (query.getGroupingSessionCache()) {
            return Collections.singletonMap("grouping", true);
        }
        if (query.getRanking().getQueryCache()) {
            return Collections.singletonMap("query", true);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> createModelMap(Query query) {
        int traceLevel;
        HashMap<String, String> m = new HashMap<String, String>();
        if (query.getModel().getSearchPath() != null) {
            m.put("searchpath", query.getModel().getSearchPath());
        }
        if ((traceLevel = ProtobufSerialization.getTraceLevelForBackend(query)) > 0) {
            m.put("tracelevel", String.valueOf(traceLevel));
        }
        return m;
    }
}

