/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Preconditions;
import com.yahoo.api.annotations.Beta;
import com.yahoo.collections.LazyMap;
import com.yahoo.collections.LazySet;
import com.yahoo.geo.DistanceParser;
import com.yahoo.geo.ParsedDegree;
import com.yahoo.language.Language;
import com.yahoo.language.detect.Detector;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.Segmenter;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.Location;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.BoolItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.DotProductItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.ExactStringItem;
import com.yahoo.prelude.query.FalseItem;
import com.yahoo.prelude.query.FuzzyItem;
import com.yahoo.prelude.query.GeoLocationItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.Limit;
import com.yahoo.prelude.query.NearItem;
import com.yahoo.prelude.query.NearestNeighborItem;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.ONearItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.PredicateQueryItem;
import com.yahoo.prelude.query.PrefixItem;
import com.yahoo.prelude.query.RangeItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.RegExpItem;
import com.yahoo.prelude.query.SameElementItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.SubstringItem;
import com.yahoo.prelude.query.SuffixItem;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.prelude.query.TrueItem;
import com.yahoo.prelude.query.UriItem;
import com.yahoo.prelude.query.WandItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.Query;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.query.parser.Parsable;
import com.yahoo.search.query.parser.Parser;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.query.parser.ParserFactory;
import com.yahoo.search.yql.ExpressionOperator;
import com.yahoo.search.yql.Operator;
import com.yahoo.search.yql.OperatorNode;
import com.yahoo.search.yql.ParameterListParser;
import com.yahoo.search.yql.ProgramParser;
import com.yahoo.search.yql.ProjectOperator;
import com.yahoo.search.yql.SequenceOperator;
import com.yahoo.search.yql.SortOperator;
import com.yahoo.search.yql.StatementOperator;
import com.yahoo.search.yql.VespaGroupingStep;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Supplier;

public class YqlParser
implements Parser {
    public static final String DESCENDING_HITS_ORDER = "descending";
    public static final String ASCENDING_HITS_ORDER = "ascending";
    private static final Integer DEFAULT_HITS = 10;
    private static final Integer DEFAULT_OFFSET = 0;
    public static final Integer DEFAULT_TARGET_NUM_HITS = 10;
    private static final String ACCENT_DROP_DESCRIPTION = "setting for whether to remove accents if field implies it";
    public static final String ANNOTATIONS = "annotations";
    private static final String FILTER_DESCRIPTION = "term filter setting";
    private static final String IMPLICIT_TRANSFORMS_DESCRIPTION = "setting for whether built-in query transformers should touch the term";
    public static final String NFKC = "nfkc";
    private static final String NORMALIZE_CASE_DESCRIPTION = "setting for whether to do case normalization if field implies it";
    private static final String ORIGIN_DESCRIPTION = "string origin for a term";
    private static final String RANKED_DESCRIPTION = "setting for whether to use term for ranking";
    private static final String STEM_DESCRIPTION = "setting for whether to use stem if field implies it";
    private static final String USE_POSITION_DATA_DESCRIPTION = "setting for whether to use position data for ranking this item";
    private static final String MAX_EDIT_DISTANCE_DESCRIPTION = "setting for an inclusive upper bound for a fuzzy edit-distance search";
    private static final String PREFIX_LENGTH_DESCRIPTION = "setting for a prefix length that is considered frozen for a fuzzy search";
    private static final String USER_INPUT_ALLOW_EMPTY = "allowEmpty";
    private static final String USER_INPUT_DEFAULT_INDEX = "defaultIndex";
    private static final String USER_INPUT_GRAMMAR = "grammar";
    public static final String USER_INPUT_LANGUAGE = "language";
    private static final String USER_INPUT_RAW = "raw";
    private static final String USER_INPUT_SEGMENT = "segment";
    private static final String USER_INPUT = "userInput";
    private static final String USER_QUERY = "userQuery";
    private static final String NON_EMPTY = "nonEmpty";
    public static final String START_ANCHOR = "startAnchor";
    public static final String END_ANCHOR = "endAnchor";
    public static final String SORTING_FUNCTION = "function";
    public static final String SORTING_LOCALE = "locale";
    public static final String SORTING_STRENGTH = "strength";
    public static final String ACCENT_DROP = "accentDrop";
    public static final String ALTERNATIVES = "alternatives";
    public static final String AND_SEGMENTING = "andSegmenting";
    public static final String APPROXIMATE = "approximate";
    public static final String BOUNDS = "bounds";
    public static final String BOUNDS_LEFT_OPEN = "leftOpen";
    public static final String BOUNDS_OPEN = "open";
    public static final String BOUNDS_RIGHT_OPEN = "rightOpen";
    public static final String CONNECTION_ID = "id";
    public static final String CONNECTION_WEIGHT = "weight";
    public static final String CONNECTIVITY = "connectivity";
    public static final String DISTANCE = "distance";
    public static final String DISTANCE_THRESHOLD = "distanceThreshold";
    public static final String DOT_PRODUCT = "dotProduct";
    public static final String EQUIV = "equiv";
    public static final String FILTER = "filter";
    public static final String GEO_LOCATION = "geoLocation";
    public static final String HIT_LIMIT = "hitLimit";
    public static final String HNSW_EXPLORE_ADDITIONAL_HITS = "hnsw.exploreAdditionalHits";
    public static final String IMPLICIT_TRANSFORMS = "implicitTransforms";
    public static final String LABEL = "label";
    public static final String NEAR = "near";
    public static final String NEAREST_NEIGHBOR = "nearestNeighbor";
    public static final String NORMALIZE_CASE = "normalizeCase";
    public static final String ONEAR = "onear";
    public static final String ORIGIN = "origin";
    public static final String ORIGIN_LENGTH = "length";
    public static final String ORIGIN_OFFSET = "offset";
    public static final String ORIGIN_ORIGINAL = "original";
    public static final String PHRASE = "phrase";
    public static final String PREDICATE = "predicate";
    public static final String PREFIX = "prefix";
    public static final String RANGE = "range";
    public static final String RANK = "rank";
    public static final String RANKED = "ranked";
    public static final String SAME_ELEMENT = "sameElement";
    public static final String SCORE_THRESHOLD = "scoreThreshold";
    public static final String SIGNIFICANCE = "significance";
    public static final String STEM = "stem";
    public static final String SUBSTRING = "substring";
    public static final String SUFFIX = "suffix";
    public static final String TARGET_HITS = "targetHits";
    public static final String TARGET_NUM_HITS = "targetNumHits";
    public static final String THRESHOLD_BOOST_FACTOR = "thresholdBoostFactor";
    public static final String UNIQUE_ID = "id";
    public static final String URI = "uri";
    public static final String USE_POSITION_DATA = "usePositionData";
    public static final String WAND = "wand";
    public static final String WEAK_AND = "weakAnd";
    public static final String WEIGHT = "weight";
    public static final String WEIGHTED_SET = "weightedSet";
    public static final String FUZZY = "fuzzy";
    public static final String MAX_EDIT_DISTANCE = "maxEditDistance";
    public static final String PREFIX_LENGTH = "prefixLength";
    private final IndexFacts indexFacts;
    private final List<ConnectedItem> connectedItems = new ArrayList<ConnectedItem>();
    private final List<VespaGroupingStep> groupingSteps = new ArrayList<VespaGroupingStep>();
    private final Map<Integer, TaggableItem> identifiedItems = LazyMap.newHashMap();
    private final Normalizer normalizer;
    private final Segmenter segmenter;
    private final Detector detector;
    private final Set<String> yqlSources = LazySet.newHashSet();
    private final Set<String> yqlSummaryFields = LazySet.newHashSet();
    private Integer hits;
    private Integer offset;
    private Integer timeout;
    private Query userQuery;
    private Parsable currentlyParsing;
    private IndexFacts.Session indexFactsSession;
    private IndexNameExpander indexNameExpander = new IndexNameExpander();
    private Set<String> docTypes;
    private Sorting sorting;
    private boolean queryParser = true;
    private final Deque<OperatorNode<?>> annotationStack = new ArrayDeque();
    private final ParserEnvironment environment;
    private static final ToolBox.QueryVisitor noEmptyTerms = new ToolBox.QueryVisitor(){

        @Override
        public boolean visit(Item item) {
            if (item instanceof NullItem) {
                throw new IllegalArgumentException("Got NullItem inside nonEmpty().");
            }
            if (item instanceof WordItem) {
                if (((WordItem)item).getIndexedString().isEmpty()) {
                    throw new IllegalArgumentException("Searching for empty string inside nonEmpty()");
                }
            } else if (item instanceof CompositeItem && ((CompositeItem)item).getItemCount() == 0) {
                throw new IllegalArgumentException("Empty composite operator (" + item.getName() + ") inside nonEmpty()");
            }
            return true;
        }

        @Override
        public void onExit() {
        }
    };

    public YqlParser(ParserEnvironment environment) {
        this.indexFacts = environment.getIndexFacts();
        this.normalizer = environment.getLinguistics().getNormalizer();
        this.segmenter = environment.getLinguistics().getSegmenter();
        this.detector = environment.getLinguistics().getDetector();
        this.environment = environment;
    }

    @Override
    public QueryTree parse(Parsable query) {
        this.indexFactsSession = this.indexFacts.newSession(query.getSources(), query.getRestrict());
        this.connectedItems.clear();
        this.groupingSteps.clear();
        this.identifiedItems.clear();
        this.yqlSources.clear();
        this.yqlSummaryFields.clear();
        this.annotationStack.clear();
        this.hits = null;
        this.offset = null;
        this.timeout = null;
        this.currentlyParsing = query;
        this.docTypes = null;
        this.sorting = null;
        return this.buildTree(this.parseYqlProgram());
    }

    private void joinDocTypesFromUserQueryAndYql() {
        ArrayList<String> allSourceNames = new ArrayList<String>(this.currentlyParsing.getSources().size() + this.yqlSources.size());
        if (!this.yqlSources.isEmpty()) {
            allSourceNames.addAll(this.currentlyParsing.getSources());
            allSourceNames.addAll(this.yqlSources);
        }
        this.indexFactsSession = this.indexFacts.newSession(allSourceNames, this.currentlyParsing.getRestrict());
        this.docTypes = new HashSet<String>(this.indexFactsSession.documentTypes());
    }

    private QueryTree buildTree(OperatorNode<?> filterPart) {
        Preconditions.checkArgument((filterPart.getArguments().length == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments to filter, got %s.", (int)filterPart.getArguments().length);
        this.populateYqlSources((OperatorNode)filterPart.getArgument(0));
        OperatorNode filterExpression = (OperatorNode)filterPart.getArgument(1);
        Item root = this.convertExpression(filterExpression);
        this.connectItems();
        this.userQuery = null;
        return new QueryTree(root);
    }

    private void populateYqlSources(OperatorNode<?> filterArgs) {
        this.yqlSources.clear();
        if (filterArgs.getOperator() == SequenceOperator.SCAN) {
            for (String source : (List)filterArgs.getArgument(0)) {
                this.yqlSources.add(source);
            }
        } else if (filterArgs.getOperator() != SequenceOperator.ALL) {
            if (filterArgs.getOperator() == SequenceOperator.MULTISOURCE) {
                for (List source : (List)filterArgs.getArgument(0)) {
                    this.yqlSources.add((String)source.get(0));
                }
            } else {
                throw YqlParser.newUnexpectedArgumentException(filterArgs.getOperator(), SequenceOperator.SCAN, SequenceOperator.ALL, SequenceOperator.MULTISOURCE);
            }
        }
        this.joinDocTypesFromUserQueryAndYql();
    }

    private void populateYqlSummaryFields(List<OperatorNode<ProjectOperator>> fields) {
        this.yqlSummaryFields.clear();
        for (OperatorNode<ProjectOperator> field : fields) {
            YqlParser.assertHasOperator(field, ProjectOperator.FIELD);
            this.yqlSummaryFields.add(field.getArgument(1, String.class));
        }
    }

    private void connectItems() {
        for (ConnectedItem entry : this.connectedItems) {
            TaggableItem to = this.identifiedItems.get(entry.toId);
            if (to == null) {
                throw new IllegalArgumentException("Item '" + entry.fromItem + "' was specified to connect to item with ID " + entry.toId + ", which does not exist in the query.");
            }
            entry.fromItem.setConnectivity((Item)((Object)to), entry.weight);
        }
    }

    private Item convertExpression(OperatorNode<ExpressionOperator> ast) {
        try {
            this.annotationStack.addFirst(ast);
            switch (ast.getOperator()) {
                case AND: {
                    CompositeItem compositeItem = this.buildAnd(ast);
                    return compositeItem;
                }
                case OR: {
                    CompositeItem compositeItem = this.buildOr(ast);
                    return compositeItem;
                }
                case EQ: {
                    TermItem termItem = this.buildEquals(ast);
                    return termItem;
                }
                case LT: {
                    IntItem intItem = this.buildLessThan(ast);
                    return intItem;
                }
                case GT: {
                    IntItem intItem = this.buildGreaterThan(ast);
                    return intItem;
                }
                case LTEQ: {
                    IntItem intItem = this.buildLessThanOrEquals(ast);
                    return intItem;
                }
                case GTEQ: {
                    IntItem intItem = this.buildGreaterThanOrEquals(ast);
                    return intItem;
                }
                case CONTAINS: {
                    Item item = this.buildTermSearch(ast);
                    return item;
                }
                case MATCHES: {
                    Item item = this.buildRegExpSearch(ast);
                    return item;
                }
                case CALL: {
                    Item item = this.buildFunctionCall(ast);
                    return item;
                }
                case LITERAL: {
                    Item item = this.buildLiteral(ast);
                    return item;
                }
                case NOT: {
                    CompositeItem compositeItem = this.buildNot(ast);
                    return compositeItem;
                }
            }
            throw YqlParser.newUnexpectedArgumentException(ast.getOperator(), ExpressionOperator.AND, ExpressionOperator.CALL, ExpressionOperator.CONTAINS, ExpressionOperator.EQ, ExpressionOperator.GT, ExpressionOperator.GTEQ, ExpressionOperator.LT, ExpressionOperator.LTEQ, ExpressionOperator.OR);
        }
        finally {
            this.annotationStack.removeFirst();
        }
    }

    private Item buildFunctionCall(OperatorNode<ExpressionOperator> ast) {
        List names = (List)((Object)ast.getArgument(0));
        Preconditions.checkArgument((names.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 name, got %s.", (int)names.size());
        switch ((String)names.get(0)) {
            case "userQuery": {
                return this.fetchUserQuery();
            }
            case "range": {
                return this.buildRange(ast);
            }
            case "wand": {
                return this.buildWand(ast);
            }
            case "weightedSet": {
                return this.buildWeightedSet(ast);
            }
            case "dotProduct": {
                return this.buildDotProduct(ast);
            }
            case "geoLocation": {
                return this.buildGeoLocation(ast);
            }
            case "nearestNeighbor": {
                return this.buildNearestNeighbor(ast);
            }
            case "predicate": {
                return this.buildPredicate(ast);
            }
            case "rank": {
                return this.buildRank(ast);
            }
            case "weakAnd": {
                return this.buildWeakAnd(ast);
            }
            case "userInput": {
                return this.buildUserInput(ast);
            }
            case "nonEmpty": {
                return this.ensureNonEmpty(ast);
            }
        }
        throw YqlParser.newUnexpectedArgumentException(names.get(0), DOT_PRODUCT, GEO_LOCATION, NEAREST_NEIGHBOR, RANGE, RANK, USER_QUERY, WAND, WEAK_AND, WEIGHTED_SET, PREDICATE, USER_INPUT, NON_EMPTY);
    }

    private Item ensureNonEmpty(OperatorNode<ExpressionOperator> ast) {
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 arguments, got %s.", (int)args.size());
        Item item = this.convertExpression((OperatorNode)args.get(0));
        ToolBox.visit(noEmptyTerms, item);
        return item;
    }

    private Item buildWeightedSet(OperatorNode<ExpressionOperator> ast) {
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments, got %s.", (int)args.size());
        return this.fillWeightedSet(ast, (OperatorNode)args.get(1), new WeightedSetItem(this.getIndex((OperatorNode)args.get(0))));
    }

    private Item buildDotProduct(OperatorNode<ExpressionOperator> ast) {
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments, got %s.", (int)args.size());
        return this.fillWeightedSet(ast, (OperatorNode)args.get(1), new DotProductItem(this.getIndex((OperatorNode)args.get(0))));
    }

    private Item buildGeoLocation(OperatorNode<ExpressionOperator> ast) {
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() == 4 ? 1 : 0) != 0, (String)"Expected 4 arguments, got %s.", (int)args.size());
        String field = YqlParser.fetchFieldRead((OperatorNode)args.get(0));
        ParsedDegree coord_1 = ParsedDegree.fromString((String)YqlParser.fetchFieldRead((OperatorNode)args.get(1)), (boolean)true, (boolean)false);
        ParsedDegree coord_2 = ParsedDegree.fromString((String)YqlParser.fetchFieldRead((OperatorNode)args.get(2)), (boolean)false, (boolean)true);
        double radius = DistanceParser.parse((String)YqlParser.fetchFieldRead((OperatorNode)args.get(3)));
        Location loc = new Location();
        if (coord_1.isLatitude && coord_2.isLongitude) {
            loc.setGeoCircle(coord_1.degrees, coord_2.degrees, radius);
        } else if (coord_2.isLatitude && coord_1.isLongitude) {
            loc.setGeoCircle(coord_2.degrees, coord_1.degrees, radius);
        } else {
            throw new IllegalArgumentException("Invalid geoLocation coordinates '" + coord_1 + "' and '" + coord_2 + "'");
        }
        GeoLocationItem item = new GeoLocationItem(loc, field);
        String label = this.getAnnotation(ast, LABEL, String.class, null, "item label");
        if (label != null) {
            item.setLabel(label);
        }
        return item;
    }

    private Item buildLiteral(OperatorNode<ExpressionOperator> ast) {
        ExpressionOperator literal = ast.getArgument(0);
        if (Boolean.TRUE.equals(literal)) {
            return new TrueItem();
        }
        if (Boolean.FALSE.equals(literal)) {
            return new FalseItem();
        }
        throw YqlParser.newUnexpectedArgumentException(literal, Boolean.FALSE, Boolean.TRUE);
    }

    private Item buildNearestNeighbor(OperatorNode<ExpressionOperator> ast) {
        Integer hnswExploreAdditionalHits;
        Double distanceThreshold;
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments, got %s.", (int)args.size());
        String field = YqlParser.fetchFieldRead((OperatorNode)args.get(0));
        String property = YqlParser.fetchFieldRead((OperatorNode)args.get(1));
        NearestNeighborItem item = new NearestNeighborItem(field, property);
        Integer targetNumHits = this.getAnnotation(ast, TARGET_HITS, Integer.class, null, "desired minimum hits to produce");
        if (targetNumHits == null) {
            targetNumHits = this.getAnnotation(ast, TARGET_NUM_HITS, Integer.class, null, "desired minimum hits to produce");
        }
        if (targetNumHits != null) {
            item.setTargetNumHits(targetNumHits);
        }
        if ((distanceThreshold = (Double)this.getAnnotation(ast, DISTANCE_THRESHOLD, Double.class, null, "maximum distance allowed from query point")) != null) {
            item.setDistanceThreshold(distanceThreshold);
        }
        if ((hnswExploreAdditionalHits = (Integer)this.getAnnotation(ast, HNSW_EXPLORE_ADDITIONAL_HITS, Integer.class, null, "number of extra hits to explore for HNSW algorithm")) != null) {
            item.setHnswExploreAdditionalHits(hnswExploreAdditionalHits);
        }
        Boolean allowApproximate = this.getAnnotation(ast, APPROXIMATE, Boolean.class, Boolean.TRUE, "allow approximate nearest neighbor search");
        item.setAllowApproximate(allowApproximate);
        String label = this.getAnnotation(ast, LABEL, String.class, null, "item label");
        if (label != null) {
            item.setLabel(label);
        }
        return item;
    }

    private Item buildPredicate(OperatorNode<ExpressionOperator> ast) {
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 arguments, got %s.", (int)args.size());
        PredicateQueryItem item = new PredicateQueryItem();
        item.setIndexName(this.getIndex((OperatorNode)args.get(0)));
        this.addFeatures((OperatorNode)args.get(1), (key, value, subqueryBitmap) -> item.addFeature(key, (String)value, subqueryBitmap), -1L);
        this.addFeatures((OperatorNode)args.get(2), (key, value, subqueryBitmap) -> {
            if (value instanceof Long) {
                item.addRangeFeature(key, (Long)value, subqueryBitmap);
            } else {
                item.addRangeFeature(key, ((Integer)value).intValue(), subqueryBitmap);
            }
        }, -1L);
        return this.leafStyleSettings(ast, item);
    }

    private void addFeatures(OperatorNode<ExpressionOperator> map, AddFeature item, long subqueryBitmap) {
        if (map.getOperator() != ExpressionOperator.MAP) {
            return;
        }
        YqlParser.assertHasOperator(map, ExpressionOperator.MAP);
        List keys = (List)((Object)map.getArgument(0));
        List values = (List)((Object)map.getArgument(1));
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            OperatorNode value = (OperatorNode)values.get(i);
            if (value.getOperator() == ExpressionOperator.ARRAY) {
                List multiValues = (List)value.getArgument(0);
                for (OperatorNode multiValue : multiValues) {
                    YqlParser.assertHasOperator(multiValue, ExpressionOperator.LITERAL);
                    item.addFeature(key, multiValue.getArgument(0), subqueryBitmap);
                }
                continue;
            }
            if (value.getOperator() == ExpressionOperator.LITERAL) {
                item.addFeature(key, value.getArgument(0), subqueryBitmap);
                continue;
            }
            YqlParser.assertHasOperator(value, ExpressionOperator.MAP);
            Preconditions.checkArgument((key.indexOf("0x") == 0 || key.indexOf("[") == 0 ? 1 : 0) != 0);
            if (key.indexOf("0x") == 0) {
                String subqueryString = key.substring(2);
                if (subqueryString.length() > 16) {
                    throw new NumberFormatException("Too long subquery string: " + key);
                }
                long currentSubqueryBitmap = new BigInteger(subqueryString, 16).longValue();
                this.addFeatures(value, item, currentSubqueryBitmap);
                continue;
            }
            StringTokenizer bits = new StringTokenizer(key.substring(1, key.length() - 1), ",");
            long currentSubqueryBitmap = 0L;
            while (bits.hasMoreTokens()) {
                int bit = Integer.parseInt(bits.nextToken().trim());
                currentSubqueryBitmap |= 1L << bit;
            }
            this.addFeatures(value, item, currentSubqueryBitmap);
        }
    }

    private Item buildWand(OperatorNode<ExpressionOperator> ast) {
        Double thresholdBoostFactor;
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments, got %s.", (int)args.size());
        Integer targetNumHits = this.getAnnotation(ast, TARGET_HITS, Integer.class, null, "desired number of hits to accumulate in wand");
        if (targetNumHits == null) {
            targetNumHits = this.getAnnotation(ast, TARGET_NUM_HITS, Integer.class, DEFAULT_TARGET_NUM_HITS, "desired number of hits to accumulate in wand");
        }
        WandItem out = new WandItem(this.getIndex((OperatorNode)args.get(0)), targetNumHits);
        Double scoreThreshold = this.getAnnotation(ast, SCORE_THRESHOLD, Double.class, null, "min score for hit inclusion");
        if (scoreThreshold != null) {
            out.setScoreThreshold(scoreThreshold);
        }
        if ((thresholdBoostFactor = (Double)this.getAnnotation(ast, THRESHOLD_BOOST_FACTOR, Double.class, null, "boost factor used to boost threshold before comparing against upper bound score")) != null) {
            out.setThresholdBoostFactor(thresholdBoostFactor);
        }
        return this.fillWeightedSet(ast, (OperatorNode)args.get(1), out);
    }

    private WeightedSetItem fillWeightedSet(OperatorNode<ExpressionOperator> ast, OperatorNode<ExpressionOperator> arg, WeightedSetItem out) {
        this.addItems(arg, out);
        return this.leafStyleSettings(ast, out);
    }

    private Item instantiateSameElementItem(String field, OperatorNode<ExpressionOperator> ast) {
        YqlParser.assertHasFunctionName(ast, SAME_ELEMENT);
        SameElementItem sameElement = new SameElementItem(field);
        IndexNameExpander prev = this.swapIndexCreator(new PrefixExpander(field));
        for (OperatorNode term : (List)((Object)ast.getArgument(1))) {
            sameElement.addItem(this.convertExpression(term));
        }
        this.swapIndexCreator(prev);
        return sameElement;
    }

    private Item instantiatePhraseItem(String field, OperatorNode<ExpressionOperator> ast) {
        YqlParser.assertHasFunctionName(ast, PHRASE);
        if (this.getAnnotation(ast, ORIGIN, Map.class, null, ORIGIN_DESCRIPTION, false) != null) {
            return this.instantiatePhraseSegmentItem(field, ast, false);
        }
        PhraseItem phrase = new PhraseItem();
        phrase.setIndexName(field);
        phrase.setExplicit(true);
        for (OperatorNode word : (List)((Object)ast.getArgument(1))) {
            if (word.getOperator() == ExpressionOperator.CALL) {
                List names = (List)word.getArgument(0);
                switch ((String)names.get(0)) {
                    case "phrase": {
                        if (this.getAnnotation(word, ORIGIN, Map.class, null, ORIGIN_DESCRIPTION, false) == null) {
                            phrase.addItem(this.instantiatePhraseItem(field, word));
                            break;
                        }
                        phrase.addItem(this.instantiatePhraseSegmentItem(field, word, true));
                        break;
                    }
                    case "alternatives": {
                        phrase.addItem(this.instantiateWordAlternativesItem(field, word));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Expected phrase or word alternatives, got " + (String)names.get(0));
                    }
                }
                continue;
            }
            phrase.addItem(this.instantiateWordItem(field, word, phrase.getClass()));
        }
        return this.leafStyleSettings(ast, phrase);
    }

    private Item instantiatePhraseSegmentItem(String field, OperatorNode<ExpressionOperator> ast, boolean forcePhrase) {
        Substring origin = this.getOrigin(ast);
        Boolean stem = this.getAnnotation(ast, STEM, Boolean.class, Boolean.TRUE, STEM_DESCRIPTION);
        Boolean andSegmenting = this.getAnnotation(ast, AND_SEGMENTING, Boolean.class, Boolean.FALSE, "setting for whether to force using AND for segments on and off");
        List words = null;
        SegmentItem phrase = forcePhrase || andSegmenting == false ? new PhraseSegmentItem(origin.getValue(), origin.getValue(), true, stem == false, origin) : new AndSegmentItem(origin.getValue(), true, stem == false);
        phrase.setIndexName(field);
        if (this.getAnnotation(ast, IMPLICIT_TRANSFORMS, Boolean.class, Boolean.TRUE, IMPLICIT_TRANSFORMS_DESCRIPTION).booleanValue()) {
            words = this.segmenter.segment(origin.getValue(), this.currentlyParsing.getLanguage());
        }
        if (words != null && words.size() > 0) {
            for (String word : words) {
                phrase.addItem(new WordItem(word, field, true));
            }
        } else {
            for (OperatorNode word : (List)((Object)ast.getArgument(1))) {
                phrase.addItem(this.instantiateWordItem(field, word, phrase.getClass(), SegmentWhen.NEVER));
            }
        }
        if (phrase instanceof TaggableItem) {
            this.leafStyleSettings(ast, (TaggableItem)((Object)phrase));
        }
        phrase.lock();
        return phrase;
    }

    private Item instantiateNearItem(String field, OperatorNode<ExpressionOperator> ast) {
        YqlParser.assertHasFunctionName(ast, NEAR);
        NearItem near = new NearItem();
        near.setIndexName(field);
        for (OperatorNode word : (List)((Object)ast.getArgument(1))) {
            near.addItem(this.instantiateWordItem(field, word, near.getClass()));
        }
        Integer distance = this.getAnnotation(ast, DISTANCE, Integer.class, null, "term distance for NEAR operator");
        if (distance != null) {
            near.setDistance(distance);
        }
        return near;
    }

    private Item instantiateONearItem(String field, OperatorNode<ExpressionOperator> ast) {
        YqlParser.assertHasFunctionName(ast, ONEAR);
        ONearItem onear = new ONearItem();
        onear.setIndexName(field);
        for (OperatorNode word : (List)((Object)ast.getArgument(1))) {
            onear.addItem(this.instantiateWordItem(field, word, onear.getClass()));
        }
        Integer distance = this.getAnnotation(ast, DISTANCE, Integer.class, null, "term distance for ONEAR operator");
        if (distance != null) {
            onear.setDistance(distance);
        }
        return onear;
    }

    private Item fetchUserQuery() {
        Preconditions.checkState((!this.queryParser ? 1 : 0) != 0, (Object)"Tried inserting user query into itself.");
        Preconditions.checkState((this.userQuery != null ? 1 : 0) != 0, (Object)"User query must be set before trying to build complete query tree including user query.");
        return this.userQuery.getModel().getQueryTree().getRoot();
    }

    private Item buildUserInput(OperatorNode<ExpressionOperator> ast) {
        Item item;
        List args = (List)((Object)ast.getArgument(1));
        String wordData = this.getStringContents((OperatorNode)args.get(0));
        Boolean allowEmpty = this.getAnnotation(ast, USER_INPUT_ALLOW_EMPTY, Boolean.class, Boolean.FALSE, "flag for allowing NullItem to be returned");
        if (allowEmpty.booleanValue() && (wordData == null || wordData.isEmpty())) {
            return new NullItem();
        }
        String grammar = this.getAnnotation(ast, USER_INPUT_GRAMMAR, String.class, Query.Type.ALL.toString(), "grammar for handling user input");
        String defaultIndex = this.getAnnotation(ast, USER_INPUT_DEFAULT_INDEX, String.class, "default", "default index for user input terms");
        Language language = this.decideParsingLanguage(ast, wordData);
        if (USER_INPUT_RAW.equals(grammar)) {
            item = this.instantiateWordItem(defaultIndex, wordData, ast, null, SegmentWhen.NEVER, true, language);
        } else if (USER_INPUT_SEGMENT.equals(grammar)) {
            item = this.instantiateWordItem(defaultIndex, wordData, ast, null, SegmentWhen.ALWAYS, false, language);
        } else {
            item = this.parseUserInput(grammar, defaultIndex, wordData, language, allowEmpty);
            this.propagateUserInputAnnotations(ast, item);
        }
        return item;
    }

    private Language decideParsingLanguage(OperatorNode<ExpressionOperator> ast, String wordData) {
        String languageTag = this.getAnnotation(ast, USER_INPUT_LANGUAGE, String.class, null, "language setting for segmenting query section");
        Language language = Language.fromLanguageTag((String)languageTag);
        if (language != Language.UNKNOWN) {
            return language;
        }
        Optional<Language> explicitLanguage = this.currentlyParsing.getExplicitLanguage();
        if (explicitLanguage.isPresent()) {
            return explicitLanguage.get();
        }
        language = this.detector.detect(wordData, null).getLanguage();
        if (language != Language.UNKNOWN) {
            return language;
        }
        return Language.ENGLISH;
    }

    private String getStringContents(OperatorNode<ExpressionOperator> operator) {
        switch (operator.getOperator()) {
            case LITERAL: {
                return operator.getArgument(0, String.class);
            }
            case VARREF: {
                Preconditions.checkState((this.userQuery != null ? 1 : 0) != 0, (Object)"properties must be available when trying to fetch user input");
                return this.userQuery.properties().getString(operator.getArgument(0, String.class));
            }
        }
        throw YqlParser.newUnexpectedArgumentException(operator.getOperator(), ExpressionOperator.LITERAL, ExpressionOperator.VARREF);
    }

    private void propagateUserInputAnnotations(OperatorNode<ExpressionOperator> ast, Item item) {
        ToolBox.visit(new AnnotationPropagator(ast), item);
    }

    private Item parseUserInput(String grammar, String defaultIndex, String wordData, Language language, boolean allowNullItem) {
        Query.Type parseAs = Query.Type.getType(grammar);
        Parser parser = ParserFactory.newInstance(parseAs, this.environment);
        Item item = parser.parse(new Parsable().setQuery(wordData).addSources(this.docTypes).setLanguage(language).setDefaultIndexName(defaultIndex)).getRoot();
        if (!allowNullItem && (item == null || item instanceof NullItem)) {
            throw new IllegalArgumentException("Parsing '" + wordData + "' only resulted in NullItem.");
        }
        if (language != Language.ENGLISH) {
            item.setLanguage(language);
        }
        return item;
    }

    private OperatorNode<?> parseYqlProgram() {
        OperatorNode<?> ast;
        try {
            ast = new ProgramParser().parse("query", this.currentlyParsing.getQuery());
        }
        catch (Exception e) {
            throw new IllegalInputException((Throwable)e);
        }
        YqlParser.assertHasOperator(ast, StatementOperator.PROGRAM);
        Preconditions.checkArgument((ast.getArguments().length == 1 ? 1 : 0) != 0, (String)"Expected only a single argument to the root node, got %s.", (int)ast.getArguments().length);
        ast = (OperatorNode<?>)((List)((Object)ast.getArgument(0))).get(0);
        YqlParser.assertHasOperator(ast, StatementOperator.EXECUTE);
        ast = (OperatorNode)ast.getArgument(0);
        ast = this.fetchPipe(ast);
        ast = this.fetchTimeout(ast);
        ast = this.fetchSummaryFields(ast);
        ast = this.fetchOffsetAndHits(ast);
        ast = this.fetchSorting(ast);
        YqlParser.assertHasOperator(ast, SequenceOperator.FILTER);
        return ast;
    }

    private OperatorNode<?> fetchPipe(OperatorNode<?> toScan) {
        OperatorNode ast = toScan;
        while (ast.getOperator() == SequenceOperator.PIPE) {
            OperatorNode groupingAst = (OperatorNode)((List)ast.getArgument(2)).get(0);
            GroupingOperation groupingOperation = GroupingOperation.fromString((String)groupingAst.getArgument(0));
            VespaGroupingStep groupingStep = new VespaGroupingStep(groupingOperation);
            List continuations = this.getAnnotation(groupingAst, "continuations", List.class, Collections.emptyList(), "grouping continuations");
            for (Object continuation : continuations) {
                groupingStep.continuations().add(Continuation.fromString(this.dereference(continuation)));
            }
            this.groupingSteps.add(groupingStep);
            ast = (OperatorNode)ast.getArgument(0);
        }
        Collections.reverse(this.groupingSteps);
        return ast;
    }

    private String dereference(Object constantOrVarref) {
        if (constantOrVarref instanceof OperatorNode) {
            OperatorNode varref = (OperatorNode)constantOrVarref;
            Preconditions.checkState((this.userQuery != null ? 1 : 0) != 0, (Object)"properties must be available when trying to fetch user input");
            return this.userQuery.properties().getString(varref.getArgument(0, String.class));
        }
        return constantOrVarref.toString();
    }

    private OperatorNode<?> fetchSorting(OperatorNode<?> ast) {
        if (ast.getOperator() != SequenceOperator.SORT) {
            return ast;
        }
        ArrayList<Sorting.FieldOrder> sortingInit = new ArrayList<Sorting.FieldOrder>();
        List sortArguments = (List)ast.getArgument(1);
        block4: for (OperatorNode op : sortArguments) {
            Sorting.AttributeSorter sorter;
            OperatorNode fieldNode = (OperatorNode)op.getArgument(0);
            String field = YqlParser.fetchFieldRead(fieldNode);
            String locale = this.getAnnotation(fieldNode, SORTING_LOCALE, String.class, null, "locale used by sorting function");
            String function = this.getAnnotation(fieldNode, SORTING_FUNCTION, String.class, null, "sorting function for the specified attribute");
            String strength = this.getAnnotation(fieldNode, SORTING_STRENGTH, String.class, null, "strength for sorting function");
            if (function == null) {
                sorter = new Sorting.AttributeSorter(field);
            } else if ("lowercase".equals(function)) {
                sorter = new Sorting.LowerCaseSorter(field);
            } else if (USER_INPUT_RAW.equals(function)) {
                sorter = new Sorting.RawSorter(field);
            } else if ("uca".equals(function)) {
                if (locale != null) {
                    Sorting.UcaSorter.Strength ucaStrength = Sorting.UcaSorter.Strength.UNDEFINED;
                    if (strength != null) {
                        if ("primary".equalsIgnoreCase(strength)) {
                            ucaStrength = Sorting.UcaSorter.Strength.PRIMARY;
                        } else if ("secondary".equalsIgnoreCase(strength)) {
                            ucaStrength = Sorting.UcaSorter.Strength.SECONDARY;
                        } else if ("tertiary".equalsIgnoreCase(strength)) {
                            ucaStrength = Sorting.UcaSorter.Strength.TERTIARY;
                        } else if ("quaternary".equalsIgnoreCase(strength)) {
                            ucaStrength = Sorting.UcaSorter.Strength.QUATERNARY;
                        } else if ("identical".equalsIgnoreCase(strength)) {
                            ucaStrength = Sorting.UcaSorter.Strength.IDENTICAL;
                        } else {
                            throw YqlParser.newUnexpectedArgumentException(function, "primary", "secondary", "tertiary", "quaternary", "identical");
                        }
                        sorter = new Sorting.UcaSorter(field, locale, ucaStrength);
                    } else {
                        sorter = new Sorting.UcaSorter(field, locale, ucaStrength);
                    }
                } else {
                    sorter = new Sorting.UcaSorter(field);
                }
            } else {
                throw YqlParser.newUnexpectedArgumentException(function, "lowercase", USER_INPUT_RAW, "uca");
            }
            switch ((SortOperator)op.getOperator()) {
                case ASC: {
                    sortingInit.add(new Sorting.FieldOrder(sorter, Sorting.Order.ASCENDING));
                    continue block4;
                }
                case DESC: {
                    sortingInit.add(new Sorting.FieldOrder(sorter, Sorting.Order.DESCENDING));
                    continue block4;
                }
            }
            throw YqlParser.newUnexpectedArgumentException(op.getOperator(), SortOperator.ASC, SortOperator.DESC);
        }
        this.sorting = new Sorting(sortingInit);
        return (OperatorNode)ast.getArgument(0);
    }

    private OperatorNode<?> fetchOffsetAndHits(OperatorNode<?> ast) {
        if (ast.getOperator() == SequenceOperator.OFFSET) {
            this.offset = (Integer)((OperatorNode)ast.getArgument(1)).getArgument(0);
            this.hits = DEFAULT_HITS;
            return (OperatorNode)ast.getArgument(0);
        }
        if (ast.getOperator() == SequenceOperator.SLICE) {
            this.offset = (Integer)((OperatorNode)ast.getArgument(1)).getArgument(0);
            this.hits = (Integer)((OperatorNode)ast.getArgument(2)).getArgument(0) - this.offset;
            return (OperatorNode)ast.getArgument(0);
        }
        if (ast.getOperator() == SequenceOperator.LIMIT) {
            this.hits = (Integer)((OperatorNode)ast.getArgument(1)).getArgument(0);
            this.offset = DEFAULT_OFFSET;
            return (OperatorNode)ast.getArgument(0);
        }
        return ast;
    }

    private OperatorNode<?> fetchSummaryFields(OperatorNode<?> ast) {
        if (ast.getOperator() != SequenceOperator.PROJECT) {
            return ast;
        }
        Preconditions.checkArgument((ast.getArguments().length == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments to PROJECT, got %s.", (int)ast.getArguments().length);
        this.populateYqlSummaryFields((List)ast.getArgument(1));
        return (OperatorNode)ast.getArgument(0);
    }

    private OperatorNode<?> fetchTimeout(OperatorNode<?> ast) {
        if (ast.getOperator() != SequenceOperator.TIMEOUT) {
            return ast;
        }
        this.timeout = (Integer)((OperatorNode)ast.getArgument(1)).getArgument(0);
        return (OperatorNode)ast.getArgument(0);
    }

    private static String fetchFieldRead(OperatorNode<ExpressionOperator> ast) {
        switch (ast.getOperator()) {
            case LITERAL: {
                return ast.getArgument(0).toString();
            }
            case READ_FIELD: {
                return (String)((Object)ast.getArgument(1));
            }
            case PROPREF: {
                return YqlParser.fetchFieldRead((OperatorNode)((Object)ast.getArgument(0))) + "." + ast.getArgument(1);
            }
        }
        throw YqlParser.newUnexpectedArgumentException(ast.getOperator(), ExpressionOperator.READ_FIELD, ExpressionOperator.PROPREF);
    }

    private IntItem buildGreaterThanOrEquals(OperatorNode<ExpressionOperator> ast) {
        if (YqlParser.isIndexOnLeftHandSide(ast)) {
            IntItem number = new IntItem("[" + this.fetchConditionWord(ast) + ";]", this.fetchConditionIndex(ast));
            return this.leafStyleSettings(ast.getArgument(1, OperatorNode.class), number);
        }
        IntItem number = new IntItem("[;" + this.fetchConditionWord(ast) + "]", this.fetchConditionIndex(ast));
        return this.leafStyleSettings(ast.getArgument(0, OperatorNode.class), number);
    }

    private IntItem buildLessThanOrEquals(OperatorNode<ExpressionOperator> ast) {
        if (YqlParser.isIndexOnLeftHandSide(ast)) {
            IntItem number = new IntItem("[;" + this.fetchConditionWord(ast) + "]", this.fetchConditionIndex(ast));
            return this.leafStyleSettings(ast.getArgument(1, OperatorNode.class), number);
        }
        IntItem number = new IntItem("[" + this.fetchConditionWord(ast) + ";]", this.fetchConditionIndex(ast));
        return this.leafStyleSettings(ast.getArgument(0, OperatorNode.class), number);
    }

    private IntItem buildGreaterThan(OperatorNode<ExpressionOperator> ast) {
        if (YqlParser.isIndexOnLeftHandSide(ast)) {
            IntItem number = new IntItem(">" + this.fetchConditionWord(ast), this.fetchConditionIndex(ast));
            return this.leafStyleSettings(ast.getArgument(1, OperatorNode.class), number);
        }
        IntItem number = new IntItem("<" + this.fetchConditionWord(ast), this.fetchConditionIndex(ast));
        return this.leafStyleSettings(ast.getArgument(0, OperatorNode.class), number);
    }

    private IntItem buildLessThan(OperatorNode<ExpressionOperator> ast) {
        if (YqlParser.isIndexOnLeftHandSide(ast)) {
            IntItem number = new IntItem("<" + this.fetchConditionWord(ast), this.fetchConditionIndex(ast));
            return this.leafStyleSettings(ast.getArgument(1, OperatorNode.class), number);
        }
        IntItem number = new IntItem(">" + this.fetchConditionWord(ast), this.fetchConditionIndex(ast));
        return this.leafStyleSettings(ast.getArgument(0, OperatorNode.class), number);
    }

    private TermItem buildEquals(OperatorNode<ExpressionOperator> ast) {
        String value = this.fetchConditionWord(ast);
        TermItem item = value.equals("true") ? new BoolItem(true, this.fetchConditionIndex(ast)) : (value.equals("false") ? new BoolItem(false, this.fetchConditionIndex(ast)) : new IntItem(value, this.fetchConditionIndex(ast)));
        if (YqlParser.isIndexOnLeftHandSide(ast)) {
            return this.leafStyleSettings(ast.getArgument(1, OperatorNode.class), item);
        }
        return this.leafStyleSettings(ast.getArgument(0, OperatorNode.class), item);
    }

    private String fetchConditionIndex(OperatorNode<ExpressionOperator> ast) {
        OperatorNode lhs = (OperatorNode)((Object)ast.getArgument(0));
        OperatorNode rhs = (OperatorNode)((Object)ast.getArgument(1));
        if (this.isNumber(lhs)) {
            return this.getIndex(rhs);
        }
        if (this.isNumber(rhs)) {
            return this.getIndex(lhs);
        }
        throw new IllegalArgumentException("Expected LITERAL/VARREF and READ_FIELD/PROPREF, got " + lhs.getOperator() + " and " + rhs.getOperator() + ".");
    }

    private boolean isNumber(OperatorNode<ExpressionOperator> ast) {
        return ast.getOperator() == ExpressionOperator.NEGATE || ast.getOperator() == ExpressionOperator.LITERAL || ast.getOperator() == ExpressionOperator.VARREF;
    }

    private String getNumberAsString(OperatorNode<ExpressionOperator> ast) {
        String negative = "";
        if (ast.getOperator() == ExpressionOperator.NEGATE) {
            negative = "-";
            ast = (OperatorNode)((Object)ast.getArgument(0));
        }
        switch (ast.getOperator()) {
            case VARREF: {
                Preconditions.checkState((this.userQuery != null ? 1 : 0) != 0, (Object)"properties must be available when trying to fetch user input");
                return negative + this.userQuery.properties().getString(ast.getArgument(0, String.class));
            }
            case LITERAL: {
                return negative + ast.getArgument(0).toString();
            }
        }
        throw new IllegalArgumentException("Expected VARREF or LITERAL, got " + ast.getOperator());
    }

    private String fetchConditionWord(OperatorNode<ExpressionOperator> ast) {
        OperatorNode lhs = (OperatorNode)((Object)ast.getArgument(0));
        OperatorNode rhs = (OperatorNode)((Object)ast.getArgument(1));
        if (this.isNumber(lhs)) {
            YqlParser.assertFieldName(rhs);
            return this.getNumberAsString(lhs);
        }
        if (this.isNumber(rhs)) {
            YqlParser.assertFieldName(lhs);
            return this.getNumberAsString(rhs);
        }
        throw new IllegalArgumentException("Expected LITERAL/NEGATE and READ_FIELD/PROPREF, got " + lhs.getOperator() + " and " + rhs.getOperator() + ".");
    }

    private static boolean isIndexOnLeftHandSide(OperatorNode<ExpressionOperator> ast) {
        OperatorNode node = ast.getArgument(0, OperatorNode.class);
        return node.getOperator() == ExpressionOperator.READ_FIELD || node.getOperator() == ExpressionOperator.PROPREF;
    }

    private CompositeItem buildAnd(OperatorNode<ExpressionOperator> ast) {
        AndItem andItem = new AndItem();
        NotItem notItem = new NotItem();
        this.convertVarArgsAnd(ast, 0, andItem, notItem);
        if (notItem.getItemCount() == 0) {
            return andItem;
        }
        if (andItem.getItemCount() == 1) {
            notItem.setPositiveItem(andItem.getItem(0));
        } else if (andItem.getItemCount() > 1) {
            notItem.setPositiveItem(andItem);
        }
        return notItem;
    }

    private CompositeItem buildNot(OperatorNode<ExpressionOperator> ast) {
        NotItem notItem = new NotItem();
        notItem.addNegativeItem(this.convertExpression((OperatorNode)((Object)ast.getArgument(0))));
        return notItem;
    }

    private CompositeItem buildOr(OperatorNode<ExpressionOperator> spec) {
        return this.convertVarArgs(spec, 0, new OrItem());
    }

    private CompositeItem buildWeakAnd(OperatorNode<ExpressionOperator> spec) {
        Integer scoreThreshold;
        WeakAndItem weakAnd = new WeakAndItem();
        Integer targetNumHits = this.getAnnotation(spec, TARGET_HITS, Integer.class, null, "desired minimum hits to produce");
        if (targetNumHits == null) {
            targetNumHits = this.getAnnotation(spec, TARGET_NUM_HITS, Integer.class, null, "desired minimum hits to produce");
        }
        if (targetNumHits != null) {
            weakAnd.setN(targetNumHits);
        }
        if ((scoreThreshold = (Integer)this.getAnnotation(spec, SCORE_THRESHOLD, Integer.class, null, "min dot product score for hit inclusion")) != null) {
            weakAnd.setScoreThreshold(scoreThreshold);
        }
        return this.convertVarArgs(spec, 1, weakAnd);
    }

    private CompositeItem buildRank(OperatorNode<ExpressionOperator> spec) {
        return this.convertVarArgs(spec, 1, new RankItem());
    }

    private CompositeItem convertVarArgs(OperatorNode<ExpressionOperator> ast, int argIdx, CompositeItem out) {
        Iterable args = (Iterable)((Object)ast.getArgument(argIdx));
        for (OperatorNode arg : args) {
            YqlParser.assertHasOperator(arg, ExpressionOperator.class);
            out.addItem(this.convertExpression(arg));
        }
        return out;
    }

    private void convertVarArgsAnd(OperatorNode<ExpressionOperator> ast, int argIdx, AndItem outAnd, NotItem outNot) {
        Iterable args = (Iterable)((Object)ast.getArgument(argIdx));
        for (OperatorNode arg : args) {
            YqlParser.assertHasOperator(arg, ExpressionOperator.class);
            if (arg.getOperator() == ExpressionOperator.NOT) {
                OperatorNode exp = (OperatorNode)arg.getArgument(0);
                YqlParser.assertHasOperator(exp, ExpressionOperator.class);
                outNot.addNegativeItem(this.convertExpression(exp));
                continue;
            }
            outAnd.addItem(this.convertExpression(arg));
        }
    }

    private Item buildTermSearch(OperatorNode<ExpressionOperator> ast) {
        YqlParser.assertHasOperator(ast, ExpressionOperator.CONTAINS);
        String field = this.getIndex((OperatorNode)((Object)ast.getArgument(0)));
        if (this.userQuery != null && this.indexFactsSession.getIndex(field).isAttribute()) {
            this.userQuery.trace("Field '" + field + "' is an attribute, 'contains' will only match exactly (unless fuzzy is used)", 2);
        }
        return this.instantiateLeafItem(field, (OperatorNode)((Object)ast.getArgument(1)));
    }

    private Item buildRegExpSearch(OperatorNode<ExpressionOperator> ast) {
        YqlParser.assertHasOperator(ast, ExpressionOperator.MATCHES);
        String field = this.getIndex((OperatorNode)((Object)ast.getArgument(0)));
        if (this.userQuery != null && !this.indexFactsSession.getIndex(field).isAttribute()) {
            this.userQuery.trace("Field '" + field + "' is indexed, non-literal regular expressions will not be matched", 1);
        }
        OperatorNode ast1 = (OperatorNode)((Object)ast.getArgument(1));
        String wordData = this.getStringContents(ast1);
        RegExpItem regExp = new RegExpItem(field, true, wordData);
        return this.leafStyleSettings(ast1, regExp);
    }

    private Item buildRange(OperatorNode<ExpressionOperator> spec) {
        YqlParser.assertHasOperator(spec, ExpressionOperator.CALL);
        YqlParser.assertHasFunctionName(spec, RANGE);
        IntItem range = this.instantiateRangeItem((List)((Object)spec.getArgument(1)), spec);
        return this.leafStyleSettings(spec, range);
    }

    private static Number negate(Number x) {
        if (x.getClass() == Integer.class) {
            int x1 = x.intValue();
            return -x1;
        }
        if (x.getClass() == Long.class) {
            long x1 = x.longValue();
            return -x1;
        }
        if (x.getClass() == Float.class) {
            float x1 = x.floatValue();
            return Float.valueOf(-x1);
        }
        if (x.getClass() == Double.class) {
            double x1 = x.doubleValue();
            return -x1;
        }
        throw YqlParser.newUnexpectedArgumentException(x.getClass(), Integer.class, Long.class, Float.class, Double.class);
    }

    private IntItem instantiateRangeItem(List<OperatorNode<ExpressionOperator>> args, OperatorNode<ExpressionOperator> spec) {
        Limit to;
        Limit from;
        Preconditions.checkArgument((args.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 arguments, got %s.", (int)args.size());
        Number lowerArg = this.getRangeBound(args.get(1));
        Number upperArg = this.getRangeBound(args.get(2));
        String bounds = this.getAnnotation(spec, BOUNDS, String.class, null, "whether bounds should be open or closed");
        if (bounds == null) {
            return new RangeItem(lowerArg, upperArg, this.getIndex(args.get(0)));
        }
        if (BOUNDS_OPEN.equals(bounds)) {
            from = new Limit(lowerArg, false);
            to = new Limit(upperArg, false);
        } else if (BOUNDS_LEFT_OPEN.equals(bounds)) {
            from = new Limit(lowerArg, false);
            to = new Limit(upperArg, true);
        } else if (BOUNDS_RIGHT_OPEN.equals(bounds)) {
            from = new Limit(lowerArg, true);
            to = new Limit(upperArg, false);
        } else {
            throw YqlParser.newUnexpectedArgumentException(bounds, BOUNDS_OPEN, BOUNDS_LEFT_OPEN, BOUNDS_RIGHT_OPEN);
        }
        return new IntItem(from, to, this.getIndex(args.get(0)));
    }

    private Number getRangeBound(OperatorNode<ExpressionOperator> bound) {
        if (bound.getOperator() == ExpressionOperator.NEGATE) {
            return YqlParser.negate(this.getPositiveRangeBound((OperatorNode)((Object)bound.getArgument(0))));
        }
        return this.getPositiveRangeBound(bound);
    }

    private Number getPositiveRangeBound(OperatorNode<ExpressionOperator> bound) {
        if (bound.getOperator() == ExpressionOperator.READ_FIELD) {
            if (bound.getArgument(1).toString().equals("Infinity")) {
                return Double.POSITIVE_INFINITY;
            }
            throw new IllegalArgumentException("Expected a numerical argument (or 'Infinity') to range but got '" + bound.getArgument(1) + "'");
        }
        YqlParser.assertHasOperator(bound, ExpressionOperator.LITERAL, () -> "Expected a numerical argument to range but got '" + bound.getArgument(0) + "'");
        return bound.getArgument(0, Number.class);
    }

    private Item instantiateLeafItem(String field, OperatorNode<ExpressionOperator> ast) {
        switch (ast.getOperator()) {
            case LITERAL: 
            case VARREF: {
                return this.instantiateWordItem(field, ast, null);
            }
            case CALL: {
                return this.instantiateCompositeLeaf(field, ast);
            }
        }
        throw YqlParser.newUnexpectedArgumentException(ast.getOperator().name(), ExpressionOperator.CALL, ExpressionOperator.LITERAL);
    }

    private Item instantiateCompositeLeaf(String field, OperatorNode<ExpressionOperator> ast) {
        List names = (List)((Object)ast.getArgument(0));
        Preconditions.checkArgument((names.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 name, got %s.", (int)names.size());
        switch ((String)names.get(0)) {
            case "sameElement": {
                return this.instantiateSameElementItem(field, ast);
            }
            case "phrase": {
                return this.instantiatePhraseItem(field, ast);
            }
            case "near": {
                return this.instantiateNearItem(field, ast);
            }
            case "onear": {
                return this.instantiateONearItem(field, ast);
            }
            case "equiv": {
                return this.instantiateEquivItem(field, ast);
            }
            case "alternatives": {
                return this.instantiateWordAlternativesItem(field, ast);
            }
            case "uri": {
                return this.instantiateUriItem(field, ast);
            }
            case "fuzzy": {
                return this.instantiateFuzzyItem(field, ast);
            }
        }
        throw YqlParser.newUnexpectedArgumentException(names.get(0), EQUIV, NEAR, ONEAR, PHRASE, SAME_ELEMENT, URI, FUZZY);
    }

    private Item instantiateFuzzyItem(String field, OperatorNode<ExpressionOperator> ast) {
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 argument, got %s.", (int)args.size());
        String wordData = this.getStringContents((OperatorNode)args.get(0));
        Integer maxEditDistance = this.getAnnotation(ast, MAX_EDIT_DISTANCE, Integer.class, FuzzyItem.DEFAULT_MAX_EDIT_DISTANCE, MAX_EDIT_DISTANCE_DESCRIPTION);
        Integer prefixLength = this.getAnnotation(ast, PREFIX_LENGTH, Integer.class, FuzzyItem.DEFAULT_PREFIX_LENGTH, PREFIX_LENGTH_DESCRIPTION);
        FuzzyItem fuzzy = new FuzzyItem(field, true, wordData, maxEditDistance, prefixLength);
        return this.leafStyleSettings(ast, fuzzy);
    }

    private Item instantiateEquivItem(String field, OperatorNode<ExpressionOperator> ast) {
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() >= 2 ? 1 : 0) != 0, (String)"Expected 2 or more arguments, got %s.", (int)args.size());
        EquivItem equiv = new EquivItem();
        equiv.setIndexName(field);
        block4: for (OperatorNode arg : args) {
            switch ((ExpressionOperator)arg.getOperator()) {
                case LITERAL: 
                case VARREF: {
                    equiv.addItem(this.instantiateWordItem(field, arg, equiv.getClass()));
                    continue block4;
                }
                case CALL: {
                    YqlParser.assertHasFunctionName(arg, PHRASE);
                    equiv.addItem(this.instantiatePhraseItem(field, arg));
                    continue block4;
                }
            }
            throw YqlParser.newUnexpectedArgumentException(arg.getOperator(), ExpressionOperator.CALL, ExpressionOperator.LITERAL, ExpressionOperator.VARREF);
        }
        return this.leafStyleSettings(ast, equiv);
    }

    private Item instantiateWordAlternativesItem(String field, OperatorNode<ExpressionOperator> ast) {
        List args = (List)((Object)ast.getArgument(1));
        Preconditions.checkArgument((args.size() >= 1 ? 1 : 0) != 0, (String)"Expected 1 or more arguments, got %s.", (int)args.size());
        Preconditions.checkArgument((((OperatorNode)args.get(0)).getOperator() == ExpressionOperator.MAP ? 1 : 0) != 0, (String)"Expected MAP, got %s.", ((OperatorNode)args.get(0)).getOperator());
        ArrayList<WordAlternativesItem.Alternative> terms = new ArrayList<WordAlternativesItem.Alternative>();
        List keys = (List)((OperatorNode)args.get(0)).getArgument(0);
        List values = (List)((OperatorNode)args.get(0)).getArgument(1);
        for (int i = 0; i < keys.size(); ++i) {
            OperatorNode value = (OperatorNode)values.get(i);
            if (value.getOperator() != ExpressionOperator.LITERAL) {
                throw YqlParser.newUnexpectedArgumentException(value.getOperator(), ExpressionOperator.LITERAL);
            }
            String term = (String)keys.get(i);
            double exactness = value.getArgument(0, Double.class);
            terms.add(new WordAlternativesItem.Alternative(term, exactness));
        }
        Substring origin = this.getOrigin(ast);
        Boolean isFromQuery = this.getAnnotation(ast, IMPLICIT_TRANSFORMS, Boolean.class, Boolean.TRUE, IMPLICIT_TRANSFORMS_DESCRIPTION);
        return this.leafStyleSettings(ast, new WordAlternativesItem(field, isFromQuery, origin, terms));
    }

    private UriItem instantiateUriItem(String field, OperatorNode<ExpressionOperator> ast) {
        UriItem uriItem = new UriItem(field);
        boolean startAnchorDefault = false;
        boolean endAnchorDefault = this.indexFactsSession.getIndex(field).isHostIndex();
        if (this.getAnnotation(ast, START_ANCHOR, Boolean.class, startAnchorDefault, "whether uri matching should be anchored to the start").booleanValue()) {
            uriItem.addStartAnchorItem();
        }
        String uriString = (String)((OperatorNode)((List)((Object)ast.getArgument(1))).get(0)).getArgument(0);
        for (String token : this.segmenter.segment(uriString, Language.ENGLISH)) {
            uriItem.addItem(new WordItem(token, field, true));
        }
        if (this.getAnnotation(ast, END_ANCHOR, Boolean.class, endAnchorDefault, "whether uri matching should be anchored to the end").booleanValue()) {
            uriItem.addEndAnchorItem();
        }
        uriItem.setStartAnchorDefault(startAnchorDefault);
        uriItem.setEndAnchorDefault(endAnchorDefault);
        uriItem.setSourceString(uriString);
        return uriItem;
    }

    private Item instantiateWordItem(String field, OperatorNode<ExpressionOperator> ast, Class<?> parent) {
        return this.instantiateWordItem(field, ast, parent, SegmentWhen.POSSIBLY);
    }

    private Item instantiateWordItem(String field, OperatorNode<ExpressionOperator> ast, Class<?> parent, SegmentWhen segmentPolicy) {
        String wordData = this.getStringContents(ast);
        return this.instantiateWordItem(field, wordData, ast, parent, segmentPolicy, null, this.decideParsingLanguage(ast, wordData));
    }

    private Item instantiateWordItem(String field, String rawWord, OperatorNode<ExpressionOperator> ast, Class<?> parent, SegmentWhen segmentPolicy, Boolean exactMatch, Language language) {
        TaggableItem wordItem;
        String wordData = rawWord;
        if (this.getAnnotation(ast, NFKC, Boolean.class, Boolean.FALSE, "setting for whether to NFKC normalize input data").booleanValue()) {
            wordData = this.normalizer.normalize(wordData);
        }
        boolean fromQuery = this.getAnnotation(ast, IMPLICIT_TRANSFORMS, Boolean.class, Boolean.TRUE, IMPLICIT_TRANSFORMS_DESCRIPTION);
        boolean prefixMatch = this.getAnnotation(ast, PREFIX, Boolean.class, Boolean.FALSE, "setting for whether to use prefix match of input data");
        boolean suffixMatch = this.getAnnotation(ast, SUFFIX, Boolean.class, Boolean.FALSE, "setting for whether to use suffix match of input data");
        boolean substrMatch = this.getAnnotation(ast, SUBSTRING, Boolean.class, Boolean.FALSE, "setting for whether to use substring match of input data");
        boolean exact = exactMatch != null ? exactMatch.booleanValue() : this.indexFactsSession.getIndex(this.indexNameExpander.expand(field)).isExact();
        String grammar = this.getAnnotation(ast, USER_INPUT_GRAMMAR, String.class, Query.Type.ALL.toString(), "grammar for handling word input");
        Preconditions.checkArgument(((prefixMatch ? 1 : 0) + (substrMatch ? 1 : 0) + (suffixMatch ? 1 : 0) < 2 ? 1 : 0) != 0, (Object)"Only one of prefix, substring and suffix can be set.");
        if (prefixMatch) {
            wordItem = new PrefixItem(wordData, fromQuery);
        } else if (suffixMatch) {
            wordItem = new SuffixItem(wordData, fromQuery);
        } else if (substrMatch) {
            wordItem = new SubstringItem(wordData, fromQuery);
        } else if (exact) {
            wordItem = new ExactStringItem(wordData, fromQuery);
        } else {
            switch (segmentPolicy) {
                case NEVER: {
                    wordItem = new WordItem(wordData, fromQuery);
                    break;
                }
                case POSSIBLY: {
                    if (this.shouldSegment(field, ast, fromQuery) && !grammar.equals(USER_INPUT_RAW)) {
                        wordItem = this.segment(field, ast, wordData, fromQuery, parent, language);
                        break;
                    }
                    wordItem = new WordItem(wordData, fromQuery);
                    break;
                }
                case ALWAYS: {
                    wordItem = this.segment(field, ast, wordData, fromQuery, parent, language);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected segmenting rule: " + segmentPolicy);
                }
            }
        }
        if (wordItem instanceof WordItem) {
            this.prepareWord(field, ast, (WordItem)wordItem);
        }
        if (language != Language.ENGLISH) {
            ((Item)((Object)wordItem)).setLanguage(language);
        }
        return this.leafStyleSettings(ast, wordItem);
    }

    private boolean shouldSegment(String field, OperatorNode<ExpressionOperator> ast, boolean fromQuery) {
        return fromQuery && !this.indexFactsSession.getIndex(this.indexNameExpander.expand(field)).isAttribute();
    }

    private TaggableItem segment(String field, OperatorNode<ExpressionOperator> ast, String wordData, boolean fromQuery, Class<?> parent, Language language) {
        Item wordItem;
        List words;
        Language usedLanguage;
        String toSegment = wordData;
        Substring s = this.getOrigin(ast);
        Language language2 = usedLanguage = language == null ? this.currentlyParsing.getLanguage() : language;
        if (s != null) {
            toSegment = s.getValue();
        }
        if ((words = this.segmenter.segment(toSegment, usedLanguage)).size() == 0) {
            wordItem = new WordItem(wordData, fromQuery);
        } else if (words.size() == 1 || !this.phraseArgumentSupported(parent)) {
            wordItem = new WordItem((String)words.get(0), fromQuery);
        } else {
            wordItem = new PhraseSegmentItem(toSegment, fromQuery, false);
            ((PhraseSegmentItem)wordItem).setIndexName(field);
            for (String w : words) {
                WordItem segment = new WordItem(w, fromQuery);
                this.prepareWord(field, ast, segment);
                ((PhraseSegmentItem)wordItem).addItem(segment);
            }
            ((PhraseSegmentItem)wordItem).lock();
        }
        return wordItem;
    }

    private boolean phraseArgumentSupported(Class<?> parent) {
        if (parent == null) {
            return true;
        }
        if (parent == PhraseItem.class) {
            return true;
        }
        return parent == EquivItem.class;
    }

    private void prepareWord(String field, OperatorNode<ExpressionOperator> ast, WordItem wordItem) {
        wordItem.setIndexName(field);
        this.wordStyleSettings(ast, wordItem);
    }

    private <T extends TaggableItem> T leafStyleSettings(OperatorNode<?> ast, T out) {
        Integer weight;
        String label;
        Boolean bl;
        Object uniqueId;
        Number significance;
        Map connectivity = this.getAnnotation(ast, CONNECTIVITY, Map.class, null, "connectivity settings");
        if (connectivity != null) {
            this.connectedItems.add(new ConnectedItem(out, YqlParser.getMapValue(CONNECTIVITY, connectivity, "id", Integer.class), YqlParser.getMapValue(CONNECTIVITY, connectivity, "weight", Number.class).doubleValue()));
        }
        if ((significance = (Number)this.getAnnotation(ast, SIGNIFICANCE, Number.class, null, "term significance")) != null) {
            out.setSignificance(significance.doubleValue());
        }
        if ((uniqueId = (Integer)this.getAnnotation(ast, "id", Integer.class, null, "term ID", false)) != null) {
            out.setUniqueID((Integer)uniqueId);
            this.identifiedItems.put((Integer)uniqueId, out);
        }
        Item leaf = (Item)((Object)out);
        Map itemAnnotations = this.getAnnotation(ast, ANNOTATIONS, Map.class, Collections.emptyMap(), "item annotation map");
        for (Map.Entry entry : itemAnnotations.entrySet()) {
            Preconditions.checkArgument((boolean)(entry.getKey() instanceof String), (String)"Expected String annotation key, got %s.", entry.getKey().getClass());
            Preconditions.checkArgument((boolean)(entry.getValue() instanceof String), (String)"Expected String annotation value, got %s.", entry.getValue().getClass());
            leaf.addAnnotation((String)entry.getKey(), entry.getValue());
        }
        Boolean filter = this.getAnnotation(ast, FILTER, Boolean.class, null, FILTER_DESCRIPTION);
        if (filter != null) {
            leaf.setFilter(filter);
        }
        if ((bl = (Boolean)this.getAnnotation(ast, RANKED, Boolean.class, null, RANKED_DESCRIPTION)) != null) {
            leaf.setRanked(bl);
        }
        if ((label = (String)this.getAnnotation(ast, LABEL, String.class, null, "item label")) != null) {
            leaf.setLabel(label);
        }
        if ((weight = (Integer)this.getAnnotation(ast, "weight", Integer.class, null, "term weight for ranking")) != null) {
            leaf.setWeight(weight);
        }
        if (out instanceof IntItem) {
            IntItem number = (IntItem)out;
            Integer hitLimit = this.getCappedRangeSearchParameter(ast);
            if (hitLimit != null) {
                number.setHitLimit(hitLimit);
            }
        }
        return out;
    }

    private Integer getCappedRangeSearchParameter(OperatorNode<?> ast) {
        Integer hitLimit = this.getAnnotation(ast, HIT_LIMIT, Integer.class, null, "hit limit");
        if (hitLimit != null) {
            Boolean ascending = this.getAnnotation(ast, ASCENDING_HITS_ORDER, Boolean.class, null, "ascending population ordering for capped range search");
            Boolean descending = this.getAnnotation(ast, DESCENDING_HITS_ORDER, Boolean.class, null, "descending population ordering for capped range search");
            Preconditions.checkArgument((ascending == null || descending == null ? 1 : 0) != 0, (Object)"Settings for both ascending and descending ordering set, only one of these expected.");
            if (Boolean.TRUE.equals(descending) || Boolean.FALSE.equals(ascending)) {
                hitLimit = hitLimit * -1;
            }
        }
        return hitLimit;
    }

    @Beta
    public boolean isQueryParser() {
        return this.queryParser;
    }

    @Beta
    public void setQueryParser(boolean queryParser) {
        this.queryParser = queryParser;
    }

    @Beta
    public void setUserQuery(Query userQuery) {
        this.userQuery = userQuery;
    }

    @Beta
    public Set<String> getYqlSummaryFields() {
        return this.yqlSummaryFields;
    }

    @Beta
    public List<VespaGroupingStep> getGroupingSteps() {
        return this.groupingSteps;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getHits() {
        return this.hits;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    Set<String> getDocTypes() {
        return this.docTypes;
    }

    Set<String> getYqlSources() {
        return this.yqlSources;
    }

    private static void assertHasOperator(OperatorNode<?> ast, Class<? extends Operator> expectedOperatorClass) {
        Preconditions.checkArgument((boolean)expectedOperatorClass.isInstance(ast.getOperator()), (String)"Expected operator class %s, got %s.", (Object)expectedOperatorClass.getName(), (Object)ast.getOperator().getClass().getName());
    }

    private static void assertHasOperator(OperatorNode<?> ast, Operator expectedOperator) {
        Preconditions.checkArgument((ast.getOperator() == expectedOperator ? 1 : 0) != 0, (String)"Expected operator %s, got %s.", (Object)expectedOperator, ast.getOperator());
    }

    private static void assertHasOperator(OperatorNode<?> ast, Operator expectedOperator, Supplier<String> errorMessage) {
        try {
            Preconditions.checkArgument((ast.getOperator() == expectedOperator ? 1 : 0) != 0);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage.get());
        }
    }

    private static void assertHasFunctionName(OperatorNode<?> ast, String expectedFunctionName) {
        List names = (List)ast.getArgument(0);
        Preconditions.checkArgument((boolean)expectedFunctionName.equals(names.get(0)), (String)"Expected function '%s', got '%s'.", (Object)expectedFunctionName, names.get(0));
    }

    private static void assertFieldName(OperatorNode<?> ast) {
        Preconditions.checkArgument((ast.getOperator() == ExpressionOperator.READ_FIELD || ast.getOperator() == ExpressionOperator.PROPREF ? 1 : 0) != 0, (String)"Expected operator READ_FIELD or PRPPREF, got %s.", ast.getOperator());
    }

    private void addItems(OperatorNode<ExpressionOperator> ast, WeightedSetItem out) {
        switch (ast.getOperator()) {
            case MAP: {
                YqlParser.addStringItems(ast, out);
                break;
            }
            case ARRAY: {
                YqlParser.addLongItems(ast, out);
                break;
            }
            case VARREF: {
                Preconditions.checkState((this.userQuery != null ? 1 : 0) != 0, (Object)"Query properties are not available");
                ParameterListParser.addItemsFromString(this.userQuery.properties().getString(ast.getArgument(0, String.class)), out);
                break;
            }
            default: {
                throw YqlParser.newUnexpectedArgumentException(ast.getOperator(), ExpressionOperator.ARRAY, ExpressionOperator.MAP);
            }
        }
    }

    private static void addStringItems(OperatorNode<ExpressionOperator> ast, WeightedSetItem out) {
        List keys = (List)((Object)ast.getArgument(0));
        List values = (List)((Object)ast.getArgument(1));
        for (int i = 0; i < keys.size(); ++i) {
            OperatorNode tokenWeight = (OperatorNode)values.get(i);
            YqlParser.assertHasOperator(tokenWeight, ExpressionOperator.LITERAL);
            out.addToken((String)keys.get(i), (int)tokenWeight.getArgument(0, Integer.class));
        }
    }

    private static void addLongItems(OperatorNode<ExpressionOperator> ast, WeightedSetItem out) {
        List values = (List)((Object)ast.getArgument(0));
        for (OperatorNode value : values) {
            YqlParser.assertHasOperator(value, ExpressionOperator.ARRAY);
            List args = (List)value.getArgument(0);
            Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Expected item and weight, got %s.", (Object)args);
            OperatorNode tokenValueNode = (OperatorNode)args.get(0);
            YqlParser.assertHasOperator(tokenValueNode, ExpressionOperator.LITERAL);
            Number tokenValue = tokenValueNode.getArgument(0, Number.class);
            Preconditions.checkArgument((tokenValue instanceof Integer || tokenValue instanceof Long ? 1 : 0) != 0, (String)"Expected Integer or Long, got %s.", (Object)tokenValue.getClass().getName());
            OperatorNode tokenWeightNode = (OperatorNode)args.get(1);
            YqlParser.assertHasOperator(tokenWeightNode, ExpressionOperator.LITERAL);
            Integer tokenWeight = tokenWeightNode.getArgument(0, Integer.class);
            out.addToken(tokenValue.longValue(), (int)tokenWeight);
        }
    }

    private void wordStyleSettings(OperatorNode<ExpressionOperator> ast, WordItem out) {
        Boolean andSegmenting;
        Boolean accentDrop;
        Boolean normalizeCase;
        Boolean stem;
        Boolean usePositionData;
        Substring origin = this.getOrigin(ast);
        if (origin != null) {
            out.setOrigin(origin);
        }
        if ((usePositionData = (Boolean)this.getAnnotation(ast, USE_POSITION_DATA, Boolean.class, null, USE_POSITION_DATA_DESCRIPTION)) != null) {
            out.setPositionData(usePositionData);
        }
        if ((stem = (Boolean)this.getAnnotation(ast, STEM, Boolean.class, null, STEM_DESCRIPTION)) != null) {
            out.setStemmed(stem == false);
        }
        if ((normalizeCase = (Boolean)this.getAnnotation(ast, NORMALIZE_CASE, Boolean.class, null, NORMALIZE_CASE_DESCRIPTION)) != null) {
            out.setLowercased(normalizeCase == false);
        }
        if ((accentDrop = (Boolean)this.getAnnotation(ast, ACCENT_DROP, Boolean.class, null, ACCENT_DROP_DESCRIPTION)) != null) {
            out.setNormalizable(accentDrop);
        }
        if ((andSegmenting = (Boolean)this.getAnnotation(ast, AND_SEGMENTING, Boolean.class, null, "setting for whether to force using AND for segments on and off")) != null) {
            if (andSegmenting.booleanValue()) {
                out.setSegmentingRule(SegmentingRule.BOOLEAN_AND);
            } else {
                out.setSegmentingRule(SegmentingRule.PHRASE);
            }
        }
    }

    private IndexNameExpander swapIndexCreator(IndexNameExpander newExpander) {
        IndexNameExpander old = this.indexNameExpander;
        this.indexNameExpander = newExpander;
        return old;
    }

    private String getIndex(OperatorNode<ExpressionOperator> operatorNode) {
        String index = YqlParser.fetchFieldRead(operatorNode);
        String expanded = this.indexNameExpander.expand(index);
        Preconditions.checkArgument((boolean)this.indexFactsSession.isIndex(expanded), (String)"Field '%s' does not exist.", (Object)expanded);
        return this.indexFactsSession.getCanonicName(index);
    }

    private Substring getOrigin(OperatorNode<ExpressionOperator> ast) {
        Map origin = this.getAnnotation(ast, ORIGIN, Map.class, null, ORIGIN_DESCRIPTION);
        if (origin == null) {
            return null;
        }
        String original = YqlParser.getMapValue(ORIGIN, origin, ORIGIN_ORIGINAL, String.class);
        int offset = YqlParser.getMapValue(ORIGIN, origin, ORIGIN_OFFSET, Integer.class);
        int length = YqlParser.getMapValue(ORIGIN, origin, ORIGIN_LENGTH, Integer.class);
        return new Substring(offset, length + offset, original);
    }

    private static <T> T getMapValue(String mapName, Map<?, ?> map, String key, Class<T> expectedValueClass) {
        Object value = map.get(key);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Map annotation '%s' must contain an entry with key '%s'.", (Object)mapName, (Object)key);
        Preconditions.checkArgument((boolean)expectedValueClass.isInstance(value), (String)"Expected %s for entry '%s' in map annotation '%s', got %s.", (Object)expectedValueClass.getName(), (Object)key, (Object)mapName, (Object)value.getClass().getName());
        return expectedValueClass.cast(value);
    }

    private <T> T getAnnotation(OperatorNode<?> ast, String key, Class<T> expectedClass, T defaultValue, String description) {
        return this.getAnnotation(ast, key, expectedClass, defaultValue, description, true);
    }

    private <T> T getAnnotation(OperatorNode<?> ast, String key, Class<T> expectedClass, T defaultValue, String description, boolean considerParents) {
        Object value = ast.getAnnotation(key);
        Iterator<OperatorNode<?>> i = this.annotationStack.iterator();
        while (value == null && considerParents && i.hasNext()) {
            OperatorNode<?> node = i.next();
            if (node.getOperator() == ExpressionOperator.VARREF) {
                Preconditions.checkState((this.userQuery != null ? 1 : 0) != 0, (Object)"properties must be available when trying to fetch user input");
                value = this.userQuery.properties().getString(ast.getArgument(0, String.class));
                continue;
            }
            value = node.getAnnotation(key);
        }
        if (value == null) {
            return defaultValue;
        }
        Preconditions.checkArgument((boolean)expectedClass.isInstance(value), (String)"Expected %s for annotation '%s' (%s), got %s.", (Object)expectedClass.getName(), (Object)key, (Object)description, (Object)value.getClass().getName());
        return expectedClass.cast(value);
    }

    private static IllegalArgumentException newUnexpectedArgumentException(Object actual, Object ... expected) {
        StringBuilder out = new StringBuilder("Expected ");
        int len = expected.length;
        for (int i = 0; i < len; ++i) {
            out.append(expected[i]);
            if (i < len - 2) {
                out.append(", ");
                continue;
            }
            if (i >= len - 1) continue;
            out.append(" or ");
        }
        out.append(", got ").append(actual).append(".");
        return new IllegalArgumentException(out.toString());
    }

    private static class IndexNameExpander {
        private IndexNameExpander() {
        }

        public String expand(String leaf) {
            return leaf;
        }
    }

    private static final class ConnectedItem {
        final double weight;
        final int toId;
        final TaggableItem fromItem;

        ConnectedItem(TaggableItem fromItem, int toId, double weight) {
            this.weight = weight;
            this.toId = toId;
            this.fromItem = fromItem;
        }
    }

    static interface AddFeature {
        public void addFeature(String var1, Object var2, long var3);
    }

    private static class PrefixExpander
    extends IndexNameExpander {
        private final String prefix;

        public PrefixExpander(String prefix) {
            this.prefix = prefix + ".";
        }

        @Override
        public String expand(String leaf) {
            return this.prefix + leaf;
        }
    }

    private static enum SegmentWhen {
        NEVER,
        POSSIBLY,
        ALWAYS;

    }

    private class AnnotationPropagator
    extends ToolBox.QueryVisitor {
        private final Boolean isRanked;
        private final Boolean filter;
        private final Boolean stem;
        private final Boolean normalizeCase;
        private final Boolean accentDrop;
        private final Boolean usePositionData;

        public AnnotationPropagator(OperatorNode<ExpressionOperator> ast) {
            this.isRanked = YqlParser.this.getAnnotation(ast, YqlParser.RANKED, Boolean.class, null, YqlParser.RANKED_DESCRIPTION);
            this.filter = YqlParser.this.getAnnotation(ast, YqlParser.FILTER, Boolean.class, null, YqlParser.FILTER_DESCRIPTION);
            this.stem = YqlParser.this.getAnnotation(ast, YqlParser.STEM, Boolean.class, null, YqlParser.STEM_DESCRIPTION);
            this.normalizeCase = YqlParser.this.getAnnotation(ast, YqlParser.NORMALIZE_CASE, Boolean.class, Boolean.TRUE, YqlParser.NORMALIZE_CASE_DESCRIPTION);
            this.accentDrop = YqlParser.this.getAnnotation(ast, YqlParser.ACCENT_DROP, Boolean.class, null, YqlParser.ACCENT_DROP_DESCRIPTION);
            this.usePositionData = YqlParser.this.getAnnotation(ast, YqlParser.USE_POSITION_DATA, Boolean.class, null, YqlParser.USE_POSITION_DATA_DESCRIPTION);
        }

        @Override
        public boolean visit(Item item) {
            if (item instanceof WordItem) {
                WordItem w = (WordItem)item;
                if (this.usePositionData != null) {
                    w.setPositionData(this.usePositionData);
                }
                if (this.stem != null) {
                    w.setStemmed(this.stem == false);
                }
                if (this.normalizeCase != null) {
                    w.setLowercased(this.normalizeCase == false);
                }
                if (this.accentDrop != null) {
                    w.setNormalizable(this.accentDrop);
                }
            }
            if (item instanceof TaggableItem) {
                if (this.isRanked != null) {
                    item.setRanked(this.isRanked);
                }
                if (this.filter != null) {
                    item.setFilter(this.filter);
                }
            }
            return true;
        }

        @Override
        public void onExit() {
        }
    }
}

