/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.prelude.query.FuzzyItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.ranking.RankProperties;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.yolean.chain.Before;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

@Before(value={"GroupingExecutor"})
public class ValidateFuzzySearcher
extends Searcher {
    private final Set<String> validAttributes = new HashSet<String>();

    public ValidateFuzzySearcher(AttributesConfig attributesConfig) {
        for (AttributesConfig.Attribute a : attributesConfig.attribute()) {
            if (a.datatype() != AttributesConfig.Attribute.Datatype.STRING) continue;
            this.validAttributes.add(a.name());
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        Optional<ErrorMessage> e = this.validate(query);
        return e.isEmpty() ? execution.search(query) : new Result(query, e.get());
    }

    private Optional<ErrorMessage> validate(Query query) {
        FuzzyVisitor visitor = new FuzzyVisitor(query.getRanking().getProperties(), this.validAttributes, query);
        ToolBox.visit(visitor, query.getModel().getQueryTree().getRoot());
        return visitor.errorMessage;
    }

    private static class FuzzyVisitor
    extends ToolBox.QueryVisitor {
        public Optional<ErrorMessage> errorMessage = Optional.empty();
        private final Set<String> validAttributes;
        private final Query query;

        public FuzzyVisitor(RankProperties rankProperties, Set<String> validAttributes, Query query) {
            this.validAttributes = validAttributes;
            this.query = query;
        }

        @Override
        public boolean visit(Item item) {
            String error;
            if (item instanceof FuzzyItem && (error = this.validate((FuzzyItem)item)) != null) {
                this.errorMessage = Optional.of(ErrorMessage.createIllegalQuery(error));
            }
            return true;
        }

        private String validate(FuzzyItem item) {
            if (!this.validAttributes.contains(item.getIndexName())) {
                return item + " field is not a string attribute";
            }
            if (item.getPrefixLength() < 0) {
                return item + " has invalid prefixLength " + item.getPrefixLength() + ": Must be >= 0";
            }
            if (item.getMaxEditDistance() < 0) {
                return item + " has invalid maxEditDistance " + item.getMaxEditDistance() + ": Must be >= 0";
            }
            if (item.stringValue().isEmpty()) {
                return item + " fuzzy query must be non-empty";
            }
            return null;
        }

        @Override
        public void onExit() {
        }
    }
}

