/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;

public class ConnectionControlSearcher
extends Searcher {
    private final String simpleName = ((Object)((Object)this)).getClass().getSimpleName();
    private final LongSupplier clock;
    private static final CompoundName KEEPALIVE_MAXLIFETIMESECONDS = new CompoundName("connectioncontrol.maxlifetime");
    private static final String HTTP_CONNECTION_HEADER_NAME = "Connection";
    private static final String HTTP_CONNECTION_CLOSE_ARGUMENT = "Close";

    public ConnectionControlSearcher() {
        this(() -> System.currentTimeMillis());
    }

    private ConnectionControlSearcher(LongSupplier clock) {
        this.clock = clock;
    }

    public static ConnectionControlSearcher createTestInstance(LongSupplier clock) {
        return new ConnectionControlSearcher(clock);
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result result = execution.search(query);
        query.trace(false, 3, this.simpleName, " updating headers.");
        this.keepAliveProcessing(query, result);
        return result;
    }

    private void keepAliveProcessing(Query query, Result result) {
        int maxLifetimeSeconds = query.properties().getInteger(KEEPALIVE_MAXLIFETIMESECONDS, -1);
        if (maxLifetimeSeconds < 0) {
            return;
        }
        if (maxLifetimeSeconds == 0) {
            result.getHeaders(true).put((Object)HTTP_CONNECTION_HEADER_NAME, (Object)HTTP_CONNECTION_CLOSE_ARGUMENT);
            query.trace(false, 5, this.simpleName, ": Max HTTP connection lifetime set to 0; adding \"", HTTP_CONNECTION_HEADER_NAME, ": ", HTTP_CONNECTION_CLOSE_ARGUMENT, "\" header");
        } else {
            this.setCloseIfLifetimeExceeded(query, result, maxLifetimeSeconds);
        }
    }

    private void setCloseIfLifetimeExceeded(Query query, Result result, int maxLifetimeSeconds) {
        long maxLifeTimeMillis;
        HttpRequest httpRequest = query.getHttpRequest();
        if (httpRequest == null) {
            query.trace(false, 5, this.simpleName, " got max lifetime = ", maxLifetimeSeconds, ", but got no JDisc request. Setting no header.");
            return;
        }
        long connectedAtMillis = httpRequest.getJDiscRequest().getConnectedAt(TimeUnit.MILLISECONDS);
        if (connectedAtMillis + (maxLifeTimeMillis = (long)maxLifetimeSeconds * 1000L) < this.clock.getAsLong()) {
            result.getHeaders(true).put((Object)HTTP_CONNECTION_HEADER_NAME, (Object)HTTP_CONNECTION_CLOSE_ARGUMENT);
            query.trace(false, 5, this.simpleName, ": Max HTTP connection lifetime (", maxLifetimeSeconds, ") exceeded; adding \"", HTTP_CONNECTION_HEADER_NAME, ": ", HTTP_CONNECTION_CLOSE_ARGUMENT, "\" header");
        }
    }
}

