/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainsConfigurer;
import com.yahoo.component.chain.model.ChainsModel;
import com.yahoo.component.chain.model.ChainsModelBuilder;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.SpecialTokenRegistry;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.IndexModel;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.rendering.RendererRegistry;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.vespa.configdefinition.SpecialtokensConfig;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutionFactory
extends AbstractComponent {
    private final SearchChainRegistry searchChainRegistry;
    private final IndexFacts indexFacts;
    private final SpecialTokenRegistry specialTokens;
    private final Linguistics linguistics;
    private final ThreadPoolExecutor renderingExecutor;
    private final RendererRegistry rendererRegistry;
    private final Executor executor;

    private static ThreadPoolExecutor createRenderingExecutor() {
        int threadCount = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadFactoryFactory.getThreadFactory((String)"common-rendering"));
        executor.prestartAllCoreThreads();
        return executor;
    }

    @Inject
    public ExecutionFactory(ChainsConfig chainsConfig, IndexInfoConfig indexInfo, QrSearchersConfig clusters, ComponentRegistry<Searcher> searchers, SpecialtokensConfig specialTokens, Linguistics linguistics, ComponentRegistry<Renderer> renderers, Executor executor) {
        this.searchChainRegistry = this.createSearchChainRegistry(searchers, chainsConfig);
        this.indexFacts = new IndexFacts(new IndexModel(indexInfo, clusters)).freeze();
        this.specialTokens = new SpecialTokenRegistry(specialTokens);
        this.linguistics = linguistics;
        this.renderingExecutor = ExecutionFactory.createRenderingExecutor();
        this.rendererRegistry = new RendererRegistry(renderers.allComponents(), this.renderingExecutor);
        this.executor = executor != null ? executor : Executors.newSingleThreadExecutor();
    }

    @Deprecated
    public ExecutionFactory(ChainsConfig chainsConfig, IndexInfoConfig indexInfo, QrSearchersConfig clusters, ComponentRegistry<Searcher> searchers, SpecialtokensConfig specialTokens, Linguistics linguistics, ComponentRegistry<Renderer> renderers) {
        this(chainsConfig, indexInfo, clusters, searchers, specialTokens, linguistics, renderers, null);
    }

    private SearchChainRegistry createSearchChainRegistry(ComponentRegistry<Searcher> searchers, ChainsConfig chainsConfig) {
        SearchChainRegistry searchChainRegistry = new SearchChainRegistry(searchers);
        ChainsModel chainsModel = ChainsModelBuilder.buildFromConfig((ChainsConfig)chainsConfig);
        ChainsConfigurer.prepareChainRegistry((ComponentRegistry)searchChainRegistry, (ChainsModel)chainsModel, searchers);
        searchChainRegistry.freeze();
        return searchChainRegistry;
    }

    public Execution newExecution(Chain<? extends Searcher> searchChain) {
        return new Execution(searchChain, new Execution.Context(this.searchChainRegistry, this.indexFacts, this.specialTokens, this.rendererRegistry, this.linguistics, this.executor));
    }

    public Execution newExecution(String searchChainId) {
        return new Execution(this.searchChainRegistry().getChain(searchChainId), new Execution.Context(this.searchChainRegistry, this.indexFacts, this.specialTokens, this.rendererRegistry, this.linguistics, this.executor));
    }

    public SearchChainRegistry searchChainRegistry() {
        return this.searchChainRegistry;
    }

    public RendererRegistry rendererRegistry() {
        return this.rendererRegistry;
    }

    public void deconstruct() {
        this.rendererRegistry.deconstruct();
        this.renderingExecutor.shutdown();
        try {
            if (!this.renderingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.renderingExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.renderingExecutor.shutdownNow();
        }
    }

    public static ExecutionFactory empty() {
        return new ExecutionFactory(new ChainsConfig.Builder().build(), new IndexInfoConfig.Builder().build(), new QrSearchersConfig.Builder().build(), (ComponentRegistry<Searcher>)new ComponentRegistry(), new SpecialtokensConfig.Builder().build(), (Linguistics)new SimpleLinguistics(), (ComponentRegistry<Renderer>)new ComponentRegistry(), null);
    }
}

