/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.language.process.Embedder;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.SubstituteString;
import com.yahoo.search.query.profile.types.ConversionContext;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TensorFieldType
extends FieldType {
    private static final Pattern embedderArgumentRegexp = Pattern.compile("^([A-Za-z0-9_\\-.]+),\\s*([\"'].*[\"'])");
    private final TensorType type;

    public TensorFieldType(TensorType type) {
        this.type = type;
    }

    @Override
    public TensorType asTensorType() {
        return this.type;
    }

    @Override
    public Class getValueClass() {
        return Tensor.class;
    }

    @Override
    public String stringValue() {
        return this.type.toString();
    }

    @Override
    public String toString() {
        return "field type " + this.stringValue();
    }

    @Override
    public String toInstanceDescription() {
        return "a tensor";
    }

    @Override
    public Object convertFrom(Object o, QueryProfileRegistry registry) {
        return this.convertFrom(o, ConversionContext.empty());
    }

    @Override
    public Object convertFrom(Object o, ConversionContext context) {
        if (o instanceof SubstituteString) {
            return new SubstituteStringTensor((SubstituteString)o, this.type);
        }
        Tensor tensor = this.toTensor(o, context);
        if (tensor == null) {
            return null;
        }
        if (!tensor.type().isAssignableTo(this.type)) {
            throw new IllegalArgumentException("Require a tensor of type " + this.type);
        }
        return tensor;
    }

    private Tensor toTensor(Object o, ConversionContext context) {
        if (o instanceof Tensor) {
            return (Tensor)o;
        }
        if (o instanceof String && TensorFieldType.isEmbed((String)o)) {
            return TensorFieldType.embed((String)o, this.type, context);
        }
        if (o instanceof String) {
            return Tensor.from((TensorType)this.type, (String)((String)o));
        }
        return null;
    }

    static boolean isEmbed(String value) {
        return value.startsWith("embed(");
    }

    static Tensor embed(String s, TensorType type, ConversionContext context) {
        Embedder embedder;
        if (!s.endsWith(")")) {
            throw new IllegalArgumentException("Expected any string enclosed in embed(), but the argument does not end by ')'");
        }
        String argument = s.substring("embed(".length(), s.length() - 1);
        Matcher matcher = embedderArgumentRegexp.matcher(argument);
        if (matcher.matches()) {
            String embedderId = matcher.group(1);
            argument = matcher.group(2);
            if (!context.embedders().containsKey(embedderId)) {
                throw new IllegalArgumentException("Can't find embedder '" + embedderId + "'. Valid embedders are " + TensorFieldType.validEmbedders(context.embedders()));
            }
            embedder = context.embedders().get(embedderId);
        } else {
            if (context.embedders().size() == 0) {
                throw new IllegalStateException("No embedders provided");
            }
            if (context.embedders().size() > 1) {
                throw new IllegalArgumentException("Multiple embedders are provided but no embedder id is given. Valid embedders are " + TensorFieldType.validEmbedders(context.embedders()));
            }
            embedder = (Embedder)((Map.Entry)context.embedders().entrySet().stream().findFirst().get()).getValue();
        }
        return embedder.embed(TensorFieldType.removeQuotes(argument), TensorFieldType.toEmbedderContext(context), type);
    }

    private static String removeQuotes(String s) {
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String validEmbedders(Map<String, Embedder> embedders) {
        ArrayList embedderIds = new ArrayList();
        embedders.forEach((key, value) -> embedderIds.add(key));
        embedderIds.sort(null);
        return String.join((CharSequence)",", embedderIds);
    }

    private static Embedder.Context toEmbedderContext(ConversionContext context) {
        return new Embedder.Context(context.destination()).setLanguage(context.language());
    }

    public static TensorFieldType fromTypeString(String s) {
        return new TensorFieldType(TensorType.fromSpec((String)s));
    }

    private static class SubstituteStringTensor
    extends SubstituteString {
        private final TensorType type;

        SubstituteStringTensor(SubstituteString string, TensorType type) {
            super(string.components(), string.stringValue());
            this.type = type;
        }

        @Override
        public Object substitute(Map<String, String> context, Properties substitution) {
            String substituted = super.substitute(context, substitution).toString();
            return Tensor.from((TensorType)this.type, (String)substituted);
        }
    }
}

