/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.google.inject.Inject;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileCompiler;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.config.QueryProfileConfigurer;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;
import com.yahoo.yolean.UncheckedInterruptedException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

public class CompiledQueryProfileRegistry
extends ComponentRegistry<CompiledQueryProfile> {
    public static final CompiledQueryProfileRegistry empty = CompiledQueryProfileRegistry.createFrozen();
    private final QueryProfileTypeRegistry typeRegistry;

    @Inject
    public CompiledQueryProfileRegistry(QueryProfilesConfig config, Executor executor) {
        QueryProfileRegistry registry = QueryProfileConfigurer.createFromConfig(config);
        this.typeRegistry = registry.getTypeRegistry();
        int maxConcurrent = 1;
        LinkedBlockingQueue doneQ = new LinkedBlockingQueue();
        int started = 0;
        int completed = 0;
        try {
            for (QueryProfile inputProfile : registry.allComponents()) {
                this.abortIfInterrupted();
                if (started++ >= maxConcurrent) {
                    this.register((CompiledQueryProfile)doneQ.take());
                    ++completed;
                }
                executor.execute(() -> {
                    Thread self = Thread.currentThread();
                    int prevPriority = self.getPriority();
                    try {
                        self.setPriority(1);
                        doneQ.add(QueryProfileCompiler.compile(inputProfile, this));
                    }
                    finally {
                        self.setPriority(prevPriority);
                    }
                });
            }
            while (completed < started) {
                this.register((CompiledQueryProfile)doneQ.take());
                ++completed;
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException("Interrupted while waiting for compiled query profiles", true);
        }
    }

    private void abortIfInterrupted() {
        if (Thread.interrupted()) {
            throw new UncheckedInterruptedException("Interrupted while building query profile registry", true);
        }
    }

    public CompiledQueryProfileRegistry() {
        this(QueryProfileTypeRegistry.emptyFrozen());
    }

    public CompiledQueryProfileRegistry(QueryProfileTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public final void register(CompiledQueryProfile profile) {
        super.register(profile.getId(), (Object)profile);
    }

    public QueryProfileTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public CompiledQueryProfile findQueryProfile(String idString) {
        if (idString == null || idString.isEmpty()) {
            return (CompiledQueryProfile)this.getComponent("default");
        }
        ComponentSpecification id = new ComponentSpecification(idString);
        CompiledQueryProfile profile = (CompiledQueryProfile)this.getComponent(id);
        if (profile != null) {
            return profile;
        }
        return this.findPathParentQueryProfile(new ComponentSpecification(idString));
    }

    private CompiledQueryProfile findPathParentQueryProfile(ComponentSpecification id) {
        CompiledQueryProfile slashedProfile = (CompiledQueryProfile)this.getComponent(new ComponentSpecification(id.getName() + "/", id.getVersionSpecification()));
        if (slashedProfile != null && slashedProfile.getType() != null && slashedProfile.getType().getMatchAsPath()) {
            return slashedProfile;
        }
        int slashIndex = id.getName().lastIndexOf("/");
        if (slashIndex < 1) {
            return null;
        }
        String parentName = id.getName().substring(0, slashIndex);
        if (parentName.equals("")) {
            return null;
        }
        ComponentSpecification parentId = new ComponentSpecification(parentName, id.getVersionSpecification());
        CompiledQueryProfile pathParentProfile = (CompiledQueryProfile)this.getComponent(parentId);
        if (pathParentProfile != null && pathParentProfile.getType() != null && pathParentProfile.getType().getMatchAsPath()) {
            return pathParentProfile;
        }
        return this.findPathParentQueryProfile(parentId);
    }

    private static CompiledQueryProfileRegistry createFrozen() {
        CompiledQueryProfileRegistry registry = new CompiledQueryProfileRegistry();
        registry.freeze();
        return registry;
    }
}

