/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.QueryCanonicalizer;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.grouping.vespa.GroupingTransform;
import com.yahoo.search.grouping.vespa.HitConverter;
import com.yahoo.search.grouping.vespa.RequestBuilder;
import com.yahoo.search.grouping.vespa.ResultBuilder;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.searchlib.aggregation.Hit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@After(value={"GroupingValidated", "com.yahoo.search.querytransform.WandSearcher", "com.yahoo.search.querytransform.BooleanSearcher"})
@Provides(value={"GroupingExecutor", "queryCanonicalization"})
public class GroupingExecutor
extends Searcher {
    public static final String COMPONENT_NAME = "GroupingExecutor";
    private static final String GROUPING_LIST = "GroupingList";
    private static final CompoundName PROP_GROUPINGLIST = GroupingExecutor.newCompoundName("GroupingList");
    private static final Logger log = Logger.getLogger(GroupingExecutor.class.getName());
    private static final double DEFAULT_PRECISION_FACTOR = 1.0;
    private static final int DEFAULT_MAX_GROUPS = -1;
    private static final int DEFAULT_MAX_HITS = -1;
    private static final long DEFAULT_GLOBAL_MAX_GROUPS = -1L;

    GroupingExecutor() {
    }

    public GroupingExecutor(ComponentId componentId) {
        super(componentId);
    }

    @Override
    public Result search(Query query, Execution execution) {
        String error = QueryCanonicalizer.canonicalize(query);
        if (error != null) {
            return new Result(query, ErrorMessage.createIllegalQuery(error));
        }
        query.prepare();
        if (query.getSelect().getGrouping().isEmpty()) {
            return execution.search(query);
        }
        HashMap<Integer, Grouping> groupingMap = new HashMap<Integer, Grouping>();
        LinkedList<RequestContext> requestContextList = new LinkedList<RequestContext>();
        for (int i = 0; i < query.getSelect().getGrouping().size(); ++i) {
            requestContextList.add(this.convertRequest(query, query.getSelect().getGrouping().get(i), i, groupingMap));
        }
        if (groupingMap.isEmpty()) {
            return execution.search(query);
        }
        Result result = this.performSearch(query, execution, groupingMap);
        HitConverter hitConverter = new HitConverter(this, query);
        for (RequestContext context : requestContextList) {
            RootGroup group = this.convertResult(context, groupingMap, hitConverter);
            result.hits().add(group);
        }
        return result;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        HashMap<String, Result> summaryMap = new HashMap<String, Result>();
        Iterator<Object> it = result.hits().unorderedDeepIterator();
        while (it.hasNext()) {
            Result summaryResult;
            com.yahoo.search.result.Hit hit = it.next();
            Object metaData = hit.getSearcherSpecificMetaData(this);
            if (metaData instanceof String) {
                summaryClass = (String)metaData;
                hit.setSearcherSpecificMetaData(this, null);
            }
            if ((summaryResult = (Result)summaryMap.get(summaryClass)) == null) {
                summaryResult = new Result(result.getQuery());
                summaryMap.put(summaryClass, summaryResult);
            }
            summaryResult.hits().add(hit);
        }
        for (Map.Entry entry : summaryMap.entrySet()) {
            Result res = (Result)entry.getValue();
            execution.fill(res, (String)entry.getKey());
            result.hits().addErrorsFrom(res.hits());
        }
        Result defaultResult = (Result)summaryMap.get("");
        if (defaultResult != null) {
            for (com.yahoo.search.result.Hit hit : defaultResult.hits()) {
                hit.setFilled(null);
            }
        }
    }

    private RequestContext convertRequest(Query query, GroupingRequest req, int requestId, Map<Integer, Grouping> map) {
        RequestBuilder builder = new RequestBuilder(requestId);
        builder.setRootOperation(req.getRootOperation());
        builder.setDefaultSummaryName(query.getPresentation().getSummary());
        builder.setTimeZone(req.getTimeZone());
        builder.addContinuations(req.continuations());
        builder.setDefaultMaxGroups(req.defaultMaxGroups().orElse(-1));
        builder.setDefaultMaxHits(req.defaultMaxHits().orElse(-1));
        builder.setGlobalMaxGroups(req.globalMaxGroups().orElse(-1L));
        builder.setDefaultPrecisionFactor(req.defaultPrecisionFactor().orElse(1.0));
        builder.build();
        RequestContext ctx = new RequestContext(req, builder.getTransform());
        List<Grouping> grpList = builder.getRequestList();
        for (Grouping grp : grpList) {
            int grpId = map.size();
            grp.setId(grpId);
            map.put(grpId, grp);
            ctx.idList.add(grpId);
        }
        return ctx;
    }

    private RootGroup convertResult(RequestContext requestContext, Map<Integer, Grouping> groupingMap, HitConverter hitConverter) {
        ResultBuilder builder = new ResultBuilder();
        builder.setHitConverter(hitConverter);
        builder.setTransform(requestContext.transform);
        builder.setRequestId(requestContext.request.getRequestId());
        for (Integer grpId : requestContext.idList) {
            builder.addGroupingResult(groupingMap.get(grpId));
        }
        builder.build();
        return builder.getRoot();
    }

    private Result performSearch(Query query, Execution execution, Map<Integer, Grouping> groupingMap) {
        int lastPass = 0;
        for (Grouping grouping : groupingMap.values()) {
            if (grouping.useSinglePass()) continue;
            lastPass = Math.max(lastPass, grouping.getLevels().size());
        }
        Item origRoot = query.getModel().getQueryTree().getRoot();
        Result ret = null;
        Item baseRoot = origRoot;
        if (lastPass > 0) {
            baseRoot = origRoot.clone();
        }
        if (query.isTraceable(3) && query.getGroupingSessionCache()) {
            query.trace("Grouping in " + (lastPass + 1) + " passes. SessionId='" + query.getSessionId() + "'.", 3);
        }
        for (int pass = 0; pass <= lastPass; ++pass) {
            boolean firstPass = pass == 0;
            List<Grouping> passList = this.getGroupingListForPassN(groupingMap, pass);
            if (passList.isEmpty()) {
                throw new RuntimeException("No grouping request for pass " + pass + ", bug!");
            }
            if (log.isLoggable(Level.FINE)) {
                for (Grouping grouping : passList) {
                    log.log(Level.FINE, "Pass(" + pass + "), Grouping(" + grouping.getId() + "): " + grouping);
                }
            }
            Item passRoot = firstPass ? origRoot : (pass == lastPass ? baseRoot : baseRoot.clone());
            if (query.isTraceable(4) && query.getGroupingSessionCache()) {
                query.trace("Grouping with session cache '" + query.getGroupingSessionCache() + "' enabled for pass #" + pass + ".", 4);
            }
            if (origRoot != passRoot) {
                query.getModel().getQueryTree().setRoot(passRoot);
            }
            GroupingExecutor.setGroupingList(query, passList);
            Result passResult = execution.search(query);
            Map<Integer, Grouping> passGroupingMap = this.mergeGroupingResults(passResult);
            this.mergeGroupingMaps(groupingMap, passGroupingMap);
            if (firstPass) {
                ret = passResult;
                continue;
            }
            ret.hits().addErrorsFrom(passResult.hits());
        }
        if (log.isLoggable(Level.FINE)) {
            for (Grouping grouping : groupingMap.values()) {
                log.log(Level.FINE, "Result Grouping(" + grouping.getId() + "): " + grouping);
            }
        }
        return ret;
    }

    private void mergeGroupingMaps(Map<Integer, Grouping> state, Map<Integer, Grouping> result) {
        for (Grouping grouping : result.values()) {
            Grouping old = state.get(grouping.getId());
            if (old != null) {
                old.merge(grouping);
                continue;
            }
            log.warning("Got grouping result with unknown id: " + grouping);
        }
    }

    private List<Grouping> getGroupingListForPassN(Map<Integer, Grouping> groupingMap, int pass) {
        ArrayList<Grouping> ret = new ArrayList<Grouping>();
        for (Grouping grouping : groupingMap.values()) {
            if (grouping.useSinglePass()) {
                if (pass != 0) continue;
                grouping.setFirstLevel(0);
                grouping.setLastLevel(grouping.getLevels().size());
                ret.add(grouping);
                continue;
            }
            if (pass > grouping.getLevels().size()) continue;
            grouping.setFirstLevel(pass);
            grouping.setLastLevel(pass);
            ret.add(grouping);
        }
        return ret;
    }

    private Map<Integer, Grouping> mergeGroupingResults(Result result) {
        HashMap<Integer, Grouping> ret = new HashMap<Integer, Grouping>();
        Iterator<com.yahoo.search.result.Hit> i = result.hits().unorderedIterator();
        while (i.hasNext()) {
            com.yahoo.search.result.Hit hit = i.next();
            if (!(hit instanceof GroupingListHit)) continue;
            for (Grouping grp : ((GroupingListHit)hit).getGroupingList()) {
                grp.select(o -> o instanceof Hit && ((Hit)o).getContext() == null, o -> ((Hit)o).setContext((Object)hit));
                Grouping old = (Grouping)ret.get(grp.getId());
                if (old != null) {
                    old.merge(grp);
                    continue;
                }
                ret.put(grp.getId(), grp);
            }
            i.remove();
        }
        for (Grouping grouping : ret.values()) {
            grouping.postMerge();
        }
        return ret;
    }

    public static List<Grouping> getGroupingList(Query query) {
        Object obj = query.properties().get(PROP_GROUPINGLIST);
        if (!(obj instanceof List)) {
            return Collections.emptyList();
        }
        return (List)obj;
    }

    public static boolean hasGroupingList(Query query) {
        Object obj = query.properties().get(PROP_GROUPINGLIST);
        return obj instanceof List;
    }

    public static void setGroupingList(Query query, List<Grouping> list) {
        query.properties().set(PROP_GROUPINGLIST, list);
    }

    private static CompoundName newCompoundName(String name) {
        return new CompoundName(GroupingExecutor.class.getName() + "." + name);
    }

    private static class RequestContext {
        final List<Integer> idList = new LinkedList<Integer>();
        final GroupingRequest request;
        final GroupingTransform transform;

        RequestContext(GroupingRequest request, GroupingTransform transform) {
            this.request = request;
            this.transform = transform;
        }
    }
}

