/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.yahoo.api.annotations.Beta;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.searchchain.Execution;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
@Provides(value={"SelectParameterParsing"})
public class GroupingQueryParser
extends Searcher {
    public static final String SELECT_PARAMETER_PARSING = "SelectParameterParsing";
    public static final CompoundName PARAM_CONTINUE = new CompoundName("continue");
    public static final CompoundName PARAM_REQUEST = new CompoundName("select");
    public static final CompoundName PARAM_TIMEZONE = new CompoundName("timezone");
    @Beta
    public static final CompoundName PARAM_DEFAULT_MAX_HITS = new CompoundName("grouping.defaultMaxHits");
    @Beta
    public static final CompoundName PARAM_DEFAULT_MAX_GROUPS = new CompoundName("grouping.defaultMaxGroups");
    @Beta
    public static final CompoundName PARAM_DEFAULT_PRECISION_FACTOR = new CompoundName("grouping.defaultPrecisionFactor");
    @Beta
    public static final CompoundName GROUPING_GLOBAL_MAX_GROUPS = new CompoundName("grouping.globalMaxGroups");
    private static final ThreadLocal<ZoneCache> zoneCache = new ThreadLocal();

    @Override
    public Result search(Query query, Execution execution) {
        try {
            if (query.getHttpRequest().getProperty(GROUPING_GLOBAL_MAX_GROUPS.toString()) != null) {
                throw new IllegalInputException(GROUPING_GLOBAL_MAX_GROUPS + " must be specified in a query profile.");
            }
            String reqParam = query.properties().getString(PARAM_REQUEST);
            if (reqParam == null) {
                return execution.search(query);
            }
            List<Continuation> continuations = this.getContinuations(query.properties().getString(PARAM_CONTINUE));
            TimeZone zone = this.getTimeZone(query.properties().getString(PARAM_TIMEZONE, "utc"));
            for (GroupingOperation op : GroupingOperation.fromStringAsList(reqParam)) {
                GroupingRequest grpRequest = GroupingRequest.newInstance(query);
                grpRequest.setRootOperation(op);
                grpRequest.setTimeZone(zone);
                grpRequest.continuations().addAll(continuations);
                GroupingQueryParser.intProperty(query, PARAM_DEFAULT_MAX_GROUPS).ifPresent(grpRequest::setDefaultMaxGroups);
                GroupingQueryParser.intProperty(query, PARAM_DEFAULT_MAX_HITS).ifPresent(grpRequest::setDefaultMaxHits);
                GroupingQueryParser.longProperty(query, GROUPING_GLOBAL_MAX_GROUPS).ifPresent(grpRequest::setGlobalMaxGroups);
                GroupingQueryParser.doubleProperty(query, PARAM_DEFAULT_PRECISION_FACTOR).ifPresent(grpRequest::setDefaultPrecisionFactor);
            }
            return execution.search(query);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalInputException((Throwable)e);
        }
    }

    private List<Continuation> getContinuations(String param) {
        if (param == null) {
            return Collections.emptyList();
        }
        LinkedList<Continuation> ret = new LinkedList<Continuation>();
        for (String str : param.split(" ")) {
            ret.add(Continuation.fromString(str));
        }
        return ret;
    }

    private TimeZone getTimeZone(String name) {
        TimeZone timeZone;
        ZoneCache cache = zoneCache.get();
        if (cache == null) {
            cache = new ZoneCache();
            zoneCache.set(cache);
        }
        if ((timeZone = (TimeZone)cache.get(name)) == null) {
            timeZone = TimeZone.getTimeZone(name);
            cache.put(name, timeZone);
        }
        return timeZone;
    }

    private static OptionalInt intProperty(Query q, CompoundName name) {
        Integer val = q.properties().getInteger(name);
        return val != null ? OptionalInt.of(val) : OptionalInt.empty();
    }

    private static OptionalLong longProperty(Query q, CompoundName name) {
        Long val = q.properties().getLong(name);
        return val != null ? OptionalLong.of(val) : OptionalLong.empty();
    }

    private static OptionalDouble doubleProperty(Query q, CompoundName name) {
        Double val = q.properties().getDouble(name);
        return val != null ? OptionalDouble.of(val) : OptionalDouble.empty();
    }

    private static class ZoneCache
    extends LinkedHashMap<String, TimeZone> {
        ZoneCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TimeZone> entry) {
            return this.size() > 128;
        }
    }
}

