/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class ProviderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "a5a414cdb85d5f5bfb789d8742386919";
    public static final String CONFIG_DEF_NAME = "provider";
    public static final String CONFIG_DEF_NAMESPACE = "search.federation";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.federation", "node[].host string", "node[].port int", "path string default=\"\"", "maxConnections int default=10000", "maxConnectionPerRoute int default=10000", "socketBufferBytes int default=8192", "retries int default=1", "readTimeout double default=-1.0", "connectionTimeout double default=-1.0", "connectionPoolTimeout double default=-1.0", "yca.host string default=\"yca.host must be set explicitly\"", "yca.port int default=3128", "yca.useProxy bool default=false", "yca.applicationId string default=\"\"", "yca.ttl int default=0", "yca.retry int default=0", "queryType enum { LEGACY, PROGRAMMATIC, YQL, SELECT } default=LEGACY", "pingOption enum { DISABLE, NORMAL, YCA } default=NORMAL", "followRedirects bool default=true"};
    private final InnerNodeVector<Node> node;
    private final StringNode path;
    private final IntegerNode maxConnections;
    private final IntegerNode maxConnectionPerRoute;
    private final IntegerNode socketBufferBytes;
    private final IntegerNode retries;
    private final DoubleNode readTimeout;
    private final DoubleNode connectionTimeout;
    private final DoubleNode connectionPoolTimeout;
    private final Yca yca;
    private final QueryType queryType;
    private final PingOption pingOption;
    private final BooleanNode followRedirects;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ProviderConfig(Builder builder) {
        this(builder, true);
    }

    private ProviderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for provider must be initialized: " + builder.__uninitialized);
        }
        this.node = Node.createVector(builder.node);
        this.path = builder.path == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.path);
        this.maxConnections = builder.maxConnections == null ? new IntegerNode(10000) : new IntegerNode(builder.maxConnections.intValue());
        this.maxConnectionPerRoute = builder.maxConnectionPerRoute == null ? new IntegerNode(10000) : new IntegerNode(builder.maxConnectionPerRoute.intValue());
        this.socketBufferBytes = builder.socketBufferBytes == null ? new IntegerNode(8192) : new IntegerNode(builder.socketBufferBytes.intValue());
        this.retries = builder.retries == null ? new IntegerNode(1) : new IntegerNode(builder.retries.intValue());
        this.readTimeout = builder.readTimeout == null ? new DoubleNode(-1.0) : new DoubleNode(builder.readTimeout.doubleValue());
        this.connectionTimeout = builder.connectionTimeout == null ? new DoubleNode(-1.0) : new DoubleNode(builder.connectionTimeout.doubleValue());
        this.connectionPoolTimeout = builder.connectionPoolTimeout == null ? new DoubleNode(-1.0) : new DoubleNode(builder.connectionPoolTimeout.doubleValue());
        this.yca = new Yca(builder.yca, throwIfUninitialized);
        this.queryType = builder.queryType == null ? new QueryType(QueryType.LEGACY) : new QueryType(builder.queryType);
        this.pingOption = builder.pingOption == null ? new PingOption(PingOption.NORMAL) : new PingOption(builder.pingOption);
        this.followRedirects = builder.followRedirects == null ? new BooleanNode(true) : new BooleanNode(builder.followRedirects.booleanValue());
    }

    public List<Node> node() {
        return this.node;
    }

    public Node node(int i) {
        return (Node)((Object)this.node.get(i));
    }

    public String path() {
        return this.path.value();
    }

    public int maxConnections() {
        return this.maxConnections.value();
    }

    public int maxConnectionPerRoute() {
        return this.maxConnectionPerRoute.value();
    }

    public int socketBufferBytes() {
        return this.socketBufferBytes.value();
    }

    public int retries() {
        return this.retries.value();
    }

    public double readTimeout() {
        return this.readTimeout.value();
    }

    public double connectionTimeout() {
        return this.connectionTimeout.value();
    }

    public double connectionPoolTimeout() {
        return this.connectionPoolTimeout.value();
    }

    public Yca yca() {
        return this.yca;
    }

    public QueryType.Enum queryType() {
        return (QueryType.Enum)((Object)this.queryType.value());
    }

    public PingOption.Enum pingOption() {
        return (PingOption.Enum)((Object)this.pingOption.value());
    }

    public boolean followRedirects() {
        return this.followRedirects.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ProviderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Node.Builder> node = new ArrayList<Node.Builder>();
        private String path = null;
        private Integer maxConnections = null;
        private Integer maxConnectionPerRoute = null;
        private Integer socketBufferBytes = null;
        private Integer retries = null;
        private Double readTimeout = null;
        private Double connectionTimeout = null;
        private Double connectionPoolTimeout = null;
        public Yca.Builder yca = new Yca.Builder();
        private QueryType.Enum queryType = null;
        private PingOption.Enum pingOption = null;
        private Boolean followRedirects = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ProviderConfig config) {
            for (Node n : config.node()) {
                this.node(new Node.Builder(n));
            }
            this.path(config.path());
            this.maxConnections(config.maxConnections());
            this.maxConnectionPerRoute(config.maxConnectionPerRoute());
            this.socketBufferBytes(config.socketBufferBytes());
            this.retries(config.retries());
            this.readTimeout(config.readTimeout());
            this.connectionTimeout(config.connectionTimeout());
            this.connectionPoolTimeout(config.connectionPoolTimeout());
            this.yca(new Yca.Builder(config.yca()));
            this.queryType(config.queryType());
            this.pingOption(config.pingOption());
            this.followRedirects(config.followRedirects());
        }

        private Builder override(Builder __superior) {
            if (!__superior.node.isEmpty()) {
                this.node.addAll(__superior.node);
            }
            if (__superior.path != null) {
                this.path(__superior.path);
            }
            if (__superior.maxConnections != null) {
                this.maxConnections(__superior.maxConnections);
            }
            if (__superior.maxConnectionPerRoute != null) {
                this.maxConnectionPerRoute(__superior.maxConnectionPerRoute);
            }
            if (__superior.socketBufferBytes != null) {
                this.socketBufferBytes(__superior.socketBufferBytes);
            }
            if (__superior.retries != null) {
                this.retries(__superior.retries);
            }
            if (__superior.readTimeout != null) {
                this.readTimeout(__superior.readTimeout);
            }
            if (__superior.connectionTimeout != null) {
                this.connectionTimeout(__superior.connectionTimeout);
            }
            if (__superior.connectionPoolTimeout != null) {
                this.connectionPoolTimeout(__superior.connectionPoolTimeout);
            }
            this.yca(this.yca.override(__superior.yca));
            if (__superior.queryType != null) {
                this.queryType(__superior.queryType);
            }
            if (__superior.pingOption != null) {
                this.pingOption(__superior.pingOption);
            }
            if (__superior.followRedirects != null) {
                this.followRedirects(__superior.followRedirects);
            }
            return this;
        }

        public Builder node(Node.Builder __builder) {
            this.node.add(__builder);
            return this;
        }

        public Builder node(Consumer<Node.Builder> __func) {
            Node.Builder __inner = new Node.Builder();
            __func.accept(__inner);
            this.node.add(__inner);
            return this;
        }

        public Builder node(List<Node.Builder> __builders) {
            this.node = __builders;
            return this;
        }

        public Builder path(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.path = __value;
            return this;
        }

        public Builder maxConnections(int __value) {
            this.maxConnections = __value;
            return this;
        }

        private Builder maxConnections(String __value) {
            return this.maxConnections(Integer.valueOf(__value));
        }

        public Builder maxConnectionPerRoute(int __value) {
            this.maxConnectionPerRoute = __value;
            return this;
        }

        private Builder maxConnectionPerRoute(String __value) {
            return this.maxConnectionPerRoute(Integer.valueOf(__value));
        }

        public Builder socketBufferBytes(int __value) {
            this.socketBufferBytes = __value;
            return this;
        }

        private Builder socketBufferBytes(String __value) {
            return this.socketBufferBytes(Integer.valueOf(__value));
        }

        public Builder retries(int __value) {
            this.retries = __value;
            return this;
        }

        private Builder retries(String __value) {
            return this.retries(Integer.valueOf(__value));
        }

        public Builder readTimeout(double __value) {
            this.readTimeout = __value;
            return this;
        }

        private Builder readTimeout(String __value) {
            return this.readTimeout(Double.valueOf(__value));
        }

        public Builder connectionTimeout(double __value) {
            this.connectionTimeout = __value;
            return this;
        }

        private Builder connectionTimeout(String __value) {
            return this.connectionTimeout(Double.valueOf(__value));
        }

        public Builder connectionPoolTimeout(double __value) {
            this.connectionPoolTimeout = __value;
            return this;
        }

        private Builder connectionPoolTimeout(String __value) {
            return this.connectionPoolTimeout(Double.valueOf(__value));
        }

        public Builder yca(Yca.Builder __builder) {
            this.yca = __builder;
            return this;
        }

        public Builder yca(Consumer<Yca.Builder> __func) {
            Yca.Builder __inner = new Yca.Builder();
            __func.accept(__inner);
            this.yca = __inner;
            return this;
        }

        public Builder queryType(QueryType.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.queryType = __value;
            return this;
        }

        private Builder queryType(String __value) {
            return this.queryType(QueryType.Enum.valueOf(__value));
        }

        public Builder pingOption(PingOption.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.pingOption = __value;
            return this;
        }

        private Builder pingOption(String __value) {
            return this.pingOption(PingOption.Enum.valueOf(__value));
        }

        public Builder followRedirects(boolean __value) {
            this.followRedirects = __value;
            return this;
        }

        private Builder followRedirects(String __value) {
            return this.followRedirects(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ProviderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ProviderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ProviderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ProviderConfig build() {
            return new ProviderConfig(this);
        }
    }

    public static final class Node
    extends InnerNode {
        private final StringNode host;
        private final IntegerNode port;

        public Node(Builder builder) {
            this(builder, true);
        }

        private Node(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for provider.node[] must be initialized: " + builder.__uninitialized);
            }
            this.host = builder.host == null ? new StringNode() : new StringNode(builder.host);
            this.port = builder.port == null ? new IntegerNode() : new IntegerNode(builder.port.intValue());
        }

        public String host() {
            return this.host.value();
        }

        public int port() {
            return this.port.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Node newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("node");
            return changes;
        }

        private static InnerNodeVector<Node> createVector(List<Builder> builders) {
            ArrayList<Node> elems = new ArrayList<Node>();
            for (Builder b : builders) {
                elems.add(new Node(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("host", "port"));
            private String host = null;
            private Integer port = null;

            public Builder() {
            }

            public Builder(Node config) {
                this.host(config.host());
                this.port(config.port());
            }

            private Builder override(Builder __superior) {
                if (__superior.host != null) {
                    this.host(__superior.host);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                return this;
            }

            public Builder host(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.host = __value;
                this.__uninitialized.remove("host");
                return this;
            }

            public Builder port(int __value) {
                this.port = __value;
                this.__uninitialized.remove("port");
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Node build() {
                return new Node(this);
            }
        }
    }

    public static final class Yca
    extends InnerNode {
        private final StringNode host;
        private final IntegerNode port;
        private final BooleanNode useProxy;
        private final StringNode applicationId;
        private final IntegerNode ttl;
        private final IntegerNode retry;

        public Yca(Builder builder) {
            this(builder, true);
        }

        private Yca(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for provider.yca must be initialized: " + builder.__uninitialized);
            }
            this.host = builder.host == null ? new StringNode("yca.host must be set explicitly") : new StringNode(builder.host);
            this.port = builder.port == null ? new IntegerNode(3128) : new IntegerNode(builder.port.intValue());
            this.useProxy = builder.useProxy == null ? new BooleanNode(false) : new BooleanNode(builder.useProxy.booleanValue());
            this.applicationId = builder.applicationId == null ? new StringNode(ProviderConfig.CONFIG_DEF_VERSION) : new StringNode(builder.applicationId);
            this.ttl = builder.ttl == null ? new IntegerNode(0) : new IntegerNode(builder.ttl.intValue());
            this.retry = builder.retry == null ? new IntegerNode(0) : new IntegerNode(builder.retry.intValue());
        }

        public String host() {
            return this.host.value();
        }

        public int port() {
            return this.port.value();
        }

        public boolean useProxy() {
            return this.useProxy.value();
        }

        public String applicationId() {
            return this.applicationId.value();
        }

        public int ttl() {
            return this.ttl.value();
        }

        public int retry() {
            return this.retry.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Yca newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("yca");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String host = null;
            private Integer port = null;
            private Boolean useProxy = null;
            private String applicationId = null;
            private Integer ttl = null;
            private Integer retry = null;

            public Builder() {
            }

            public Builder(Yca config) {
                this.host(config.host());
                this.port(config.port());
                this.useProxy(config.useProxy());
                this.applicationId(config.applicationId());
                this.ttl(config.ttl());
                this.retry(config.retry());
            }

            private Builder override(Builder __superior) {
                if (__superior.host != null) {
                    this.host(__superior.host);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                if (__superior.useProxy != null) {
                    this.useProxy(__superior.useProxy);
                }
                if (__superior.applicationId != null) {
                    this.applicationId(__superior.applicationId);
                }
                if (__superior.ttl != null) {
                    this.ttl(__superior.ttl);
                }
                if (__superior.retry != null) {
                    this.retry(__superior.retry);
                }
                return this;
            }

            public Builder host(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.host = __value;
                return this;
            }

            public Builder port(int __value) {
                this.port = __value;
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Builder useProxy(boolean __value) {
                this.useProxy = __value;
                return this;
            }

            private Builder useProxy(String __value) {
                return this.useProxy(Boolean.valueOf(__value));
            }

            public Builder applicationId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.applicationId = __value;
                return this;
            }

            public Builder ttl(int __value) {
                this.ttl = __value;
                return this;
            }

            private Builder ttl(String __value) {
                return this.ttl(Integer.valueOf(__value));
            }

            public Builder retry(int __value) {
                this.retry = __value;
                return this;
            }

            private Builder retry(String __value) {
                return this.retry(Integer.valueOf(__value));
            }

            public Yca build() {
                return new Yca(this);
            }
        }
    }

    public static final class QueryType
    extends EnumNode<Enum> {
        public static final Enum LEGACY = Enum.LEGACY;
        public static final Enum PROGRAMMATIC = Enum.PROGRAMMATIC;
        public static final Enum YQL = Enum.YQL;
        public static final Enum SELECT = Enum.SELECT;

        public QueryType() {
            this.value = null;
        }

        public QueryType(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            LEGACY,
            PROGRAMMATIC,
            YQL,
            SELECT;

        }
    }

    public static final class PingOption
    extends EnumNode<Enum> {
        public static final Enum DISABLE = Enum.DISABLE;
        public static final Enum NORMAL = Enum.NORMAL;
        public static final Enum YCA = Enum.YCA;

        public PingOption() {
            this.value = null;
        }

        public PingOption(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            DISABLE,
            NORMAL,
            YCA;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

