/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class FederationConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "0cea5264da0cb851f0ea85d9477a6724";
    public static final String CONFIG_DEF_NAME = "federation";
    public static final String CONFIG_DEF_NAMESPACE = "search.federation";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.federation", "target[].id string", "target[].useByDefault bool default=false", "target[].searchChain[].searchChainId string", "target[].searchChain[].timeoutMillis int default=-1", "target[].searchChain[].requestTimeoutMillis int default=-1", "target[].searchChain[].optional bool default=false", "target[].searchChain[].useByDefault bool default=false", "target[].searchChain[].providerId string default=\"\"", "target[].searchChain[].documentTypes[] string", "targetSelector string default=\"\""};
    private final InnerNodeVector<Target> target;
    private final StringNode targetSelector;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public FederationConfig(Builder builder) {
        this(builder, true);
    }

    private FederationConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for federation must be initialized: " + builder.__uninitialized);
        }
        this.target = Target.createVector(builder.target);
        this.targetSelector = builder.targetSelector == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.targetSelector);
    }

    public List<Target> target() {
        return this.target;
    }

    public Target target(int i) {
        return (Target)((Object)this.target.get(i));
    }

    public String targetSelector() {
        return this.targetSelector.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(FederationConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Target.Builder> target = new ArrayList<Target.Builder>();
        private String targetSelector = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(FederationConfig config) {
            for (Target t : config.target()) {
                this.target(new Target.Builder(t));
            }
            this.targetSelector(config.targetSelector());
        }

        private Builder override(Builder __superior) {
            if (!__superior.target.isEmpty()) {
                this.target.addAll(__superior.target);
            }
            if (__superior.targetSelector != null) {
                this.targetSelector(__superior.targetSelector);
            }
            return this;
        }

        public Builder target(Target.Builder __builder) {
            this.target.add(__builder);
            return this;
        }

        public Builder target(Consumer<Target.Builder> __func) {
            Target.Builder __inner = new Target.Builder();
            __func.accept(__inner);
            this.target.add(__inner);
            return this;
        }

        public Builder target(List<Target.Builder> __builders) {
            this.target = __builders;
            return this;
        }

        public Builder targetSelector(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.targetSelector = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return FederationConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return FederationConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return FederationConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public FederationConfig build() {
            return new FederationConfig(this);
        }
    }

    public static final class Target
    extends InnerNode {
        private final StringNode id;
        private final BooleanNode useByDefault;
        private final InnerNodeVector<SearchChain> searchChain;

        public Target(Builder builder) {
            this(builder, true);
        }

        private Target(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for federation.target[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.useByDefault = builder.useByDefault == null ? new BooleanNode(false) : new BooleanNode(builder.useByDefault.booleanValue());
            this.searchChain = SearchChain.createVector(builder.searchChain);
        }

        public String id() {
            return this.id.value();
        }

        public boolean useByDefault() {
            return this.useByDefault.value();
        }

        public List<SearchChain> searchChain() {
            return this.searchChain;
        }

        public SearchChain searchChain(int i) {
            return (SearchChain)((Object)this.searchChain.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Target newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("target");
            return changes;
        }

        private static InnerNodeVector<Target> createVector(List<Builder> builders) {
            ArrayList<Target> elems = new ArrayList<Target>();
            for (Builder b : builders) {
                elems.add(new Target(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
            private String id = null;
            private Boolean useByDefault = null;
            public List<SearchChain.Builder> searchChain = new ArrayList<SearchChain.Builder>();

            public Builder() {
            }

            public Builder(Target config) {
                this.id(config.id());
                this.useByDefault(config.useByDefault());
                for (SearchChain s : config.searchChain()) {
                    this.searchChain(new SearchChain.Builder(s));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.useByDefault != null) {
                    this.useByDefault(__superior.useByDefault);
                }
                if (!__superior.searchChain.isEmpty()) {
                    this.searchChain.addAll(__superior.searchChain);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder useByDefault(boolean __value) {
                this.useByDefault = __value;
                return this;
            }

            private Builder useByDefault(String __value) {
                return this.useByDefault(Boolean.valueOf(__value));
            }

            public Builder searchChain(SearchChain.Builder __builder) {
                this.searchChain.add(__builder);
                return this;
            }

            public Builder searchChain(Consumer<SearchChain.Builder> __func) {
                SearchChain.Builder __inner = new SearchChain.Builder();
                __func.accept(__inner);
                this.searchChain.add(__inner);
                return this;
            }

            public Builder searchChain(List<SearchChain.Builder> __builders) {
                this.searchChain = __builders;
                return this;
            }

            public Target build() {
                return new Target(this);
            }
        }

        public static final class SearchChain
        extends InnerNode {
            private final StringNode searchChainId;
            private final IntegerNode timeoutMillis;
            private final IntegerNode requestTimeoutMillis;
            private final BooleanNode optional;
            private final BooleanNode useByDefault;
            private final StringNode providerId;
            private final LeafNodeVector<String, StringNode> documentTypes;

            public SearchChain(Builder builder) {
                this(builder, true);
            }

            private SearchChain(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for federation.target[].searchChain[] must be initialized: " + builder.__uninitialized);
                }
                this.searchChainId = builder.searchChainId == null ? new StringNode() : new StringNode(builder.searchChainId);
                this.timeoutMillis = builder.timeoutMillis == null ? new IntegerNode(-1) : new IntegerNode(builder.timeoutMillis.intValue());
                this.requestTimeoutMillis = builder.requestTimeoutMillis == null ? new IntegerNode(-1) : new IntegerNode(builder.requestTimeoutMillis.intValue());
                this.optional = builder.optional == null ? new BooleanNode(false) : new BooleanNode(builder.optional.booleanValue());
                this.useByDefault = builder.useByDefault == null ? new BooleanNode(false) : new BooleanNode(builder.useByDefault.booleanValue());
                this.providerId = builder.providerId == null ? new StringNode(FederationConfig.CONFIG_DEF_VERSION) : new StringNode(builder.providerId);
                this.documentTypes = new LeafNodeVector(builder.documentTypes, (LeafNode)new StringNode());
            }

            public String searchChainId() {
                return this.searchChainId.value();
            }

            public int timeoutMillis() {
                return this.timeoutMillis.value();
            }

            public int requestTimeoutMillis() {
                return this.requestTimeoutMillis.value();
            }

            public boolean optional() {
                return this.optional.value();
            }

            public boolean useByDefault() {
                return this.useByDefault.value();
            }

            public String providerId() {
                return this.providerId.value();
            }

            public List<String> documentTypes() {
                return this.documentTypes.asList();
            }

            public String documentTypes(int i) {
                return ((StringNode)this.documentTypes.get(i)).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(SearchChain newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("searchChain");
                return changes;
            }

            private static InnerNodeVector<SearchChain> createVector(List<Builder> builders) {
                ArrayList<SearchChain> elems = new ArrayList<SearchChain>();
                for (Builder b : builders) {
                    elems.add(new SearchChain(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("searchChainId"));
                private String searchChainId = null;
                private Integer timeoutMillis = null;
                private Integer requestTimeoutMillis = null;
                private Boolean optional = null;
                private Boolean useByDefault = null;
                private String providerId = null;
                public List<String> documentTypes = new ArrayList<String>();

                public Builder() {
                }

                public Builder(SearchChain config) {
                    this.searchChainId(config.searchChainId());
                    this.timeoutMillis(config.timeoutMillis());
                    this.requestTimeoutMillis(config.requestTimeoutMillis());
                    this.optional(config.optional());
                    this.useByDefault(config.useByDefault());
                    this.providerId(config.providerId());
                    this.documentTypes(config.documentTypes());
                }

                private Builder override(Builder __superior) {
                    if (__superior.searchChainId != null) {
                        this.searchChainId(__superior.searchChainId);
                    }
                    if (__superior.timeoutMillis != null) {
                        this.timeoutMillis(__superior.timeoutMillis);
                    }
                    if (__superior.requestTimeoutMillis != null) {
                        this.requestTimeoutMillis(__superior.requestTimeoutMillis);
                    }
                    if (__superior.optional != null) {
                        this.optional(__superior.optional);
                    }
                    if (__superior.useByDefault != null) {
                        this.useByDefault(__superior.useByDefault);
                    }
                    if (__superior.providerId != null) {
                        this.providerId(__superior.providerId);
                    }
                    if (!__superior.documentTypes.isEmpty()) {
                        this.documentTypes.addAll(__superior.documentTypes);
                    }
                    return this;
                }

                public Builder searchChainId(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.searchChainId = __value;
                    this.__uninitialized.remove("searchChainId");
                    return this;
                }

                public Builder timeoutMillis(int __value) {
                    this.timeoutMillis = __value;
                    return this;
                }

                private Builder timeoutMillis(String __value) {
                    return this.timeoutMillis(Integer.valueOf(__value));
                }

                public Builder requestTimeoutMillis(int __value) {
                    this.requestTimeoutMillis = __value;
                    return this;
                }

                private Builder requestTimeoutMillis(String __value) {
                    return this.requestTimeoutMillis(Integer.valueOf(__value));
                }

                public Builder optional(boolean __value) {
                    this.optional = __value;
                    return this;
                }

                private Builder optional(String __value) {
                    return this.optional(Boolean.valueOf(__value));
                }

                public Builder useByDefault(boolean __value) {
                    this.useByDefault = __value;
                    return this;
                }

                private Builder useByDefault(String __value) {
                    return this.useByDefault(Boolean.valueOf(__value));
                }

                public Builder providerId(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.providerId = __value;
                    return this;
                }

                public Builder documentTypes(String __value) {
                    this.documentTypes.add(__value);
                    return this;
                }

                public Builder documentTypes(Collection<String> __values) {
                    this.documentTypes.addAll(__values);
                    return this;
                }

                public SearchChain build() {
                    return new SearchChain(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

